/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.net.URL;
import org.jboss.deployers.plugins.deployers.helpers.AttachmentLocator;
import org.jboss.deployers.plugins.deployers.helpers.ObjectModelFactoryDeployer;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentUnit;
import org.jboss.deployment.J2eeApplicationMetaData;
import org.jboss.deployment.JBossEjbObjectFactory;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;
import org.jboss.xb.binding.ObjectModelFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossEjbParsingDeployer
extends ObjectModelFactoryDeployer<ApplicationMetaData> {
    private String jbossXmlPath = "jboss.xml";

    public JBossEjbParsingDeployer() {
        super(ApplicationMetaData.class);
        this.setRelativeOrder(2001);
    }

    public String getWebXmlPath() {
        return this.jbossXmlPath;
    }

    public void setWebXmlPath(String jbossXmlPath) {
        this.jbossXmlPath = jbossXmlPath;
    }

    @Override
    protected boolean allowsReparse() {
        return true;
    }

    @Override
    protected ObjectModelFactory getObjectModelFactory(ApplicationMetaData root) {
        return new JBossEjbObjectFactory(root);
    }

    @Override
    public void deploy(DeploymentUnit unit) throws DeploymentException {
        VirtualFile ejbjar = unit.getMetaDataFile("ejb-jar.xml");
        if (ejbjar == null) {
            return;
        }
        this.log.debug("deploy, unit: " + unit);
        this.createMetaData(unit, this.jbossXmlPath, null);
        ApplicationMetaData metaData = (ApplicationMetaData)this.getMetaData(unit, ApplicationMetaData.class.getName());
        if (metaData == null) {
            return;
        }
        J2eeApplicationMetaData earMetaData = AttachmentLocator.search(unit, J2eeApplicationMetaData.class);
        if (earMetaData != null) {
            if (metaData.getSecurityDomain() == null) {
                metaData.setSecurityDomain(earMetaData.getSecurityDomain());
            }
            metaData.mergeSecurityRoles(earMetaData.getSecurityRoles());
        }
    }

    @Override
    protected ApplicationMetaData parse(DeploymentUnit unit, String name, ApplicationMetaData root) throws Exception {
        if (root.getEjbVersion() > 2) {
            return null;
        }
        String configPath = System.getProperty("jboss.server.config.url");
        URL configUrl = new URL(configPath);
        VirtualFile stdJBoss = VFS.getVirtualFile(configUrl, "standardjboss.xml");
        if (stdJBoss == null) {
            throw new DeploymentException("standardjboss.xml not found in config dir: " + configPath);
        }
        ApplicationMetaData result = this.parse(unit, stdJBoss, root);
        VirtualFile file = unit.getMetaDataFile(name);
        if (file == null) {
            return null;
        }
        result = this.parse(unit, file, root);
        this.init(unit, result, file);
        return result;
    }
}

