/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import org.jboss.deployers.spi.deployer.DeploymentUnit;
import org.jboss.deployment.security.JaccPolicyMBean;
import org.jboss.deployment.security.JaccPolicyUtil;
import org.jboss.ejb.EJBPermissionMapping;
import org.jboss.logging.Logger;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.WebMetaData;
import org.jboss.web.WebPermissionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaccPolicy
implements JaccPolicyMBean {
    private static Logger log = Logger.getLogger(JaccPolicy.class);
    private boolean trace = log.isTraceEnabled();
    private PolicyConfiguration parentPC = null;
    private String contextID = null;
    private List<String> subDeployments = new ArrayList<String>();
    public static String BASE_OBJECT_NAME = "jboss:service=jacc,id=";
    private int jaccDeploymentsCount = 0;

    public JaccPolicy(String id, DeploymentUnit unit, Collection<String> ignoreSuffix) {
        if (id == null) {
            throw new IllegalArgumentException("Jacc Context Id passed is null");
        }
        this.contextID = id;
        this.subDeployments.addAll(JaccPolicyUtil.getJaccDeployments(unit, ignoreSuffix));
        this.jaccDeploymentsCount = this.subDeployments.size();
    }

    @Override
    public void create() {
        try {
            PolicyConfigurationFactory pcf = PolicyConfigurationFactory.getPolicyConfigurationFactory();
            this.parentPC = pcf.getPolicyConfiguration(this.contextID, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot initialize policy configuration:", e);
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public PolicyConfiguration createPermissions(MetaData metadata, String jaccID, PolicyConfiguration pc) throws PolicyContextException {
        if (metadata instanceof WebMetaData) {
            WebMetaData wmd = (WebMetaData)metadata;
            if (pc == null) {
                pc = this.createPolicyConfiguration(jaccID, true);
            }
            WebPermissionMapping.createPermissions(wmd, pc);
        } else if (metadata instanceof BeanMetaData) {
            BeanMetaData bmd = (BeanMetaData)metadata;
            if (pc == null) {
                pc = this.createPolicyConfiguration(jaccID, true);
            }
            EJBPermissionMapping.createPermissions(bmd, pc);
        } else {
            throw new IllegalStateException("Unknown metadata");
        }
        return pc;
    }

    @Override
    public void link(PolicyConfiguration pc) throws PolicyContextException {
        if (this.jaccDeploymentsCount == 0) {
            return;
        }
        if (this.trace) {
            log.trace("Linking " + pc + " to parent pc=" + this.parentPC);
        }
        this.parentPC.linkConfiguration(pc);
        this.subDeployments.remove(pc.getContextID());
        if (this.subDeployments.size() == 0) {
            this.parentPC.commit();
        }
    }

    private PolicyConfiguration createPolicyConfiguration(String jaccid, boolean removeAllPerms) {
        if (jaccid == null) {
            throw new IllegalArgumentException("Jacc id is null");
        }
        PolicyConfiguration pc = null;
        try {
            PolicyConfigurationFactory pcf = PolicyConfigurationFactory.getPolicyConfigurationFactory();
            pc = pcf.getPolicyConfiguration(jaccid, removeAllPerms);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot initialize policy configuration:", e);
        }
        return pc;
    }
}

