/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.rmi.Remote;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteStub;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.SessionContext;
import javax.transaction.UserTransaction;
import org.jboss.ejb.plugins.HandleWrapper;
import org.jboss.ejb.plugins.StatefulSessionBeanField;

public class SessionObjectOutputStream
extends ObjectOutputStream {
    public SessionObjectOutputStream(OutputStream out) throws IOException {
        super(out);
        EnableReplaceObjectAction.enableReplaceObject(this);
    }

    protected Object replaceObject(Object obj) throws IOException {
        Object replacement = obj;
        if (obj instanceof EJBObject) {
            replacement = ((EJBObject)obj).getHandle();
        } else if (obj instanceof EJBHome) {
            replacement = ((EJBHome)obj).getHomeHandle();
        } else if (obj instanceof SessionContext) {
            replacement = new StatefulSessionBeanField(0);
        } else if (obj instanceof UserTransaction) {
            replacement = new StatefulSessionBeanField(1);
        } else if (obj instanceof Handle) {
            replacement = new HandleWrapper((Handle)obj);
        } else if (obj instanceof Remote && !(obj instanceof RemoteStub)) {
            Remote remote = (Remote)obj;
            try {
                replacement = RemoteObject.toStub(remote);
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        return replacement;
    }

    private static class EnableReplaceObjectAction
    implements PrivilegedAction {
        SessionObjectOutputStream os;

        EnableReplaceObjectAction(SessionObjectOutputStream os) {
            this.os = os;
        }

        public Object run() {
            this.os.enableReplaceObject(true);
            return null;
        }

        static void enableReplaceObject(SessionObjectOutputStream os) {
            EnableReplaceObjectAction action = new EnableReplaceObjectAction(os);
            AccessController.doPrivileged(action);
        }
    }
}

