/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc2;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.cmp.ejbql.Catalog;
import org.jboss.ejb.plugins.cmp.jdbc.QueryParameter;
import org.jboss.ejb.plugins.cmp.jdbc.SQLUtil;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCDeclaredQueryMetaData;
import org.jboss.ejb.plugins.cmp.jdbc2.AbstractQueryCommand;
import org.jboss.ejb.plugins.cmp.jdbc2.JDBCStoreManager2;
import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCCMPFieldBridge2;
import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCEntityBridge2;
import org.jboss.logging.Logger;

public class DeclaredSQLQueryCommand
extends AbstractQueryCommand {
    private JDBCCMPFieldBridge2 selectedField;

    public DeclaredSQLQueryCommand(JDBCEntityBridge2 entity, JDBCDeclaredQueryMetaData metadata) throws DeploymentException {
        this.initResultReader(entity, metadata);
        this.sql = this.buildSQL(metadata);
        this.sql = this.parseParameters(this.sql, metadata);
        this.setResultType(metadata.getMethod().getReturnType());
        this.log = Logger.getLogger(this.getClass().getName() + "." + entity.getEntityName() + "#" + metadata.getMethod().getName());
        this.log.debug("sql: " + this.sql);
    }

    private void initResultReader(JDBCEntityBridge2 entity, JDBCDeclaredQueryMetaData metadata) throws DeploymentException {
        String entityName = metadata.getEJBName();
        if (entityName != null) {
            Catalog catalog = entity.getManager().getCatalog();
            JDBCEntityBridge2 otherEntity = (JDBCEntityBridge2)catalog.getEntityByEJBName(entityName);
            if (otherEntity == null) {
                throw new DeploymentException("Unknown entity: " + entityName);
            }
            this.entity = otherEntity;
        } else {
            this.entity = entity;
        }
        String fieldName = metadata.getFieldName();
        if (fieldName == null) {
            this.setEntityReader(this.entity, metadata.isSelectDistinct());
        } else {
            this.selectedField = (JDBCCMPFieldBridge2)entity.getFieldByName(fieldName);
            if (this.selectedField == null) {
                throw new DeploymentException("Unknown cmp field: " + fieldName);
            }
            this.setFieldReader(this.selectedField);
        }
    }

    private String buildSQL(JDBCDeclaredQueryMetaData metadata) {
        String other;
        String order;
        String where;
        String selectList;
        String table;
        StringBuffer sql = new StringBuffer(300);
        sql.append("SELECT ");
        if (metadata.isSelectDistinct()) {
            sql.append("DISTINCT ");
        }
        String alias = metadata.getAlias();
        String from = metadata.getFrom();
        if (metadata.getFieldName() == null) {
            table = this.entity.getQualifiedTableName();
            String tableAlias = DeclaredSQLQueryCommand.getTableAlias(alias, from, this.entity.getTableName());
            selectList = SQLUtil.getColumnNamesClause(this.entity.getPrimaryKeyFields(), tableAlias, new StringBuffer(35)).toString();
        } else {
            JDBCStoreManager2 manager = (JDBCStoreManager2)this.selectedField.getManager();
            table = manager.getEntityBridge().getQualifiedTableName();
            selectList = SQLUtil.getColumnNamesClause(this.selectedField, DeclaredSQLQueryCommand.getTableAlias(alias, from, manager.getEntityBridge().getTableName()), new StringBuffer()).toString();
        }
        sql.append(selectList);
        String additionalColumns = metadata.getAdditionalColumns();
        if (additionalColumns != null) {
            sql.append(additionalColumns);
        }
        sql.append(" FROM ").append(table);
        if (alias != null) {
            sql.append(' ').append(alias);
        }
        if (from != null) {
            sql.append(' ').append(from);
        }
        if ((where = metadata.getWhere()) != null && where.trim().length() > 0) {
            sql.append(" WHERE ").append(where);
        }
        if ((order = metadata.getOrder()) != null && order.trim().length() > 0) {
            sql.append(" ORDER BY ").append(order);
        }
        if ((other = metadata.getOther()) != null && other.trim().length() > 0) {
            sql.append(' ').append(other);
        }
        return sql.toString();
    }

    private static String getTableAlias(String alias, String from, String table) {
        String tableAlias = alias != null ? alias : (from != null ? table : "");
        return tableAlias;
    }

    protected String parseParameters(String sql, JDBCDeclaredQueryMetaData metadata) throws DeploymentException {
        StringBuffer sqlBuf = new StringBuffer();
        ArrayList<QueryParameter> params = new ArrayList<QueryParameter>();
        if (sql != null) {
            sql = sql.trim();
            StringTokenizer tokens = new StringTokenizer(sql, "{}", true);
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if (token.equals("{")) {
                    token = tokens.nextToken();
                    if (Character.isDigit(token.charAt(0))) {
                        QueryParameter parameter = new QueryParameter(this.entity.getManager(), metadata.getMethod(), token);
                        sqlBuf.append("?");
                        params.add(parameter);
                        if (tokens.nextToken().equals("}")) continue;
                        throw new DeploymentException("Invalid parameter - missing closing '}' : " + sql);
                    }
                    sqlBuf.append("{").append(token);
                    continue;
                }
                sqlBuf.append(token);
            }
        }
        this.setParameters(params);
        return sqlBuf.toString();
    }
}

