/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.net.URL;
import javassist.bytecode.ClassFile;
import org.jboss.ejb3.Ejb3AnnotationHandler;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.Ejb3DescriptorHandler;
import org.jboss.ejb3.Ejb3Handler;
import org.jboss.ejb3.interceptor.InterceptorInfoRepository;
import org.jboss.ejb3.metamodel.EjbJarDD;
import org.jboss.ejb3.metamodel.EjbJarDDObjectFactory;
import org.jboss.ejb3.metamodel.JBossDDObjectFactory;

public abstract class Ejb3HandlerFactory {
    public abstract Ejb3Handler createHandler(ClassFile var1) throws Exception;

    public static Ejb3HandlerFactory getInstance(Ejb3Deployment di) throws Exception {
        URL ddResource = di.getDeploymentUnit().getEjbJarXml();
        URL jbossDdResource = di.getDeploymentUnit().getJbossXml();
        if (ddResource == null && jbossDdResource == null) {
            return new AnnotationFactory(di);
        }
        return new DDFactory(di);
    }

    private static class AnnotationFactory
    extends Ejb3HandlerFactory {
        private Ejb3Deployment di;

        public AnnotationFactory(Ejb3Deployment di) throws Exception {
            this.di = di;
        }

        public Ejb3Handler createHandler(ClassFile cf) throws Exception {
            return new Ejb3AnnotationHandler(this.di, cf);
        }
    }

    private static class DDFactory
    extends Ejb3HandlerFactory {
        private EjbJarDD dd;
        private Ejb3Deployment di;

        public DDFactory(Ejb3Deployment di) throws Exception {
            this.di = di;
            this.dd = EjbJarDDObjectFactory.parse(di.getDeploymentUnit().getEjbJarXml());
            this.dd = JBossDDObjectFactory.parse(di.getDeploymentUnit().getJbossXml(), this.dd);
            InterceptorInfoRepository repository = this.di.getDeploymentUnit().getInterceptorInfoRepository();
            repository.initialise(this.dd);
        }

        public Ejb3Handler createHandler(ClassFile cf) throws Exception {
            return new Ejb3DescriptorHandler(this.di, cf, this.dd);
        }
    }
}

