/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.delegate;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import javax.jms.JMSException;
import org.jboss.jms.client.state.HierarchicalState;
import org.jboss.jms.util.MessagingJMSException;
import org.jboss.jms.util.MessagingNetworkFailureException;
import org.jboss.jms.wireformat.RequestSupport;
import org.jboss.jms.wireformat.ResponseSupport;
import org.jboss.logging.Logger;
import org.jboss.messaging.util.Streamable;
import org.jboss.remoting.CannotConnectException;
import org.jboss.remoting.Client;
import org.jboss.remoting.ConnectionFailedException;

public abstract class DelegateSupport
implements Streamable,
Serializable {
    private static final Logger log = Logger.getLogger(DelegateSupport.class);
    private static boolean trace = log.isTraceEnabled();
    protected int id;
    protected transient HierarchicalState state;
    protected transient byte version;
    protected transient Client client;

    public DelegateSupport(int id) {
        this.id = id;
        this.state = null;
    }

    public DelegateSupport() {
        this(Integer.MIN_VALUE);
    }

    public String getName() {
        return this.getClass().getName();
    }

    public void read(DataInputStream in) throws Exception {
        this.id = in.readInt();
    }

    public void write(DataOutputStream out) throws Exception {
        out.writeInt(this.id);
    }

    public HierarchicalState getState() {
        return this.state;
    }

    public void setState(HierarchicalState state) {
        this.state = state;
        this.version = state.getVersionToUse().getProviderIncrementingVersion();
    }

    public int getID() {
        return this.id;
    }

    public void synchronizeWith(DelegateSupport newDelegate) throws Exception {
        this.id = newDelegate.getID();
    }

    protected Object doInvoke(Client client, RequestSupport req) throws JMSException {
        return this.doInvoke(client, req, false);
    }

    protected Object doInvokeOneway(Client client, RequestSupport req) throws JMSException {
        return this.doInvoke(client, req, true);
    }

    private Object doInvoke(Client client, RequestSupport req, boolean oneWay) throws JMSException {
        try {
            Object resp = null;
            if (oneWay) {
                if (trace) {
                    log.trace(this + " invoking " + req + " asynchronously on server using " + client);
                }
                client.invokeOneway(req);
                if (trace) {
                    log.trace(this + " asynchronously invoked " + req + " on server, no response expected");
                }
            } else {
                if (trace) {
                    log.trace(this + " invoking " + req + " synchronously on server using " + client);
                }
                resp = client.invoke(req);
                if (trace) {
                    log.trace(this + " got server response for " + req + ": " + resp);
                }
            }
            Object res = null;
            if (resp instanceof ResponseSupport) {
                res = ((ResponseSupport)resp).getResponse();
            }
            return res;
        }
        catch (Throwable t) {
            throw this.handleThrowable(t);
        }
    }

    public JMSException handleThrowable(Throwable t) {
        if (t instanceof JMSException) {
            return (JMSException)t;
        }
        if (t instanceof CannotConnectException || t instanceof IOException || t instanceof ConnectionFailedException) {
            log.warn("Captured Exception:" + t, t);
            return new MessagingNetworkFailureException((Exception)t);
        }
        log.error("Failed", t);
        return new MessagingJMSException("Failed to invoke", t);
    }

    public Client getClient() {
        return this.client;
    }
}

