/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.destination;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jboss.jms.selector.Selector;
import org.jboss.jms.server.JMSCondition;
import org.jboss.jms.server.destination.ManagedDestination;
import org.jboss.jms.server.destination.SubscriptionInfo;
import org.jboss.jms.server.messagecounter.MessageCounter;
import org.jboss.jms.util.MessageQueueNameHelper;
import org.jboss.messaging.core.Queue;
import org.jboss.messaging.core.message.Message;
import org.jboss.messaging.core.plugin.postoffice.Binding;

public class ManagedTopic
extends ManagedDestination {
    public ManagedTopic() {
    }

    public ManagedTopic(String name, int fullSize, int pageSize, int downCacheSize) {
        super(name, fullSize, pageSize, downCacheSize);
    }

    public void removeAllMessages() throws Throwable {
        JMSCondition topicCond = new JMSCondition(false, this.name);
        Collection subs = this.serverPeer.getPostOfficeInstance().getBindingsForCondition(topicCond);
        Iterator iter = subs.iterator();
        while (iter.hasNext()) {
            Binding binding = (Binding)iter.next();
            Queue queue = binding.getQueue();
            queue.removeAllReferences();
        }
    }

    public int getAllMessageCount() throws Exception {
        return this.getMessageCount(0);
    }

    public int getDurableMessageCount() throws Exception {
        return this.getMessageCount(1);
    }

    public int getNonDurableMessageCount() throws Exception {
        return this.getMessageCount(2);
    }

    public int getAllSubscriptionsCount() throws Exception {
        JMSCondition topicCond = new JMSCondition(false, this.name);
        Collection subs = this.serverPeer.getPostOfficeInstance().getBindingsForCondition(topicCond);
        return subs.size();
    }

    public int getDurableSubscriptionsCount() throws Exception {
        return this.getSubscriptionsCount(true);
    }

    public int getNonDurableSubscriptionsCount() throws Exception {
        return this.getSubscriptionsCount(false);
    }

    public List listAllSubscriptions() throws Exception {
        return this.listSubscriptions(0);
    }

    public List listDurableSubscriptions() throws Exception {
        return this.listSubscriptions(1);
    }

    public List listNonDurableSubscriptions() throws Exception {
        return this.listSubscriptions(2);
    }

    public String listAllSubscriptionsAsHTML() throws Exception {
        return this.listSubscriptionsAsHTML(0);
    }

    public String listDurableSubscriptionsAsHTML() throws Exception {
        return this.listSubscriptionsAsHTML(1);
    }

    public String listNonDurableSubscriptionsAsHTML() throws Exception {
        return this.listSubscriptionsAsHTML(2);
    }

    public List listAllMessages(String subId, String selector) throws Exception {
        return this.listMessages(0, subId, selector);
    }

    public List listDurableMessages(String subId, String selector) throws Exception {
        return this.listMessages(1, subId, selector);
    }

    public List listNonDurableMessages(String subId, String selector) throws Exception {
        return this.listMessages(2, subId, selector);
    }

    public List getMessageCounters() throws Exception {
        JMSCondition topicCond = new JMSCondition(false, this.name);
        ArrayList<MessageCounter> counters = new ArrayList<MessageCounter>();
        Collection bindings = this.serverPeer.getPostOfficeInstance().getBindingsForCondition(topicCond);
        Iterator iter = bindings.iterator();
        while (iter.hasNext()) {
            Binding binding = (Binding)iter.next();
            Queue queue = binding.getQueue();
            String counterName = "Subscription." + queue.getName();
            MessageCounter counter = this.serverPeer.getMessageCounterManager().getMessageCounter(counterName);
            if (counter == null) {
                throw new IllegalStateException("Cannot find counter with name " + counterName);
            }
            counters.add(counter);
        }
        return counters;
    }

    public boolean isQueue() {
        return false;
    }

    public void setMessageCounterHistoryDayLimit(int limit) throws Exception {
        super.setMessageCounterHistoryDayLimit(limit);
        List counters = this.getMessageCounters();
        Iterator iter = counters.iterator();
        while (iter.hasNext()) {
            MessageCounter counter = (MessageCounter)iter.next();
            counter.setHistoryLimit(limit);
        }
    }

    private List listMessages(int type, String subId, String selector) throws Exception {
        ArrayList<Message> msgs = new ArrayList<Message>();
        if (subId == null || "".equals(subId.trim())) {
            return msgs;
        }
        Binding binding = this.serverPeer.getPostOfficeInstance().getBindingForQueueName(subId);
        if (binding == null) {
            throw new IllegalArgumentException("Cannot find subscription with id " + subId);
        }
        Selector sel = null;
        if (selector != null && "".equals(selector.trim())) {
            selector = null;
        }
        if (selector != null) {
            sel = new Selector(selector);
        }
        List allMsgs = binding.getQueue().browse(sel);
        Iterator iter = allMsgs.iterator();
        while (iter.hasNext()) {
            Message msg = (Message)iter.next();
            if (type != 0 && (type != 1 || !msg.isReliable()) && (type != 2 || msg.isReliable())) continue;
            msgs.add(msg);
        }
        return msgs;
    }

    private List listSubscriptions(int type) throws Exception {
        ArrayList<SubscriptionInfo> subs = new ArrayList<SubscriptionInfo>();
        JMSCondition topicCond = new JMSCondition(false, this.name);
        Collection bindings = this.serverPeer.getPostOfficeInstance().getBindingsForCondition(topicCond);
        Iterator iter = bindings.iterator();
        while (iter.hasNext()) {
            Binding binding = (Binding)iter.next();
            Queue queue = binding.getQueue();
            if (type != 0 && (type != 1 || !queue.isRecoverable()) && (type != 2 || queue.isRecoverable())) continue;
            String subName = null;
            String clientID = null;
            if (queue.isRecoverable()) {
                MessageQueueNameHelper helper = MessageQueueNameHelper.createHelper(queue.getName());
                subName = helper.getSubName();
                clientID = helper.getClientId();
            }
            SubscriptionInfo info = new SubscriptionInfo(queue.getName(), queue.isRecoverable(), subName, clientID, queue.getFilter() == null ? null : queue.getFilter().getFilterString(), queue.getMessageCount(), queue.getMaxSize());
            subs.add(info);
        }
        return subs;
    }

    private int getMessageCount(int type) throws Exception {
        JMSCondition topicCond = new JMSCondition(false, this.name);
        Collection subs = this.serverPeer.getPostOfficeInstance().getBindingsForCondition(topicCond);
        Iterator iter = subs.iterator();
        int count = 0;
        while (iter.hasNext()) {
            Binding binding = (Binding)iter.next();
            if (type != 0 && (type != 1 || !binding.getQueue().isRecoverable()) && (type != 2 || binding.getQueue().isRecoverable())) continue;
            count += binding.getQueue().getMessageCount();
        }
        return count;
    }

    private int getSubscriptionsCount(boolean durable) throws Exception {
        JMSCondition topicCond = new JMSCondition(false, this.name);
        Collection subs = this.serverPeer.getPostOfficeInstance().getBindingsForCondition(topicCond);
        Iterator iter = subs.iterator();
        int count = 0;
        while (iter.hasNext()) {
            Binding binding = (Binding)iter.next();
            if ((!binding.getQueue().isRecoverable() || !durable) && (binding.getQueue().isRecoverable() || durable)) continue;
            ++count;
        }
        return count;
    }

    private String listSubscriptionsAsHTML(int type) throws Exception {
        JMSCondition topicCond = new JMSCondition(false, this.name);
        Collection bindings = this.serverPeer.getPostOfficeInstance().getBindingsForCondition(topicCond);
        StringBuffer sb = new StringBuffer();
        sb.append("<table width=\"100%\" border=\"1\" cellpadding=\"1\" cellspacing=\"1\"><tr><th>Id</th><th>Durable</th><th>Subscription Name</th><th>Client ID</th><th>Selector</th><th>Message Count</th><th>Max Size</th></tr>");
        Iterator iter = bindings.iterator();
        while (iter.hasNext()) {
            Binding binding = (Binding)iter.next();
            Queue queue = binding.getQueue();
            if (type != 0 && (type != 1 || !queue.isRecoverable()) && (type != 2 || queue.isRecoverable())) continue;
            String filterString = queue.getFilter() != null ? binding.getQueue().getFilter().getFilterString() : null;
            String subName = null;
            String clientID = null;
            if (queue.isRecoverable()) {
                MessageQueueNameHelper helper = MessageQueueNameHelper.createHelper(queue.getName());
                subName = helper.getSubName();
                clientID = helper.getClientId();
            }
            sb.append("<tr><td>").append(queue.getName()).append("</td>");
            sb.append("<td>").append(queue.isRecoverable() ? "Durable" : "Non Durable").append("</td>");
            sb.append("<td>").append(subName != null ? subName : "").append("</td>");
            sb.append("<td>").append(clientID != null ? clientID : "").append("</td>");
            sb.append("<td>").append(filterString != null ? filterString : "").append("</td>");
            sb.append("<td>").append(queue.getMessageCount()).append("</td>");
            sb.append("<td>").append(queue.getMaxSize()).append("</td>");
            sb.append("</tr>");
        }
        sb.append("</table>");
        return sb.toString();
    }
}

