/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.messagecounter;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import org.jboss.jms.server.messagecounter.MessageStatistics;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.Queue;

public class MessageCounter {
    protected static final Logger log = Logger.getLogger(MessageCounter.class);
    private String destName;
    private String destSubscription;
    private boolean destTopic;
    private boolean destDurable;
    private Queue destQueue;
    private int countTotal;
    private int countTotalLast;
    private int depthLast;
    private long timeLastUpdate;
    private int dayCounterMax;
    private ArrayList dayCounter;
    private int lastMessagesAdded;

    public static List getMessageStatistics(List counters) throws Exception {
        ArrayList<MessageStatistics> list2 = new ArrayList<MessageStatistics>(counters.size());
        Iterator iter = counters.iterator();
        while (iter.hasNext()) {
            MessageCounter counter = (MessageCounter)iter.next();
            MessageStatistics stats = new MessageStatistics();
            stats.setName(counter.getDestinationName());
            stats.setSubscriptionID(counter.getDestinationSubscription());
            stats.setTopic(counter.getDestinationTopic());
            stats.setDurable(counter.getDestinationDurable());
            stats.setCount(counter.getCount());
            stats.setCountDelta(counter.getCountDelta());
            stats.setDepth(counter.getMessageCount());
            stats.setDepthDelta(counter.getMessageCountDelta());
            stats.setTimeLastUpdate(counter.getLastUpdate());
            list2.add(stats);
        }
        return list2;
    }

    public MessageCounter(String name, String subscription, Queue queue, boolean topic, boolean durable, int daycountmax) {
        this.destName = name;
        this.destSubscription = subscription;
        this.destTopic = topic;
        this.destDurable = durable;
        this.destQueue = queue;
        this.resetCounter();
        this.dayCounter = new ArrayList();
        this.setHistoryLimit(daycountmax);
    }

    public String toString() {
        return this.getCounterAsString();
    }

    public synchronized void onTimer() {
        int latestMessagesAdded = this.destQueue.getMessagesAdded();
        int newMessagesAdded = latestMessagesAdded - this.lastMessagesAdded;
        this.countTotal += newMessagesAdded;
        this.lastMessagesAdded = latestMessagesAdded;
        this.timeLastUpdate = System.currentTimeMillis();
        this.updateHistory(true);
    }

    public String getDestinationName() {
        return this.destName;
    }

    public String getDestinationSubscription() {
        return this.destSubscription;
    }

    public boolean getDestinationTopic() {
        return this.destTopic;
    }

    public boolean getDestinationDurable() {
        return this.destDurable;
    }

    public int getCount() {
        return this.countTotal;
    }

    public int getCountDelta() {
        int delta = this.countTotal - this.countTotalLast;
        this.countTotalLast = this.countTotal;
        return delta;
    }

    public int getMessageCount() {
        return this.destQueue.getMessageCount();
    }

    public int getMessageCountDelta() {
        int current = this.destQueue.getMessageCount();
        int delta = current - this.depthLast;
        this.depthLast = current;
        return delta;
    }

    public long getLastUpdate() {
        return this.timeLastUpdate;
    }

    public void resetCounter() {
        this.countTotal = 0;
        this.countTotalLast = 0;
        this.depthLast = 0;
        this.timeLastUpdate = 0L;
    }

    public String getCounterAsString() {
        StringBuffer ret = new StringBuffer();
        if (this.destTopic) {
            ret.append("Topic,");
        } else {
            ret.append("Queue,");
        }
        ret.append(this.destName).append(",");
        if (this.destSubscription != null) {
            ret.append(this.destSubscription).append(",");
        } else {
            ret.append("-,");
        }
        if (this.destTopic) {
            if (this.destDurable) {
                ret.append("true,");
            } else {
                ret.append("false,");
            }
        } else {
            ret.append("-,");
        }
        ret.append(this.getCount()).append(",").append(this.getCountDelta()).append(",").append(this.getMessageCount()).append(",").append(this.getMessageCountDelta()).append(",");
        if (this.timeLastUpdate > 0L) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
            ret.append(dateFormat.format(new Date(this.timeLastUpdate)));
        } else {
            ret.append("-");
        }
        return ret.toString();
    }

    public int getHistoryLimit() {
        return this.dayCounterMax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHistoryLimit(int daycountmax) {
        boolean bInitialize = false;
        this.dayCounterMax = daycountmax;
        ArrayList arrayList = this.dayCounter;
        synchronized (arrayList) {
            if (this.dayCounterMax > 0) {
                int delta = this.dayCounter.size() - this.dayCounterMax;
                for (int i = 0; i < delta; ++i) {
                    this.dayCounter.remove(0);
                }
                bInitialize = this.dayCounter.isEmpty();
            } else if (this.dayCounterMax == 0) {
                this.dayCounter.clear();
            } else {
                bInitialize = this.dayCounter.isEmpty();
            }
            if (bInitialize) {
                this.dayCounter.add(new DayCounter(new GregorianCalendar(), true));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHistory(boolean incrementCounter) {
        if (this.dayCounter.isEmpty()) {
            return;
        }
        ArrayList arrayList = this.dayCounter;
        synchronized (arrayList) {
            DayCounter counterLast = (DayCounter)this.dayCounter.get(this.dayCounter.size() - 1);
            GregorianCalendar calNow = new GregorianCalendar();
            GregorianCalendar calLast = counterLast.getDate();
            calNow.clear(9);
            calNow.clear(10);
            calNow.clear(11);
            calNow.clear(12);
            calNow.clear(13);
            calNow.clear(14);
            calLast.clear(9);
            calLast.clear(10);
            calLast.clear(11);
            calLast.clear(12);
            calLast.clear(13);
            calLast.clear(14);
            long millisPerDay = 86400000L;
            long millisDelta = calNow.getTime().getTime() - calLast.getTime().getTime();
            int dayDelta = (int)(millisDelta / millisPerDay);
            if (dayDelta > 0) {
                DayCounter counterNew;
                counterLast.finalizeDayCounter();
                for (int i = 1; i < dayDelta; ++i) {
                    calLast.add(6, 1);
                    counterNew = new DayCounter(calLast, false);
                    counterNew.finalizeDayCounter();
                    this.dayCounter.add(counterNew);
                }
                counterNew = new DayCounter(calNow, false);
                this.dayCounter.add(counterNew);
                this.setHistoryLimit(this.dayCounterMax);
            }
            counterLast = (DayCounter)this.dayCounter.get(this.dayCounter.size() - 1);
            counterLast.updateDayCounter(incrementCounter);
        }
    }

    public void resetHistory() {
        int max = this.dayCounterMax;
        this.setHistoryLimit(0);
        this.setHistoryLimit(max);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHistoryAsString() {
        String ret = "";
        this.updateHistory(false);
        ArrayList arrayList = this.dayCounter;
        synchronized (arrayList) {
            ret = ret + this.dayCounter.size() + "\n";
            for (int i = 0; i < this.dayCounter.size(); ++i) {
                DayCounter counter = (DayCounter)this.dayCounter.get(i);
                ret = ret + counter.getDayCounterAsString() + "\n";
            }
        }
        return ret;
    }

    private static class DayCounter {
        static final int HOURS = 24;
        GregorianCalendar date = null;
        int[] counters = new int[24];

        DayCounter(GregorianCalendar date, boolean isStartDay) {
            this.date = (GregorianCalendar)date.clone();
            int hour = date.get(11);
            for (int i = 0; i < 24; ++i) {
                if (i < hour) {
                    if (isStartDay) {
                        this.counters[i] = -1;
                        continue;
                    }
                    this.counters[i] = 0;
                    continue;
                }
                this.counters[i] = -1;
            }
            this.counters[hour] = 0;
        }

        GregorianCalendar getDate() {
            return (GregorianCalendar)this.date.clone();
        }

        void updateDayCounter(boolean incrementCounter) {
            GregorianCalendar cal = new GregorianCalendar();
            int currentIndex = cal.get(11);
            boolean bUpdate = false;
            for (int i = 0; i <= currentIndex; ++i) {
                if (this.counters[i] > -1) {
                    bUpdate = true;
                }
                if (!bUpdate || this.counters[i] != -1) continue;
                this.counters[i] = 0;
            }
            if (incrementCounter) {
                int n = currentIndex;
                this.counters[n] = this.counters[n] + 1;
            }
        }

        void finalizeDayCounter() {
            boolean bFinalize = false;
            for (int i = 0; i < 24; ++i) {
                if (this.counters[i] > -1) {
                    bFinalize = true;
                }
                if (!bFinalize || this.counters[i] != -1) continue;
                this.counters[i] = 0;
            }
        }

        String getDayCounterAsString() {
            DateFormat dateFormat = DateFormat.getDateInstance(3);
            String strData = dateFormat.format(this.date.getTime());
            for (int i = 0; i < 24; ++i) {
                strData = strData + "," + this.counters[i];
            }
            return strData;
        }
    }
}

