/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.remoting;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.MBeanServer;
import org.jboss.jms.wireformat.ConnectionFactoryCreateConnectionDelegateRequest;
import org.jboss.jms.wireformat.RequestSupport;
import org.jboss.logging.Logger;
import org.jboss.messaging.util.Util;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.callback.ServerInvokerCallbackHandler;

public class JMSServerInvocationHandler
implements ServerInvocationHandler {
    private static final Logger log = Logger.getLogger(JMSServerInvocationHandler.class);
    private ServerInvoker invoker;
    private MBeanServer server;
    protected Map callbackHandlers = new HashMap();
    private boolean trace = log.isTraceEnabled();

    public void setMBeanServer(MBeanServer server) {
        this.server = server;
        log.debug("set MBeanServer to " + this.server);
    }

    public ServerInvoker getInvoker() {
        return this.invoker;
    }

    public void setInvoker(ServerInvoker invoker) {
        this.invoker = invoker;
        log.debug("set ServerInvoker to " + this.invoker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(InvocationRequest invocation) throws Throwable {
        RequestSupport request;
        if (this.trace) {
            log.trace("invoking " + invocation);
        }
        if ((request = (RequestSupport)invocation.getParameter()) instanceof ConnectionFactoryCreateConnectionDelegateRequest) {
            ConnectionFactoryCreateConnectionDelegateRequest cReq = (ConnectionFactoryCreateConnectionDelegateRequest)request;
            String remotingSessionId = cReq.getRemotingSessionID();
            ServerInvokerCallbackHandler callbackHandler = null;
            Map map = this.callbackHandlers;
            synchronized (map) {
                callbackHandler = (ServerInvokerCallbackHandler)this.callbackHandlers.get(remotingSessionId);
            }
            if (callbackHandler != null) {
                log.debug("found calllback handler for remoting session " + Util.guidToString(remotingSessionId));
                cReq.setCallbackHandler(callbackHandler);
            } else {
                throw new IllegalStateException("Cannot find callback handler for session id " + remotingSessionId);
            }
        }
        return request.serverInvoke();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(InvokerCallbackHandler callbackHandler) {
        log.debug("adding callback handler " + callbackHandler);
        if (callbackHandler instanceof ServerInvokerCallbackHandler) {
            ServerInvokerCallbackHandler h = (ServerInvokerCallbackHandler)callbackHandler;
            String sessionId = h.getClientSessionId();
            Map map = this.callbackHandlers;
            synchronized (map) {
                if (this.callbackHandlers.containsKey(sessionId)) {
                    String msg = "The remoting client " + sessionId + " already has a callback handler";
                    log.error(msg);
                    throw new IllegalStateException(msg);
                }
                this.callbackHandlers.put(sessionId, h);
            }
        } else {
            throw new RuntimeException("Do not know how to use callback handler " + callbackHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(InvokerCallbackHandler callbackHandler) {
        log.debug("removing callback handler " + callbackHandler);
        Map map = this.callbackHandlers;
        synchronized (map) {
            Iterator i = this.callbackHandlers.keySet().iterator();
            while (i.hasNext()) {
                Object key = i.next();
                if (!callbackHandler.equals(this.callbackHandlers.get(key))) continue;
                this.callbackHandlers.remove(key);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getListeners() {
        Map map = this.callbackHandlers;
        synchronized (map) {
            return this.callbackHandlers.values();
        }
    }

    public String toString() {
        return "JMSServerInvocationHandler[" + this.invoker + ", " + this.server + "]";
    }
}

