/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.tx;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.jms.message.JBossMessage;
import org.jboss.jms.server.endpoint.Ack;
import org.jboss.jms.server.endpoint.DefaultAck;
import org.jboss.jms.server.endpoint.DeliveryInfo;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.message.MessageFactory;

public class ClientTransaction {
    private static final Logger log = Logger.getLogger(ClientTransaction.class);
    public static final byte TX_OPEN = 0;
    public static final byte TX_ENDED = 1;
    public static final byte TX_PREPARED = 2;
    public static final byte TX_COMMITED = 3;
    public static final byte TX_ROLLEDBACK = 4;
    private static boolean trace = log.isTraceEnabled();
    private byte state = 0;
    private Map sessionStatesMap;
    private List sessionStatesList;
    private boolean clientSide = true;
    private boolean hasPersistentAcks;
    private boolean failedOver;

    public byte getState() {
        return this.state;
    }

    public void addMessage(int sessionId, JBossMessage msg) {
        if (!this.clientSide) {
            throw new IllegalStateException("Cannot call this method on the server side");
        }
        SessionTxState sessionTxState = this.getSessionTxState(sessionId);
        sessionTxState.addMessage(msg);
    }

    public void addAck(int sessionId, DeliveryInfo info) {
        if (!this.clientSide) {
            throw new IllegalStateException("Cannot call this method on the server side");
        }
        SessionTxState sessionTxState = this.getSessionTxState(sessionId);
        sessionTxState.addAck(info);
        if (info.getMessageProxy().getMessage().isReliable()) {
            this.hasPersistentAcks = true;
        }
    }

    public boolean hasPersistentAcks() {
        return this.hasPersistentAcks;
    }

    public boolean isFailedOver() {
        return this.failedOver;
    }

    public void clearMessages() {
        if (!this.clientSide) {
            throw new IllegalStateException("Cannot call this method on the server side");
        }
        if (this.sessionStatesMap != null) {
            Iterator i = this.sessionStatesMap.values().iterator();
            while (i.hasNext()) {
                SessionTxState sessionTxState = (SessionTxState)i.next();
                sessionTxState.clearMessages();
            }
        }
    }

    public void setState(byte state) {
        if (!this.clientSide) {
            throw new IllegalStateException("Cannot call this method on the server side");
        }
        this.state = state;
    }

    public List getSessionStates() {
        if (this.sessionStatesList != null) {
            return this.sessionStatesList;
        }
        return this.sessionStatesMap == null ? Collections.EMPTY_LIST : new ArrayList(this.sessionStatesMap.values());
    }

    public void handleFailover(int newServerID, int oldSessionID, int newSessionID) {
        if (!this.clientSide) {
            throw new IllegalStateException("Cannot call this method on the server side");
        }
        LinkedHashMap<Integer, SessionTxState> tmpMap = null;
        if (this.sessionStatesMap != null) {
            Iterator i = this.sessionStatesMap.values().iterator();
            while (i.hasNext()) {
                SessionTxState state = (SessionTxState)i.next();
                state.handleFailover(newServerID, oldSessionID, newSessionID);
                if (tmpMap == null) {
                    tmpMap = new LinkedHashMap<Integer, SessionTxState>();
                }
                tmpMap.put(new Integer(newSessionID), state);
            }
        }
        if (tmpMap != null) {
            this.sessionStatesMap = tmpMap;
        }
        this.failedOver = true;
    }

    public List getDeliveriesForSession(int sessionID) {
        if (!this.clientSide) {
            throw new IllegalStateException("Cannot call this method on the server side");
        }
        if (this.sessionStatesMap == null) {
            return Collections.EMPTY_LIST;
        }
        SessionTxState state = (SessionTxState)this.sessionStatesMap.get(new Integer(sessionID));
        if (state != null) {
            return state.getAcks();
        }
        return Collections.EMPTY_LIST;
    }

    public void write(DataOutputStream out) throws Exception {
        out.writeByte(this.state);
        if (this.sessionStatesMap == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.sessionStatesMap.size());
            Iterator iter = this.sessionStatesMap.values().iterator();
            while (iter.hasNext()) {
                SessionTxState state = (SessionTxState)iter.next();
                out.writeInt(state.getSessionId());
                List msgs = state.getMsgs();
                out.writeInt(msgs.size());
                Iterator iter2 = msgs.iterator();
                while (iter2.hasNext()) {
                    JBossMessage m = (JBossMessage)iter2.next();
                    out.writeByte(m.getType());
                    m.write(out);
                }
                List acks = state.getAcks();
                out.writeInt(acks.size());
                iter2 = acks.iterator();
                while (iter2.hasNext()) {
                    DeliveryInfo ack = (DeliveryInfo)iter2.next();
                    out.writeLong(ack.getMessageProxy().getDeliveryId());
                }
            }
        }
    }

    public void read(DataInputStream in) throws Exception {
        this.clientSide = false;
        this.state = in.readByte();
        int numSessions = in.readInt();
        this.sessionStatesList = new ArrayList(numSessions);
        for (int i = 0; i < numSessions; ++i) {
            int sessionId = in.readInt();
            SessionTxState sessionState = new SessionTxState(sessionId);
            this.sessionStatesList.add(sessionState);
            int numMsgs = in.readInt();
            for (int j = 0; j < numMsgs; ++j) {
                byte type = in.readByte();
                JBossMessage msg = (JBossMessage)MessageFactory.createMessage(type);
                msg.read(in);
                sessionState.addMessage(msg);
            }
            int numAcks = in.readInt();
            for (int j = 0; j < numAcks; ++j) {
                long ack = in.readLong();
                sessionState.addAck(new DefaultAck(ack));
            }
        }
    }

    private SessionTxState getSessionTxState(int sessionID) {
        SessionTxState sessionTxState;
        if (this.sessionStatesMap == null) {
            this.sessionStatesMap = new LinkedHashMap();
        }
        if ((sessionTxState = (SessionTxState)this.sessionStatesMap.get(new Integer(sessionID))) == null) {
            sessionTxState = new SessionTxState(sessionID);
            this.sessionStatesMap.put(new Integer(sessionID), sessionTxState);
        }
        return sessionTxState;
    }

    public class SessionTxState {
        private int sessionID;
        private int serverID = -1;
        private List msgs = new ArrayList();
        private List acks = new ArrayList();

        SessionTxState(int sessionID) {
            this.sessionID = sessionID;
        }

        void addMessage(JBossMessage msg) {
            this.msgs.add(msg);
        }

        void addAck(Ack ack) {
            this.acks.add(ack);
        }

        public List getMsgs() {
            return this.msgs;
        }

        public List getAcks() {
            return this.acks;
        }

        public int getSessionId() {
            return this.sessionID;
        }

        void handleFailover(int newServerID, int oldSessionID, int newSessionID) {
            if (this.sessionID == oldSessionID && this.serverID != newServerID) {
                this.sessionID = newSessionID;
                this.serverID = newServerID;
                Iterator i = this.acks.iterator();
                while (i.hasNext()) {
                    DeliveryInfo di = (DeliveryInfo)i.next();
                    if (di.getMessageProxy().getMessage().isReliable()) continue;
                    if (trace) {
                        log.trace(this + " discarded non-persistent " + di + " on failover");
                    }
                    i.remove();
                }
            }
        }

        void clearMessages() {
            this.msgs.clear();
        }
    }
}

