/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.wireformat;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.jboss.jms.wireformat.BrowserHasNextMessageRequest;
import org.jboss.jms.wireformat.BrowserHasNextMessageResponse;
import org.jboss.jms.wireformat.BrowserNextMessageBlockRequest;
import org.jboss.jms.wireformat.BrowserNextMessageBlockResponse;
import org.jboss.jms.wireformat.BrowserNextMessageRequest;
import org.jboss.jms.wireformat.BrowserNextMessageResponse;
import org.jboss.jms.wireformat.BrowserResetRequest;
import org.jboss.jms.wireformat.ClientDelivery;
import org.jboss.jms.wireformat.CloseRequest;
import org.jboss.jms.wireformat.ClosingRequest;
import org.jboss.jms.wireformat.ClosingResponse;
import org.jboss.jms.wireformat.ConnectionCreateSessionDelegateRequest;
import org.jboss.jms.wireformat.ConnectionCreateSessionDelegateResponse;
import org.jboss.jms.wireformat.ConnectionFactoryCreateConnectionDelegateRequest;
import org.jboss.jms.wireformat.ConnectionFactoryCreateConnectionDelegateResponse;
import org.jboss.jms.wireformat.ConnectionFactoryGetClientAOPStackRequest;
import org.jboss.jms.wireformat.ConnectionFactoryGetClientAOPStackResponse;
import org.jboss.jms.wireformat.ConnectionFactoryUpdate;
import org.jboss.jms.wireformat.ConnectionGetClientIDRequest;
import org.jboss.jms.wireformat.ConnectionGetClientIDResponse;
import org.jboss.jms.wireformat.ConnectionGetIDBlockRequest;
import org.jboss.jms.wireformat.ConnectionGetIDBlockResponse;
import org.jboss.jms.wireformat.ConnectionGetPreparedTransactionsRequest;
import org.jboss.jms.wireformat.ConnectionGetPreparedTransactionsResponse;
import org.jboss.jms.wireformat.ConnectionSendTransactionRequest;
import org.jboss.jms.wireformat.ConnectionSetClientIDRequest;
import org.jboss.jms.wireformat.ConnectionStartRequest;
import org.jboss.jms.wireformat.ConnectionStopRequest;
import org.jboss.jms.wireformat.ConsumerChangeRateRequest;
import org.jboss.jms.wireformat.NullResponse;
import org.jboss.jms.wireformat.PolledCallbacksDelivery;
import org.jboss.jms.wireformat.SerializedPacket;
import org.jboss.jms.wireformat.SessionAcknowledgeDeliveriesRequest;
import org.jboss.jms.wireformat.SessionAcknowledgeDeliveryRequest;
import org.jboss.jms.wireformat.SessionAddTemporaryDestinationRequest;
import org.jboss.jms.wireformat.SessionCancelDeliveriesRequest;
import org.jboss.jms.wireformat.SessionCancelDeliveryRequest;
import org.jboss.jms.wireformat.SessionCreateBrowserDelegateRequest;
import org.jboss.jms.wireformat.SessionCreateBrowserDelegateResponse;
import org.jboss.jms.wireformat.SessionCreateConsumerDelegateRequest;
import org.jboss.jms.wireformat.SessionCreateConsumerDelegateResponse;
import org.jboss.jms.wireformat.SessionCreateQueueRequest;
import org.jboss.jms.wireformat.SessionCreateQueueResponse;
import org.jboss.jms.wireformat.SessionCreateTopicRequest;
import org.jboss.jms.wireformat.SessionCreateTopicResponse;
import org.jboss.jms.wireformat.SessionDeleteTemporaryDestinationRequest;
import org.jboss.jms.wireformat.SessionRecoverDeliveriesRequest;
import org.jboss.jms.wireformat.SessionSendRequest;
import org.jboss.jms.wireformat.SessionUnsubscribeRequest;
import org.jboss.messaging.util.Streamable;

public abstract class PacketSupport
implements Streamable {
    private static final int NULL = 0;
    private static final int NOT_NULL = 1;
    protected static Map ONE_WAY_METADATA = new HashMap();
    public static final int SERIALIZED = 1;
    public static final int CLIENT_DELIVERY = 2;
    public static final int CONNECTIONFACTORY_UPDATE = 3;
    public static final int POLLEDCALLBACKS_DELIVERY = 4;
    public static final int REQ_CONNECTIONFACTORY_CREATECONNECTIONDELEGATE = 100;
    public static final int REQ_CONNECTIONFACTORY_GETIDBLOCK = 101;
    public static final int REQ_CONNECTIONFACTORY_GETCLIENTAOPSTACK = 102;
    public static final int REQ_CONNECTION_CREATESESSIONDELEGATE = 201;
    public static final int REQ_CONNECTION_GETCLIENTID = 202;
    public static final int REQ_CONNECTION_SETCLIENTID = 203;
    public static final int REQ_CONNECTION_START = 204;
    public static final int REQ_CONNECTION_STOP = 205;
    public static final int REQ_CONNECTION_SENDTRANSACTION = 206;
    public static final int REQ_CONNECTION_GETPREPAREDTRANSACTIONS = 207;
    public static final int REQ_SESSION_CREATECONSUMERDELEGATE = 301;
    public static final int REQ_SESSION_CREATEBROWSERDELEGATE = 302;
    public static final int REQ_SESSION_CREATEQUEUE = 303;
    public static final int REQ_SESSION_CREATETOPIC = 304;
    public static final int REQ_SESSION_ACKNOWLEDGEDELIVERIES = 305;
    public static final int REQ_SESSION_ACKNOWLEDGEDELIVERY = 306;
    public static final int REQ_SESSION_CANCELDELIVERIES = 307;
    public static final int REQ_SESSION_CANCELDELIVERY = 308;
    public static final int REQ_SESSION_ADDTEMPORARYDESTINATION = 309;
    public static final int REQ_SESSION_DELETETEMPORARYDESTINATION = 310;
    public static final int REQ_SESSION_UNSUBSCRIBE = 311;
    public static final int REQ_SESSION_SEND = 312;
    public static final int REQ_SESSION_RECOVERDELIVERIES = 313;
    public static final int REQ_CONSUMER_CHANGERATE = 401;
    public static final int REQ_BROWSER_NEXTMESSAGE = 501;
    public static final int REQ_BROWSER_HASNEXTMESSAGE = 502;
    public static final int REQ_BROWSER_NEXTMESSAGEBLOCK = 503;
    public static final int REQ_BROWSER_RESET = 504;
    public static final int REQ_CLOSING = 601;
    public static final int REQ_CLOSE = 602;
    public static final int NULL_RESPONSE = 100001;
    public static final int RESP_CONNECTIONFACTORY_CREATECONNECTIONDELEGATE = 100100;
    public static final int RESP_CONNECTIONFACTORY_GETIDBLOCK = 100101;
    public static final int RESP_CONNECTIONFACTORY_GETCLIENTAOPSTACK = 100102;
    public static final int RESP_CONNECTION_CREATESESSIONDELEGATE = 100200;
    public static final int RESP_CONNECTION_GETCLIENTID = 100201;
    public static final int RESP_CONNECTION_GETPREPAREDTRANSACTIONS = 100202;
    public static final int RESP_SESSION_CREATECONSUMERDELEGATE = 100300;
    public static final int RESP_SESSION_CREATEBROWSERDELEGATE = 100301;
    public static final int RESP_SESSION_CREATEQUEUE = 100302;
    public static final int RESP_SESSION_CREATETOPIC = 100303;
    public static final int RESP_BROWSER_NEXTMESSAGE = 100500;
    public static final int RESP_BROWSER_HASNEXTMESSAGE = 100501;
    public static final int RESP_BROWSER_NEXTMESSAGEBLOCK = 100502;
    public static final int RESP_CLOSING = 100601;
    protected int methodId;

    /*
     * WARNING - void declaration
     */
    public static PacketSupport createPacket(int id) {
        void var1_1;
        switch (id) {
            case 2: {
                PacketSupport packet = new ClientDelivery();
                break;
            }
            case 312: {
                PacketSupport packet = new SessionSendRequest();
                break;
            }
            case 306: {
                PacketSupport packet = new SessionAcknowledgeDeliveryRequest();
                break;
            }
            case 305: {
                PacketSupport packet = new SessionAcknowledgeDeliveriesRequest();
                break;
            }
            case 206: {
                PacketSupport packet = new ConnectionSendTransactionRequest();
                break;
            }
            case 401: {
                PacketSupport packet = new ConsumerChangeRateRequest();
                break;
            }
            case 100001: {
                PacketSupport packet = new NullResponse();
                break;
            }
            case 100: {
                PacketSupport packet = new ConnectionFactoryCreateConnectionDelegateRequest();
                break;
            }
            case 101: {
                PacketSupport packet = new ConnectionGetIDBlockRequest();
                break;
            }
            case 102: {
                PacketSupport packet = new ConnectionFactoryGetClientAOPStackRequest();
                break;
            }
            case 201: {
                PacketSupport packet = new ConnectionCreateSessionDelegateRequest();
                break;
            }
            case 202: {
                PacketSupport packet = new ConnectionGetClientIDRequest();
                break;
            }
            case 203: {
                PacketSupport packet = new ConnectionSetClientIDRequest();
                break;
            }
            case 204: {
                PacketSupport packet = new ConnectionStartRequest();
                break;
            }
            case 205: {
                PacketSupport packet = new ConnectionStopRequest();
                break;
            }
            case 207: {
                PacketSupport packet = new ConnectionGetPreparedTransactionsRequest();
                break;
            }
            case 301: {
                PacketSupport packet = new SessionCreateConsumerDelegateRequest();
                break;
            }
            case 302: {
                PacketSupport packet = new SessionCreateBrowserDelegateRequest();
                break;
            }
            case 303: {
                PacketSupport packet = new SessionCreateQueueRequest();
                break;
            }
            case 304: {
                PacketSupport packet = new SessionCreateTopicRequest();
                break;
            }
            case 307: {
                PacketSupport packet = new SessionCancelDeliveriesRequest();
                break;
            }
            case 308: {
                PacketSupport packet = new SessionCancelDeliveryRequest();
                break;
            }
            case 309: {
                PacketSupport packet = new SessionAddTemporaryDestinationRequest();
                break;
            }
            case 310: {
                PacketSupport packet = new SessionDeleteTemporaryDestinationRequest();
                break;
            }
            case 311: {
                PacketSupport packet = new SessionUnsubscribeRequest();
                break;
            }
            case 313: {
                PacketSupport packet = new SessionRecoverDeliveriesRequest();
                break;
            }
            case 501: {
                PacketSupport packet = new BrowserNextMessageRequest();
                break;
            }
            case 502: {
                PacketSupport packet = new BrowserHasNextMessageRequest();
                break;
            }
            case 503: {
                PacketSupport packet = new BrowserNextMessageBlockRequest();
                break;
            }
            case 504: {
                PacketSupport packet = new BrowserResetRequest();
                break;
            }
            case 602: {
                PacketSupport packet = new CloseRequest();
                break;
            }
            case 601: {
                PacketSupport packet = new ClosingRequest();
                break;
            }
            case 100100: {
                PacketSupport packet = new ConnectionFactoryCreateConnectionDelegateResponse();
                break;
            }
            case 100101: {
                PacketSupport packet = new ConnectionGetIDBlockResponse();
                break;
            }
            case 100102: {
                PacketSupport packet = new ConnectionFactoryGetClientAOPStackResponse();
                break;
            }
            case 100200: {
                PacketSupport packet = new ConnectionCreateSessionDelegateResponse();
                break;
            }
            case 100201: {
                PacketSupport packet = new ConnectionGetClientIDResponse();
                break;
            }
            case 100202: {
                PacketSupport packet = new ConnectionGetPreparedTransactionsResponse();
                break;
            }
            case 100300: {
                PacketSupport packet = new SessionCreateConsumerDelegateResponse();
                break;
            }
            case 100301: {
                PacketSupport packet = new SessionCreateBrowserDelegateResponse();
                break;
            }
            case 100302: {
                PacketSupport packet = new SessionCreateQueueResponse();
                break;
            }
            case 100303: {
                PacketSupport packet = new SessionCreateTopicResponse();
                break;
            }
            case 100500: {
                PacketSupport packet = new BrowserNextMessageResponse();
                break;
            }
            case 100501: {
                PacketSupport packet = new BrowserHasNextMessageResponse();
                break;
            }
            case 100502: {
                PacketSupport packet = new BrowserNextMessageBlockResponse();
                break;
            }
            case 100601: {
                PacketSupport packet = new ClosingResponse();
                break;
            }
            case 1: {
                PacketSupport packet = new SerializedPacket();
                break;
            }
            case 3: {
                PacketSupport packet = new ConnectionFactoryUpdate();
                break;
            }
            case 4: {
                PacketSupport packet = new PolledCallbacksDelivery();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid packet type: " + id);
            }
        }
        return var1_1;
    }

    public PacketSupport() {
    }

    public PacketSupport(int methodID) {
        this.methodId = methodID;
    }

    public Object getPayload() {
        return this;
    }

    public void write(DataOutputStream os) throws Exception {
        os.writeInt(this.methodId);
    }

    public abstract void read(DataInputStream var1) throws Exception;

    protected void writeNullableString(String s, DataOutputStream os) throws Exception {
        if (s == null) {
            os.writeByte(0);
        } else {
            os.writeByte(1);
            os.writeUTF(s);
        }
    }

    protected String readNullableString(DataInputStream is) throws Exception {
        byte b = is.readByte();
        if (b == 0) {
            return null;
        }
        return is.readUTF();
    }

    static {
        ONE_WAY_METADATA.put("oneway", "true");
    }
}

