/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.dependency.plugins.AbstractControllerContext;
import org.jboss.dependency.plugins.AbstractDependencyInfo;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.plugins.dependency.ClassContextDependencyItem;
import org.jboss.kernel.plugins.dependency.KernelControllerContextActions;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.util.JBossStringBuilder;

public class AbstractKernelControllerContext
extends AbstractControllerContext
implements KernelControllerContext {
    private static final KernelControllerContextActions actions = KernelControllerContextActions.getInstance();
    private static final KernelControllerContextActions noInstantiate = KernelControllerContextActions.getNoInstantiate();
    protected BeanInfo info;
    protected BeanMetaData metaData;
    protected AccessControlContext accessContext;
    protected boolean isInitialProcessed;
    protected boolean isDescribeProcessed;
    protected ScopeKey scope;

    public AbstractKernelControllerContext(BeanInfo info, BeanMetaData metaData, Object target) {
        super(metaData.getName(), target == null ? actions : noInstantiate, new AbstractDependencyInfo(), target);
        this.info = info;
        this.metaData = metaData;
        ControllerMode mode = metaData.getMode();
        if (mode != null) {
            this.setMode(mode);
        }
        if (System.getSecurityManager() != null) {
            this.accessContext = AccessController.getContext();
        }
    }

    public Kernel getKernel() {
        KernelController controller = (KernelController)this.getController();
        if (controller == null) {
            throw new IllegalStateException("Context is not installed in controller");
        }
        return controller.getKernel();
    }

    public BeanInfo getBeanInfo() {
        return this.info;
    }

    public void setBeanInfo(BeanInfo info) {
        this.info = info;
        this.infoprocessMetaData();
        this.flushJBossObjectCache();
    }

    public BeanMetaData getBeanMetaData() {
        return this.metaData;
    }

    public MetaData getMetaData() {
        KernelController controller = (KernelController)this.getController();
        if (controller == null) {
            throw new IllegalStateException("Context is not associated with a controller");
        }
        MutableMetaDataRepository repository = controller.getKernel().getMetaDataRepository().getMetaDataRepository();
        ScopeKey scope = this.getScope();
        return repository.getMetaData(scope);
    }

    public ScopeKey getScope() {
        if (this.scope == null) {
            KernelController controller = (KernelController)this.getController();
            if (controller == null) {
                return null;
            }
            KernelMetaDataRepository repository = controller.getKernel().getMetaDataRepository();
            this.scope = repository.getFullScope(this);
        }
        return this.scope;
    }

    public void setScope(ScopeKey key) {
        this.scope = key;
    }

    public void toString(JBossStringBuilder buffer) {
        if (this.metaData != null) {
            buffer.append(" metadata=").append(this.metaData);
        }
        super.toString(buffer);
    }

    public void setController(Controller controller) {
        super.setController(controller);
        this.preprocessMetaData();
    }

    protected void preprocessMetaData() {
        if (this.metaData == null) {
            return;
        }
        if (this.isInitialProcessed) {
            return;
        }
        PreprocessMetaDataVisitor visitor = new PreprocessMetaDataVisitor(this.metaData);
        AccessController.doPrivileged(visitor);
        this.isInitialProcessed = true;
    }

    protected void infoprocessMetaData() {
        if (this.info == null) {
            this.removeClassContextReference();
            return;
        }
        if (this.isDescribeProcessed) {
            return;
        }
        DescribedMetaDataVisitor visitor = new DescribedMetaDataVisitor(this.metaData);
        AccessController.doPrivileged(visitor);
        this.isDescribeProcessed = true;
    }

    protected AccessControlContext getAccessControlContext() {
        return this.accessContext;
    }

    private void removeClassContextReference() {
        DependencyInfo dependencyInfo = this.getDependencyInfo();
        if (dependencyInfo != null) {
            Set<DependencyItem> dependencys = dependencyInfo.getIDependOn(ClassContextDependencyItem.class);
            for (DependencyItem di : dependencys) {
                di.unresolved(this.getController());
            }
        }
    }

    public Object get(String name) throws Throwable {
        if (this.info == null) {
            throw new IllegalArgumentException("Null BeanInfo");
        }
        return this.info.getProperty(this.getTarget(), name);
    }

    public void set(String name, Object value) throws Throwable {
        if (this.info == null) {
            throw new IllegalArgumentException("Null BeanInfo");
        }
        this.info.setProperty(this.getTarget(), name, value);
    }

    public Object invoke(String name, Object[] parameters, String[] signature) throws Throwable {
        if (this.info == null) {
            throw new IllegalArgumentException("Null BeanInfo");
        }
        return this.info.invoke(this.getTarget(), name, signature, parameters);
    }

    public ClassLoader getClassLoader() throws Throwable {
        return Configurator.getClassLoader(this.getBeanMetaData());
    }

    protected class DescribedMetaDataVisitor
    extends AbstractMetaDataVistor {
        public DescribedMetaDataVisitor(BeanMetaData bmd) {
            super(bmd);
        }

        public Object run() {
            this.bmd.describeVisit(this);
            this.visitorNodeStack = null;
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void internalDescribeVisit(MetaDataVisitorNode node) {
            Iterator<? extends MetaDataVisitorNode> children;
            boolean trace = AbstractKernelControllerContext.this.log.isTraceEnabled();
            if (trace) {
                AbstractKernelControllerContext.this.log.trace("Describe visit node " + node);
            }
            if ((children = node.getChildren()) != null) {
                ControllerState restoreState = this.contextState;
                while (children.hasNext()) {
                    MetaDataVisitorNode child = children.next();
                    try {
                        child.describeVisit(this);
                    }
                    finally {
                        this.contextState = restoreState;
                    }
                }
            }
        }
    }

    protected class PreprocessMetaDataVisitor
    extends AbstractMetaDataVistor {
        public PreprocessMetaDataVisitor(BeanMetaData bmd) {
            super(bmd);
        }

        public Object run() {
            this.bmd.initialVisit(this);
            this.visitorNodeStack = null;
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void internalInitialVisit(MetaDataVisitorNode node) {
            Iterator<? extends MetaDataVisitorNode> children;
            boolean trace = AbstractKernelControllerContext.this.log.isTraceEnabled();
            if (trace) {
                AbstractKernelControllerContext.this.log.trace("Initial visit node " + node);
            }
            if ((children = node.getChildren()) != null) {
                ControllerState restoreState = this.contextState;
                while (children.hasNext()) {
                    MetaDataVisitorNode child = children.next();
                    try {
                        child.initialVisit(this);
                    }
                    finally {
                        this.contextState = restoreState;
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class AbstractMetaDataVistor
    implements MetaDataVisitor,
    PrivilegedAction<Object> {
        protected ControllerState contextState = ControllerState.INSTANTIATED;
        protected BeanMetaData bmd;
        protected Stack<MetaDataVisitorNode> visitorNodeStack;

        protected AbstractMetaDataVistor(BeanMetaData bmd) {
            this.bmd = bmd;
            this.visitorNodeStack = new Stack();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void initialVisit(MetaDataVisitorNode node) {
            this.visitorNodeStack.push(node);
            try {
                this.internalInitialVisit(node);
            }
            finally {
                this.visitorNodeStack.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void describeVisit(MetaDataVisitorNode node) {
            this.visitorNodeStack.push(node);
            try {
                this.internalDescribeVisit(node);
            }
            finally {
                this.visitorNodeStack.pop();
            }
        }

        protected void internalInitialVisit(MetaDataVisitorNode node) {
        }

        protected void internalDescribeVisit(MetaDataVisitorNode node) {
        }

        @Override
        public KernelControllerContext getControllerContext() {
            return AbstractKernelControllerContext.this;
        }

        @Override
        public ControllerState getContextState() {
            return this.contextState;
        }

        @Override
        public void addDependency(DependencyItem dependency) {
            AbstractKernelControllerContext.this.getDependencyInfo().addIDependOn(dependency);
        }

        @Override
        public void setContextState(ControllerState contextState) {
            this.contextState = contextState;
        }

        @Override
        public Stack<MetaDataVisitorNode> visitorNodeStack() {
            return this.visitorNodeStack;
        }
    }
}

