/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.managed.plugins.advice;

import java.util.Arrays;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.logging.Logger;

public class TraceAdvice {
    private static final Logger log = Logger.getLogger(TraceAdvice.class);

    public Object invoke(Invocation invocation) throws Throwable {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            this.logMethod(false, invocation, null, null);
        }
        Throwable e = null;
        Object result = null;
        try {
            Object object = result = invocation.invokeNext();
            return object;
        }
        catch (Throwable t) {
            e = t;
            throw t;
        }
        finally {
            this.logMethod(true, invocation, result, e);
        }
    }

    private void logMethod(boolean beforeAfter, Invocation invocation, Object result, Throwable t) {
        MethodInvocation mi = (MethodInvocation)invocation;
        StringBuilder builder = new StringBuilder();
        Object target = mi.getTargetObject();
        builder.append(target.getClass().getSimpleName());
        builder.append('@');
        builder.append(System.identityHashCode(target));
        if (!beforeAfter) {
            builder.append(" before ");
        } else {
            builder.append(" after  ");
        }
        builder.append(mi.getActualMethod().getName());
        if (!beforeAfter) {
            builder.append(" params=");
            builder.append(Arrays.asList(mi.getArguments()));
        } else if (t == null) {
            builder.append(" result=");
            builder.append(result);
        }
        if (t != null) {
            builder.append(" ended in error:");
        }
        log.trace(builder.toString(), t);
    }
}

