/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.plugin.postoffice;

import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.ReentrantWriterPreferenceReadWriteLock;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.Delivery;
import org.jboss.messaging.core.Filter;
import org.jboss.messaging.core.FilterFactory;
import org.jboss.messaging.core.Queue;
import org.jboss.messaging.core.local.PagingFilteredQueue;
import org.jboss.messaging.core.message.MessageReference;
import org.jboss.messaging.core.message.SimpleMessageReference;
import org.jboss.messaging.core.plugin.JDBCSupport;
import org.jboss.messaging.core.plugin.contract.ClusteredPostOffice;
import org.jboss.messaging.core.plugin.contract.Condition;
import org.jboss.messaging.core.plugin.contract.ConditionFactory;
import org.jboss.messaging.core.plugin.contract.MessageStore;
import org.jboss.messaging.core.plugin.contract.PersistenceManager;
import org.jboss.messaging.core.plugin.contract.PostOffice;
import org.jboss.messaging.core.plugin.postoffice.Binding;
import org.jboss.messaging.core.plugin.postoffice.Bindings;
import org.jboss.messaging.core.plugin.postoffice.DefaultBinding;
import org.jboss.messaging.core.plugin.postoffice.DefaultBindings;
import org.jboss.messaging.core.tx.Transaction;
import org.jboss.messaging.core.tx.TransactionRepository;

public class DefaultPostOffice
extends JDBCSupport
implements PostOffice {
    private static final Logger log = Logger.getLogger(DefaultPostOffice.class);
    private static boolean trace = log.isTraceEnabled();
    protected MessageStore ms;
    protected PersistenceManager pm;
    protected TransactionRepository tr;
    protected FilterFactory filterFactory;
    protected ConditionFactory conditionFactory;
    protected int currentNodeId;
    protected Map nameMaps;
    protected Map conditionMap;
    protected ReadWriteLock lock;
    private String officeName;

    public DefaultPostOffice() {
    }

    public DefaultPostOffice(DataSource ds, TransactionManager tm, Properties sqlProperties, boolean createTablesOnStartup, int nodeId, String officeName, MessageStore ms, PersistenceManager pm, TransactionRepository tr, FilterFactory filterFactory, ConditionFactory conditionFactory) {
        super(ds, tm, sqlProperties, createTablesOnStartup);
        this.lock = new ReentrantWriterPreferenceReadWriteLock();
        this.nameMaps = new LinkedHashMap();
        this.conditionMap = new LinkedHashMap();
        this.currentNodeId = nodeId;
        this.ms = ms;
        this.pm = pm;
        this.tr = tr;
        this.filterFactory = filterFactory;
        this.conditionFactory = conditionFactory;
        this.officeName = officeName;
    }

    public void start() throws Exception {
        if (trace) {
            log.trace(this + " starting");
        }
        super.start();
        this.loadBindings(false);
        log.debug(this + " started");
    }

    public void stop() throws Exception {
        this.stop(true);
    }

    public void stop(boolean sendNotification) throws Exception {
        if (trace) {
            log.trace(this + " stopping");
        }
        super.stop();
        log.debug(this + " stopped");
    }

    public String getOfficeName() {
        return this.officeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Binding bindQueue(Condition condition, Queue queue) throws Exception {
        if (trace) {
            log.trace(this + " binding queue " + queue.getName() + " with condition " + condition);
        }
        if (queue.getName() == null) {
            throw new IllegalArgumentException("Queue name is null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Condition is null");
        }
        this.lock.writeLock().acquire();
        try {
            Map nameMap = (Map)this.nameMaps.get(new Integer(this.currentNodeId));
            Binding binding = null;
            if (nameMap != null) {
                binding = (Binding)nameMap.get(queue.getName());
            }
            if (binding != null) {
                throw new IllegalArgumentException("Binding already exists for name " + queue.getName());
            }
            binding = new DefaultBinding(this.currentNodeId, condition, queue);
            this.addBinding(binding);
            if (queue.isRecoverable()) {
                this.insertBinding(binding);
            }
            Binding binding2 = binding;
            return binding2;
        }
        finally {
            this.lock.writeLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Binding unbindQueue(String queueName) throws Throwable {
        if (trace) {
            log.trace(this + " unbinding queue " + queueName);
        }
        if (queueName == null) {
            throw new IllegalArgumentException("Queue name is null");
        }
        this.lock.writeLock().acquire();
        try {
            Binding binding = this.removeBinding(this.currentNodeId, queueName);
            if (binding.getQueue().isRecoverable()) {
                this.deleteBinding(this.currentNodeId, binding.getQueue().getName());
            }
            binding.getQueue().removeAllReferences();
            Binding binding2 = binding;
            return binding2;
        }
        finally {
            this.lock.writeLock().release();
        }
    }

    public Collection getBindingsForCondition(Condition condition) throws Exception {
        return this.listBindingsForConditionInternal(condition, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Binding getBindingForQueueName(String queueName) throws Exception {
        if (queueName == null) {
            throw new IllegalArgumentException("Queue name is null");
        }
        this.lock.readLock().acquire();
        try {
            Binding binding = this.internalGetBindingForQueueName(queueName);
            return binding;
        }
        finally {
            this.lock.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean route(MessageReference ref, Condition condition, Transaction tx) throws Exception {
        if (trace) {
            log.trace(this + " routing " + ref + " with condition '" + condition + "' " + (tx == null ? "non-transactionally" : " in " + tx));
        }
        if (ref == null) {
            throw new IllegalArgumentException("Message reference is null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Condition key is null");
        }
        boolean routed = false;
        this.lock.readLock().acquire();
        try {
            Bindings bd = (Bindings)this.conditionMap.get(condition);
            if (bd != null) {
                boolean startInternalTx = false;
                if (tx == null && ref.getMessage().isReliable() && bd.getDurableCount() > 1) {
                    startInternalTx = true;
                }
                if (startInternalTx) {
                    tx = this.tr.createTransaction();
                }
                Collection bindings = bd.getAllBindings();
                Iterator iter = bindings.iterator();
                while (iter.hasNext()) {
                    Binding binding = (Binding)iter.next();
                    if (binding.getNodeID() != this.currentNodeId) {
                        throw new IllegalStateException("Local post office has foreign bindings!");
                    }
                    Queue queue = binding.getQueue();
                    Delivery del = queue.handle(null, ref, tx);
                    if (del == null || !del.isSelectorAccepted()) continue;
                    routed = true;
                }
                if (startInternalTx) {
                    tx.commit();
                }
            }
            boolean bl = routed;
            return bl;
        }
        finally {
            this.lock.readLock().release();
        }
    }

    public boolean isLocal() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Binding getBindingforChannelId(long channelId) throws Exception {
        this.lock.readLock().acquire();
        try {
            Map nameMap = (Map)this.nameMaps.get(new Integer(this.currentNodeId));
            if (nameMap == null) {
                throw new IllegalStateException("Cannot find name map for current node " + this.currentNodeId);
            }
            Binding binding = null;
            Iterator iterbindings = nameMap.values().iterator();
            while (iterbindings.hasNext()) {
                Binding itemBinding = (Binding)iterbindings.next();
                if (itemBinding.getQueue().getChannelID() != channelId) continue;
                binding = itemBinding;
                break;
            }
            Binding binding2 = binding;
            return binding2;
        }
        finally {
            this.lock.readLock().release();
        }
    }

    public String printBindingInformation() {
        Map.Entry entry;
        StringWriter buffer = new StringWriter();
        PrintWriter out = new PrintWriter(buffer);
        out.println("Ocurrencies of nameMaps:");
        out.println("<table border=1>");
        Iterator mapIterator = this.nameMaps.entrySet().iterator();
        while (mapIterator.hasNext()) {
            entry = mapIterator.next();
            out.println("<tr><td colspan=3><b>Map on node " + entry.getKey() + "</b></td></tr>");
            Map valuesOnNode = (Map)entry.getValue();
            out.println("<tr><td>Key</td><td>Value</td><td>Class of Value</td></tr>");
            Iterator valuesIterator = valuesOnNode.entrySet().iterator();
            while (valuesIterator.hasNext()) {
                PagingFilteredQueue queue;
                List undelivered;
                Map.Entry entry2 = valuesIterator.next();
                out.println("<tr>");
                out.println("<td>" + entry2.getKey() + "</td><td>" + entry2.getValue() + "</td><td>" + entry2.getValue().getClass().getName() + "</td>");
                out.println("</tr>");
                if (!(entry2.getValue() instanceof Binding) || !(((Binding)entry2.getValue()).getQueue() instanceof PagingFilteredQueue) || (undelivered = (queue = (PagingFilteredQueue)((Binding)entry2.getValue()).getQueue()).undelivered(null)).isEmpty()) continue;
                out.println("<tr><td>List of undelivered messages on Paging</td>");
                out.println("<td colspan=2><table border=1>");
                out.println("<tr><td>Reference#</td><td>Message</td></tr>");
                Iterator i = undelivered.iterator();
                while (i.hasNext()) {
                    SimpleMessageReference reference = (SimpleMessageReference)i.next();
                    out.println("<tr><td>" + reference.getInMemoryChannelCount() + "</td><td>" + reference.getMessage() + "</td></tr>");
                }
                out.println("</table></td>");
                out.println("</tr>");
            }
        }
        out.println("</table>");
        out.println("<br>Ocurrencies of conditionMap:");
        out.println("<table border=1>");
        out.println("<tr><td>EntryName</td><td>Value</td>");
        Iterator iterConditions = this.conditionMap.entrySet().iterator();
        while (iterConditions.hasNext()) {
            entry = iterConditions.next();
            out.println("<tr><td>" + entry.getKey() + "</td><td>" + entry.getValue() + "</td></tr>");
            if (!(entry.getValue() instanceof Bindings)) continue;
            out.println("<tr><td>Binding Information:</td><td>");
            out.println("<table border=1>");
            out.println("<tr><td>Binding</td><td>Queue</td></tr>");
            Bindings bindings = (Bindings)entry.getValue();
            Iterator i = bindings.getAllBindings().iterator();
            while (i.hasNext()) {
                Binding binding = (Binding)i.next();
                out.println("<tr><td>" + binding + "</td><td>" + binding.getQueue() + "</td></tr>");
            }
            out.println("</table></td></tr>");
        }
        out.println("</table>");
        return buffer.toString();
    }

    public String toString() {
        return "DefaultPostOffice[" + Integer.toHexString(this.hashCode()) + "]";
    }

    protected Binding internalGetBindingForQueueName(String queueName) {
        Map nameMap = (Map)this.nameMaps.get(new Integer(this.currentNodeId));
        Binding binding = null;
        if (nameMap != null) {
            binding = (Binding)nameMap.get(queueName);
        }
        return binding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection listBindingsForConditionInternal(Condition condition, boolean localOnly) throws Exception {
        if (condition == null) {
            throw new IllegalArgumentException("Condition is null");
        }
        this.lock.readLock().acquire();
        try {
            Bindings cb = (Bindings)this.conditionMap.get(condition);
            if (cb == null) {
                List list2 = Collections.EMPTY_LIST;
                return list2;
            }
            ArrayList<Binding> list3 = new ArrayList<Binding>();
            Collection bindings = cb.getAllBindings();
            Iterator iter = bindings.iterator();
            while (iter.hasNext()) {
                Binding binding = (Binding)iter.next();
                if (localOnly && binding.getNodeID() != this.currentNodeId) continue;
                list3.add(binding);
            }
            ArrayList<Binding> arrayList = list3;
            return arrayList;
        }
        finally {
            this.lock.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadBindings(boolean nonClusteredOnly) throws Exception {
        this.lock.writeLock().acquire();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        JDBCSupport.TransactionWrapper wrap = new JDBCSupport.TransactionWrapper();
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(this.getSQLStatement("LOAD_BINDINGS"));
            ps.setString(1, this.officeName);
            rs = ps.executeQuery();
            while (rs.next()) {
                int nodeID = rs.getInt(1);
                String queueName = rs.getString(2);
                String conditionText = rs.getString(3);
                String selector = rs.getString(4);
                if (rs.wasNull()) {
                    selector = null;
                }
                long channelID = rs.getLong(5);
                boolean isClustered = rs.getString(6).equals("Y");
                Condition condition = this.conditionFactory.createCondition(conditionText);
                if (nonClusteredOnly && isClustered || !(this instanceof ClusteredPostOffice) && nodeID != this.currentNodeId || this instanceof ClusteredPostOffice && nodeID != this.currentNodeId && !isClustered) continue;
                Binding binding = this.createBinding(nodeID, condition, queueName, channelID, selector, true, isClustered);
                log.debug(this + " loaded from database " + binding);
                binding.getQueue().deactivate();
                this.addBinding(binding);
            }
            Object var16_14 = null;
        }
        catch (Throwable throwable) {
            Object var16_15 = null;
            this.lock.writeLock().release();
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
            if (conn != null) {
                conn.close();
            }
            wrap.end();
            throw throwable;
        }
        this.lock.writeLock().release();
        if (rs != null) {
            rs.close();
        }
        if (ps != null) {
            ps.close();
        }
        if (conn != null) {
            conn.close();
        }
        wrap.end();
    }

    protected Binding createBinding(int nodeID, Condition condition, String queueName, long channelID, String filterString, boolean durable, boolean isClustered) throws Exception {
        Filter filter = this.filterFactory.createFilter(filterString);
        return this.createBinding(nodeID, condition, queueName, channelID, filter, durable, isClustered);
    }

    protected Binding createBinding(int nodeID, Condition condition, String queueName, long channelID, Filter filter, boolean durable, boolean isClustered) {
        if (nodeID != this.currentNodeId) {
            throw new IllegalStateException("This is a non clustered post office - should not have bindings from different nodes!");
        }
        PagingFilteredQueue queue = new PagingFilteredQueue(queueName, channelID, this.ms, this.pm, true, true, -1, filter);
        return new DefaultBinding(nodeID, condition, queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertBinding(Binding binding) throws Exception {
        JDBCSupport.TransactionWrapper wrap;
        Connection conn;
        block9: {
            conn = null;
            Statement ps = null;
            wrap = new JDBCSupport.TransactionWrapper();
            try {
                conn = this.ds.getConnection();
                ps = conn.prepareStatement(this.getSQLStatement("INSERT_BINDING"));
                String filterString = binding.getQueue().getFilter() == null ? null : binding.getQueue().getFilter().getFilterString();
                ps.setString(1, this.officeName);
                ps.setInt(2, this.currentNodeId);
                ps.setString(3, binding.getQueue().getName());
                ps.setString(4, binding.getCondition().toText());
                if (filterString != null) {
                    ps.setString(5, filterString);
                } else {
                    ps.setNull(5, 12);
                }
                ps.setLong(6, binding.getQueue().getChannelID());
                if (binding.getQueue().isClustered()) {
                    ps.setString(7, "Y");
                } else {
                    ps.setString(7, "N");
                }
                ps.executeUpdate();
                Object var7_6 = null;
                if (ps == null) break block9;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
                wrap.end();
                throw throwable;
            }
            ps.close();
        }
        if (conn != null) {
            conn.close();
        }
        wrap.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean deleteBinding(int parameterNodeId, String queueName) throws Exception {
        boolean bl;
        JDBCSupport.TransactionWrapper wrap;
        Connection conn;
        block6: {
            if (parameterNodeId < 0) {
                parameterNodeId = this.currentNodeId;
            }
            conn = null;
            Statement ps = null;
            wrap = new JDBCSupport.TransactionWrapper();
            try {
                conn = this.ds.getConnection();
                ps = conn.prepareStatement(this.getSQLStatement("DELETE_BINDING"));
                ps.setString(1, this.officeName);
                ps.setInt(2, parameterNodeId);
                ps.setString(3, queueName);
                int rows = ps.executeUpdate();
                bl = rows == 1;
                Object var9_8 = null;
                if (ps == null) break block6;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
                wrap.end();
                throw throwable;
            }
            ps.close();
        }
        if (conn != null) {
            conn.close();
        }
        wrap.end();
        return bl;
    }

    protected void addBinding(Binding binding) {
        this.addToNameMap(binding);
        this.addToConditionMap(binding);
    }

    protected Binding removeBinding(int nodeId, String queueName) {
        Binding binding = this.removeFromNameMap(nodeId, queueName);
        this.removeFromConditionMap(binding);
        return binding;
    }

    protected void addToNameMap(Binding binding) {
        Integer nodeID = new Integer(binding.getNodeID());
        LinkedHashMap<String, Binding> nameMap = (LinkedHashMap<String, Binding>)this.nameMaps.get(nodeID);
        if (nameMap == null) {
            nameMap = new LinkedHashMap<String, Binding>();
            this.nameMaps.put(nodeID, nameMap);
        }
        nameMap.put(binding.getQueue().getName(), binding);
        if (trace) {
            log.trace(this + " added " + binding + " to name map");
        }
    }

    protected void addToConditionMap(Binding binding) {
        Condition condition = binding.getCondition();
        Bindings bindings = (Bindings)this.conditionMap.get(condition);
        if (bindings == null) {
            bindings = new DefaultBindings();
            this.conditionMap.put(condition, bindings);
        }
        bindings.addBinding(binding);
        if (trace) {
            log.trace(this + " added " + binding + " to condition map");
        }
    }

    protected Binding removeFromNameMap(int nodeId, String queueName) {
        if (queueName == null) {
            throw new IllegalArgumentException("Queue name is null");
        }
        Map nameMap = (Map)this.nameMaps.get(new Integer(nodeId));
        if (nameMap == null) {
            throw new IllegalArgumentException("Cannot find any bindings for node Id: " + nodeId);
        }
        Binding binding = null;
        if (nameMap != null) {
            binding = (Binding)nameMap.remove(queueName);
        }
        if (binding == null) {
            throw new IllegalArgumentException("Name map does not contain binding for " + queueName);
        }
        if (nameMap.isEmpty()) {
            this.nameMaps.remove(new Integer(nodeId));
        }
        return binding;
    }

    protected void removeFromConditionMap(Binding binding) {
        Bindings bindings = (Bindings)this.conditionMap.get(binding.getCondition());
        if (bindings == null) {
            throw new IllegalStateException("Cannot find condition bindings for " + binding.getCondition());
        }
        boolean removed = bindings.removeBinding(binding);
        if (!removed) {
            throw new IllegalStateException("Cannot find binding in condition binding list");
        }
        if (bindings.isEmpty()) {
            this.conditionMap.remove(binding.getCondition());
        }
    }

    protected Map getDefaultDMLStatements() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("INSERT_BINDING", "INSERT INTO JBM_POSTOFFICE (POSTOFFICE_NAME, NODE_ID, QUEUE_NAME, CONDITION, SELECTOR, CHANNEL_ID, CLUSTERED) VALUES (?, ?, ?, ?, ?, ?, ?)");
        map.put("DELETE_BINDING", "DELETE FROM JBM_POSTOFFICE WHERE POSTOFFICE_NAME=? AND NODE_ID=? AND QUEUE_NAME=?");
        map.put("LOAD_BINDINGS", "SELECT NODE_ID, QUEUE_NAME, CONDITION, SELECTOR, CHANNEL_ID, CLUSTERED FROM JBM_POSTOFFICE WHERE POSTOFFICE_NAME  = ?");
        return map;
    }

    protected Map getDefaultDDLStatements() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("CREATE_POSTOFFICE_TABLE", "CREATE TABLE JBM_POSTOFFICE (POSTOFFICE_NAME VARCHAR(255), NODE_ID INTEGER,QUEUE_NAME VARCHAR(1023), CONDITION VARCHAR(1023), SELECTOR VARCHAR(1023), CHANNEL_ID BIGINT, CLUSTERED CHAR(1))");
        return map;
    }
}

