/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.util.prioritylinkedlist;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.jboss.messaging.util.prioritylinkedlist.PriorityLinkedList;
import org.jboss.messaging.util.prioritylinkedlist.PriorityLinkedListIterator;

public class BasicPriorityLinkedList
implements PriorityLinkedList {
    protected LinkedList[] linkedLists;
    protected int priorities;
    protected int size;

    public BasicPriorityLinkedList(int priorities) {
        this.priorities = priorities;
        this.initDeques();
    }

    public void addFirst(Object obj, int priority) {
        this.linkedLists[priority].addFirst(obj);
        ++this.size;
    }

    public void addLast(Object obj, int priority) {
        this.linkedLists[priority].addLast(obj);
        ++this.size;
    }

    public Object removeFirst() {
        Object obj = null;
        for (int i = this.priorities - 1; i >= 0; --i) {
            LinkedList ll = this.linkedLists[i];
            if (ll.isEmpty()) continue;
            obj = ll.removeFirst();
            break;
        }
        if (obj != null) {
            --this.size;
        }
        return obj;
    }

    public Object removeLast() {
        Object obj = null;
        for (int i = 0; i < this.priorities; ++i) {
            LinkedList ll = this.linkedLists[i];
            if (!ll.isEmpty()) {
                obj = ll.removeLast();
            }
            if (obj != null) break;
        }
        if (obj != null) {
            --this.size;
        }
        return obj;
    }

    public Object peekFirst() {
        Object obj = null;
        for (int i = this.priorities - 1; i >= 0; --i) {
            LinkedList ll = this.linkedLists[i];
            if (!ll.isEmpty()) {
                obj = ll.getFirst();
            }
            if (obj != null) break;
        }
        return obj;
    }

    public List getAll() {
        ArrayList all = new ArrayList();
        for (int i = this.priorities - 1; i >= 0; --i) {
            LinkedList deque = this.linkedLists[i];
            all.addAll(deque);
        }
        return all;
    }

    public void clear() {
        this.initDeques();
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public ListIterator iterator() {
        return new PriorityLinkedListIterator(this.linkedLists);
    }

    protected void initDeques() {
        this.linkedLists = new LinkedList[this.priorities];
        for (int i = 0; i < this.priorities; ++i) {
            this.linkedLists[i] = new LinkedList();
        }
        this.size = 0;
    }
}

