/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import java.io.Serializable;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.metadata.EjbLocalRefMetaData;
import org.jboss.metadata.EjbRefMetaData;
import org.jboss.metadata.EnvEntryMetaData;
import org.jboss.metadata.Listener;
import org.jboss.metadata.MessageDestinationMetaData;
import org.jboss.metadata.MessageDestinationRefMetaData;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.Ref;
import org.jboss.metadata.ResourceEnvRefMetaData;
import org.jboss.metadata.ResourceRefMetaData;
import org.jboss.metadata.RunAs;
import org.jboss.metadata.SecurityRoleMetaData;
import org.jboss.metadata.SecurityRoleRefMetaData;
import org.jboss.metadata.WebSecurityMetaData;
import org.jboss.metadata.serviceref.ServiceRefDelegate;
import org.jboss.metadata.web.ErrorPage;
import org.jboss.metadata.web.Filter;
import org.jboss.metadata.web.FilterMapping;
import org.jboss.metadata.web.LocaleEncodingMapping;
import org.jboss.metadata.web.LoginConfig;
import org.jboss.metadata.web.MimeMapping;
import org.jboss.metadata.web.ParamValue;
import org.jboss.metadata.web.PassivationConfig;
import org.jboss.metadata.web.ReplicationConfig;
import org.jboss.metadata.web.Servlet;
import org.jboss.metadata.web.ServletMapping;
import org.jboss.metadata.web.SessionConfig;
import org.jboss.metadata.web.Taglib;
import org.jboss.mx.loading.LoaderRepositoryFactory;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.security.RunAsIdentity;
import org.jboss.ws.integration.ServiceRefMetaData;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebMetaData
extends MetaData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(WebMetaData.class);
    private String description;
    private String displayName;
    private String altDDPath;
    private List<ParamValue> contextParams = new ArrayList<ParamValue>();
    private List<ParamValue> initParams = new ArrayList<ParamValue>();
    private HashMap<String, Servlet> servlets = new HashMap();
    private List<ServletMapping> servletMappings = new ArrayList<ServletMapping>();
    private HashMap<String, ResourceRefMetaData> resourceReferences = new HashMap();
    private HashMap<String, ResourceEnvRefMetaData> resourceEnvReferences = new HashMap();
    private HashMap<String, MessageDestinationRefMetaData> messageDestinationReferences = new HashMap();
    private HashMap<String, MessageDestinationMetaData> messageDestinations = new HashMap();
    protected HashMap<String, Filter> filters = new HashMap();
    protected List<FilterMapping> filterMappings = new ArrayList<FilterMapping>();
    protected HashMap listeners = new HashMap();
    protected List<SessionConfig> sessionConfigs = new ArrayList<SessionConfig>();
    protected List<WebSecurityMetaData> securityConstraints = new ArrayList<WebSecurityMetaData>();
    protected LoginConfig loginConfig;
    protected List<ErrorPage> errorPages = new ArrayList<ErrorPage>();
    protected List<String> dependencies = new ArrayList<String>();
    protected ReplicationConfig replicationConfig;
    protected PassivationConfig passivationConfig;
    private boolean gotJspConfig = false;
    private boolean gotLoginConfig = false;
    private boolean gotSessionConfig = false;
    private ArrayList<EnvEntryMetaData> environmentEntries = new ArrayList();
    private HashMap<String, SecurityRoleMetaData> securityRoles = new HashMap();
    private HashMap ejbReferences = new HashMap();
    private HashMap<String, EjbLocalRefMetaData> ejbLocalReferences = new HashMap();
    private Map<String, ServiceRefMetaData> serviceRefs = new LinkedHashMap<String, ServiceRefMetaData>();
    private HashMap securityRoleReferences = new HashMap();
    private HashMap<String, String> runAsNames = new HashMap();
    private HashMap<String, RunAsIdentity> runAsIdentity = new HashMap();
    private boolean distributable = false;
    private boolean java2ClassLoadingCompliance = false;
    private LoaderRepositoryFactory.LoaderRepositoryConfig loaderConfig;
    private String contextRoot;
    private String jaccContextID;
    private ArrayList virtualHosts = new ArrayList();
    private String securityDomain;
    private boolean flushOnSessionInvalidation;
    private HashMap wsdlPublishLocationMap = new HashMap();
    private boolean webServiceDeployment;
    private String configName;
    private String configFile;
    private transient ClassLoader encLoader;
    private transient ClassLoader cxtLoader;
    private ArrayList depends = new ArrayList();
    private boolean metadataComplete = false;
    private List<MimeMapping> mimeMappings = new ArrayList<MimeMapping>();
    private List<LocaleEncodingMapping> localeEncodingMappings = new ArrayList<LocaleEncodingMapping>();
    private List<String> welcomeFiles = new ArrayList<String>();
    private List<String> jspMappings = new ArrayList<String>();
    private List<Taglib> taglibs = new ArrayList<Taglib>();
    private HashMap arbitraryMetadata = new HashMap();
    public static final int SESSION_INVALIDATE_ACCESS = 0;
    public static final int SESSION_INVALIDATE_SET_AND_GET = 1;
    public static final int SESSION_INVALIDATE_SET_AND_NON_PRIMITIVE_GET = 2;
    public static final int SESSION_INVALIDATE_SET = 3;
    private int invalidateSessionPolicy = 2;
    public static final int REPLICATION_TYPE_SYNC = 0;
    public static final int REPLICATION_TYPE_ASYNC = 1;
    private int replicationType = 0;
    public static final int REPLICATION_GRANULARITY_SESSION = 0;
    public static final int REPLICATION_GRANULARITY_ATTRIBUTE = 1;
    public static final int REPLICATION_GRANULARITY_FIELD = 2;
    private int replicationGranularity = 0;
    private boolean replicationFieldBatchMode = true;
    private int maxActiveSessions = -1;
    private int sessionCookies = 0;
    public static final int SESSION_COOKIES_DEFAULT = 0;
    public static final int SESSION_COOKIES_ENABLED = 1;
    public static final int SESSION_COOKIES_DISABLED = 2;
    private URLClassLoader resourceCl;

    public void gotJspConfig() {
        if (this.gotJspConfig) {
            throw new IllegalStateException("<jsp-config> element is limited to 1 occurance");
        }
        this.gotJspConfig = true;
    }

    public void gotLoginConfig() {
        if (this.gotLoginConfig) {
            throw new IllegalStateException("<login-config> element is limited to 1 occurance");
        }
        this.gotLoginConfig = true;
    }

    public void gotSessionConfig() {
        if (this.gotSessionConfig) {
            throw new IllegalStateException("<session-config> element is limited to 1 occurance");
        }
        this.gotSessionConfig = true;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getAltDDPath() {
        return this.altDDPath;
    }

    public void setAltDDPath(String altDDPath) {
        this.altDDPath = altDDPath;
    }

    public List<ParamValue> getContextParams() {
        return this.contextParams;
    }

    public void addContextParam(ParamValue pv) {
        this.contextParams.add(pv);
    }

    public List<ParamValue> getInitParams() {
        return this.initParams;
    }

    public void addInitParam(ParamValue pv) {
        this.initParams.add(pv);
    }

    public HashMap getArbitraryMetadata() {
        return this.arbitraryMetadata;
    }

    public void setResourceClassLoader(URLClassLoader resourceCl) {
        this.resourceCl = resourceCl;
    }

    public Collection<Filter> getFilters() {
        return this.filters.values();
    }

    public void addFilter(Filter filter) {
        this.filters.put(filter.getName(), filter);
    }

    public Collection<FilterMapping> getFilterMappings() {
        return this.filterMappings;
    }

    public void addFilterMapping(FilterMapping mapping) {
        this.filterMappings.add(mapping);
    }

    public Collection getListeners() {
        return this.listeners.values();
    }

    public void addListener(Listener listener) {
        this.listeners.put(listener.getListenerClass(), listener);
    }

    public Collection<Servlet> getServlets() {
        return this.servlets.values();
    }

    public void addServlet(Servlet servlet) {
        String servletName = servlet.getName();
        this.servlets.put(servletName, servlet);
        RunAs runAs = servlet.getRunAs();
        if (runAs != null) {
            this.runAsNames.put(servletName, runAs.getRoleName());
        }
    }

    public void updateServlet(Servlet updatedServlet) {
        String servletName = updatedServlet.getName();
        Servlet servlet = this.servlets.get(servletName);
        if (servlet != null) {
            servlet.setRunAsPrincipal(updatedServlet.getRunAsPrincipal());
        } else {
            this.servlets.put(servletName, updatedServlet);
            servlet = updatedServlet;
        }
        String principalName = servlet.getRunAsPrincipal();
        String webXmlRunAs = this.runAsNames.get(servletName);
        if (principalName != null) {
            if (webXmlRunAs == null) {
                throw new IllegalStateException("run-as-principal: " + principalName + " found in jboss-web.xml but there was no run-as in web.xml");
            }
            Set extraRoles = this.getSecurityRoleNamesByPrincipal(principalName);
            RunAsIdentity runAsId = new RunAsIdentity(webXmlRunAs, principalName, extraRoles);
            this.runAsIdentity.put(servletName, runAsId);
        } else if (webXmlRunAs != null) {
            RunAsIdentity runAsId = new RunAsIdentity(webXmlRunAs, null);
            this.runAsIdentity.put(servletName, runAsId);
        }
    }

    public Collection getServletMappings() {
        return this.servletMappings;
    }

    public void addServletMapping(ServletMapping mapping) {
        this.servletMappings.add(mapping);
    }

    public Collection getSessionConfigs() {
        return this.sessionConfigs;
    }

    public void addSessionConfig(SessionConfig config) {
        this.sessionConfigs.add(config);
    }

    public void addSecurityRole(SecurityRoleMetaData securityRole) {
        this.securityRoles.put(securityRole.getRoleName(), securityRole);
    }

    public void updateSecurityRole(SecurityRoleMetaData updatedRole) {
        SecurityRoleMetaData role = this.securityRoles.get(updatedRole.getRoleName());
        if (role != null) {
            role.setRoleName(updatedRole.getRoleName());
        } else {
            this.securityRoles.put(updatedRole.getRoleName(), updatedRole);
        }
    }

    public Collection getSecurityConstraints() {
        return this.securityConstraints;
    }

    public void addSecurityConstraint(WebSecurityMetaData constraint) {
        this.securityConstraints.add(constraint);
    }

    public Collection<MimeMapping> getMimeMappings() {
        return this.mimeMappings;
    }

    public void addMimeMapping(MimeMapping mimeMapping) {
        this.mimeMappings.add(mimeMapping);
    }

    public Collection<LocaleEncodingMapping> getLocaleEncodingMappings() {
        return this.localeEncodingMappings;
    }

    public void addLocaleEncodingMapping(LocaleEncodingMapping localeEncodingMapping) {
        this.localeEncodingMappings.add(localeEncodingMapping);
    }

    public Collection<String> getWelcomeFiles() {
        return this.welcomeFiles;
    }

    public void addWelcomeFile(String welcomeFile) {
        this.welcomeFiles.add(welcomeFile);
    }

    public Collection<String> getJspMappings() {
        return this.jspMappings;
    }

    public void addJspMapping(String jspMapping) {
        this.jspMappings.add(jspMapping);
    }

    public Collection<Taglib> getTaglibs() {
        return this.taglibs;
    }

    public void addTaglib(Taglib taglib) {
        this.taglibs.add(taglib);
    }

    public LoginConfig getLoginConfig() {
        return this.loginConfig;
    }

    public void setLoginConfig(LoginConfig loginConfig) {
        this.loginConfig = loginConfig;
    }

    public Collection getErrorPages() {
        return this.errorPages;
    }

    public void addErrorPage(ErrorPage errorPage) {
        this.errorPages.add(errorPage);
    }

    public Collection getMessageDestinations() {
        return this.messageDestinations.values();
    }

    public void addEjbLocalRef(EjbLocalRefMetaData ref) {
        this.ejbLocalReferences.put(ref.getName(), ref);
    }

    public void addEjbRef(EjbRefMetaData ref) {
        this.ejbReferences.put(ref.getName(), ref);
    }

    public void addEnvEntry(EnvEntryMetaData ref) {
        this.environmentEntries.add(ref);
    }

    public void addMessageDestinationRef(MessageDestinationRefMetaData ref) {
        this.messageDestinationReferences.put(ref.getRefName(), ref);
    }

    public void addMessageDestination(MessageDestinationMetaData destination) {
        log.debug("addMessageDestination, " + destination);
        this.messageDestinations.put(destination.getName(), destination);
    }

    public void updateMessageDestination(MessageDestinationMetaData updatedDestination) {
        MessageDestinationMetaData destination = this.messageDestinations.get(updatedDestination.getName());
        if (destination != null) {
            destination.setJNDIName(updatedDestination.getMappedName());
        } else {
            this.messageDestinations.put(updatedDestination.getName(), updatedDestination);
        }
    }

    public void addResourceEnvRef(ResourceEnvRefMetaData ref) {
        this.resourceEnvReferences.put(ref.getRefName(), ref);
    }

    public void updateResourceEnvRef(ResourceEnvRefMetaData updatedRef) {
        ResourceEnvRefMetaData ref = this.resourceEnvReferences.get(updatedRef.getRefName());
        if (ref != null) {
            ref.setJndiName(updatedRef.getJndiName());
        } else {
            this.addResourceEnvRef(updatedRef);
        }
    }

    public void addResourceRef(ResourceRefMetaData ref) {
        this.resourceReferences.put(ref.getRefName(), ref);
    }

    public void updateResourceRef(ResourceRefMetaData updatedRef) {
        ResourceRefMetaData ref = this.resourceReferences.get(updatedRef.getRefName());
        if (ref != null) {
            ref.setJndiName(updatedRef.getJndiName());
            ref.setResURL(updatedRef.getResURL());
            ref.setResourceName(updatedRef.getResourceName());
        } else {
            this.addResourceRef(updatedRef);
        }
    }

    public void addDependency(String depends) {
        this.dependencies.add(depends);
    }

    public Collection<String> getDependencies() {
        return this.dependencies;
    }

    public ReplicationConfig getReplicationConfig() {
        return this.replicationConfig;
    }

    public void setReplicationConfig(ReplicationConfig replicationConfig) {
        this.replicationConfig = replicationConfig;
    }

    public PassivationConfig getPassivationConfig() {
        return this.passivationConfig;
    }

    public void setPassivationConfig(PassivationConfig passivationConfig) {
        this.passivationConfig = passivationConfig;
    }

    public Iterator<EnvEntryMetaData> getEnvironmentEntries() {
        return this.environmentEntries.iterator();
    }

    public void setEnvironmentEntries(Collection environmentEntries) {
        this.environmentEntries.clear();
        this.environmentEntries.addAll(environmentEntries);
    }

    public Iterator getEjbReferences() {
        return this.ejbReferences.values().iterator();
    }

    public void setEjbReferences(Map ejbReferences) {
        this.ejbReferences.clear();
        this.ejbReferences.putAll(ejbReferences);
    }

    public Iterator<EjbLocalRefMetaData> getEjbLocalReferences() {
        return this.ejbLocalReferences.values().iterator();
    }

    public Map<String, EjbLocalRefMetaData> getEjbLocalReferenceMap() {
        return this.ejbLocalReferences;
    }

    public void setEjbLocalReferences(Map ejbReferences) {
        this.ejbLocalReferences.clear();
        this.ejbLocalReferences.putAll(ejbReferences);
    }

    public Iterator getResourceReferences() {
        return this.resourceReferences.values().iterator();
    }

    public void setResourceReferences(Map resourceReferences) {
        this.resourceReferences.clear();
        this.resourceReferences.putAll(resourceReferences);
    }

    public Iterator getResourceEnvReferences() {
        return this.resourceEnvReferences.values().iterator();
    }

    public void setResourceEnvReferences(Map resourceReferences) {
        this.resourceEnvReferences.clear();
        this.resourceEnvReferences.putAll(resourceReferences);
    }

    public Iterator getMessageDestinationReferences() {
        return this.messageDestinationReferences.values().iterator();
    }

    public void setMessageDestinationReferences(Map messageDestinationReferences) {
        this.messageDestinationReferences.clear();
        this.messageDestinationReferences.putAll(messageDestinationReferences);
    }

    public MessageDestinationMetaData getMessageDestination(String name) {
        return this.messageDestinations.get(name);
    }

    public void setMessageDestination(Map messageDestinations) {
        this.messageDestinations.clear();
        this.messageDestinations.putAll(messageDestinations);
    }

    public Map<String, ServiceRefMetaData> getServiceRefs() {
        return this.serviceRefs;
    }

    public ServiceRefMetaData getServiceRef(String name) {
        ServiceRefMetaData ref = this.serviceRefs.get(name);
        return ref;
    }

    public void addServiceRef(ServiceRefMetaData serviceRef) {
        this.serviceRefs.put(serviceRef.getServiceRefName(), serviceRef);
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public String getConfigName() {
        return this.configName;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public HashMap getWsdlPublishLocations() {
        return this.wsdlPublishLocationMap;
    }

    public String getWsdlPublishLocationByName(String name) {
        return (String)this.wsdlPublishLocationMap.get(name);
    }

    public void setWsdlPublishLocationMap(Map wsdlPublishLocationMap) {
        this.wsdlPublishLocationMap.clear();
        this.wsdlPublishLocationMap.putAll(wsdlPublishLocationMap);
    }

    public boolean isWebServiceDeployment() {
        return this.webServiceDeployment;
    }

    public void setWebServiceDeployment(boolean webServiceDeployment) {
        this.webServiceDeployment = webServiceDeployment;
    }

    public String getJaccContextID() {
        return this.jaccContextID;
    }

    public void setJaccContextID(String jaccContextID) {
        this.jaccContextID = jaccContextID;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    public boolean isFlushOnSessionInvalidation() {
        return this.flushOnSessionInvalidation;
    }

    public void setFlushOnSessionInvalidation(boolean flag) {
        this.flushOnSessionInvalidation = flag;
    }

    public Iterator<WebSecurityMetaData> getSecurityContraints() {
        return this.securityConstraints.iterator();
    }

    public void setSecurityConstraints(Collection<WebSecurityMetaData> securityContraints) {
        this.securityConstraints.clear();
        this.securityConstraints.addAll(securityContraints);
    }

    public Map getSecurityRoleRefs() {
        return this.securityRoleReferences;
    }

    public List getSecurityRoleRefs(String servletName) {
        List roles = (List)this.securityRoleReferences.get(servletName);
        return roles;
    }

    public void addSecurityRoleReference(String servletName, List<SecurityRoleRefMetaData> srr) {
        this.securityRoleReferences.put(servletName, srr);
    }

    public void setSecurityRoleReferences(Map securityRoleReferences) {
        this.securityRoleReferences.clear();
        this.securityRoleReferences.putAll(securityRoleReferences);
    }

    public Set getSecurityRoleNames() {
        return new HashSet<String>(this.securityRoles.keySet());
    }

    public Map getSecurityRoles() {
        return new HashMap<String, SecurityRoleMetaData>(this.securityRoles);
    }

    public void setSecurityRoles(Map securityRoles) {
        this.securityRoles.clear();
        this.securityRoles.putAll(securityRoles);
    }

    public Set getSecurityRoleNamesByPrincipal(String userName) {
        HashSet<String> roleNames = new HashSet<String>();
        for (SecurityRoleMetaData srMetaData : this.securityRoles.values()) {
            if (!srMetaData.getPrincipals().contains(userName)) continue;
            roleNames.add(srMetaData.getRoleName());
        }
        return roleNames;
    }

    public Map getPrincipalVersusRolesMap() {
        HashMap principalRolesMap = null;
        Iterator<String> iter = this.securityRoles.keySet().iterator();
        while (iter.hasNext()) {
            if (principalRolesMap == null) {
                principalRolesMap = new HashMap();
            }
            String rolename = iter.next();
            SecurityRoleMetaData srm = this.securityRoles.get(rolename);
            for (String pr : srm.getPrincipals()) {
                HashSet<String> roleset = (HashSet<String>)principalRolesMap.get(pr);
                if (roleset == null) {
                    roleset = new HashSet<String>();
                }
                if (!roleset.contains(rolename)) {
                    roleset.add(rolename);
                }
                principalRolesMap.put(pr, roleset);
            }
        }
        return principalRolesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunAsIdentity getRunAsIdentity(String servletName) {
        RunAsIdentity runAs = this.runAsIdentity.get(servletName);
        if (runAs == null) {
            HashMap<String, RunAsIdentity> hashMap = this.runAsIdentity;
            synchronized (hashMap) {
                String roleName = this.runAsNames.get(servletName);
                if (roleName != null) {
                    runAs = new RunAsIdentity(roleName, null);
                    this.runAsIdentity.put(servletName, runAs);
                }
            }
        }
        return runAs;
    }

    public Map getRunAsIdentity() {
        return this.runAsIdentity;
    }

    public void setRunAsIdentity(Map runAsIdentity) {
        this.runAsIdentity.clear();
        this.runAsIdentity.putAll(runAsIdentity);
    }

    public Set getServletNames() {
        return new HashSet<String>(this.servlets.keySet());
    }

    public void mergeSecurityRoles(Map<String, SecurityRoleMetaData> applRoles) {
        for (Map.Entry<String, SecurityRoleMetaData> entry : applRoles.entrySet()) {
            String roleName = entry.getKey();
            SecurityRoleMetaData appRole = entry.getValue();
            SecurityRoleMetaData srMetaData = this.securityRoles.get(roleName);
            if (srMetaData != null) {
                Set<String> principalNames = appRole.getPrincipals();
                srMetaData.addPrincipalNames(principalNames);
                continue;
            }
            this.securityRoles.put(roleName, entry.getValue());
        }
    }

    public Iterator getVirtualHosts() {
        return this.virtualHosts.iterator();
    }

    public void setVirtualHosts(Collection virtualHosts) {
        this.virtualHosts.clear();
        this.virtualHosts.addAll(virtualHosts);
    }

    public boolean getDistributable() {
        return this.distributable;
    }

    public void setDistributable(boolean distributable) {
        this.distributable = distributable;
    }

    public Collection getDepends() {
        return this.depends;
    }

    public void setDepends(Collection depends) {
        this.depends.clear();
        this.depends.addAll(depends);
    }

    public boolean getJava2ClassLoadingCompliance() {
        return this.java2ClassLoadingCompliance;
    }

    public void setJava2ClassLoadingCompliance(boolean flag) {
        this.java2ClassLoadingCompliance = flag;
    }

    public LoaderRepositoryFactory.LoaderRepositoryConfig getLoaderConfig() {
        return this.loaderConfig;
    }

    public void setLoaderConfig(LoaderRepositoryFactory.LoaderRepositoryConfig loaderConfig) {
        this.loaderConfig = loaderConfig;
    }

    public ClassLoader getENCLoader() {
        return this.encLoader;
    }

    public void setENCLoader(ClassLoader encLoader) {
        this.encLoader = encLoader;
    }

    public ClassLoader getContextLoader() {
        return this.cxtLoader;
    }

    public void setContextLoader(ClassLoader cxtLoader) {
        this.cxtLoader = cxtLoader;
    }

    public int getSessionCookies() {
        return this.sessionCookies;
    }

    public void setSessionCookies(int sessionCookies) {
        this.sessionCookies = sessionCookies;
    }

    public int getInvalidateSessionPolicy() {
        return this.invalidateSessionPolicy;
    }

    public void setInvalidateSessionPolicy(int invalidateSessionPolicy) {
        this.invalidateSessionPolicy = invalidateSessionPolicy;
    }

    public int getReplicationType() {
        return this.replicationType;
    }

    public int getReplicationGranularity() {
        return this.replicationGranularity;
    }

    public void setReplicationGranularity(int replicationGranularity) {
        this.replicationGranularity = replicationGranularity;
    }

    public boolean getReplicationFieldBatchMode() {
        return this.replicationFieldBatchMode;
    }

    public int getMaxActiveSessionsAllowed() {
        return this.maxActiveSessions;
    }

    public void setMaxActiveSessionsAllowed(int maxActive) {
        this.maxActiveSessions = maxActive;
    }

    public boolean isMetadataComplete() {
        return this.metadataComplete;
    }

    public void setMetadataComplete(boolean metadataComplete) {
        this.metadataComplete = metadataComplete;
    }

    protected void importJBossWebXml(Element jbossWeb) throws DeploymentException {
        Element classLoading;
        Element sessionReplicationRootElement;
        Element maxActiveSessionsElement;
        Ref refMetaData;
        String resRefName;
        Element resourceRef;
        Element securityDomainElement;
        Element contextRootElement = WebMetaData.getOptionalChild(jbossWeb, "context-root");
        if (contextRootElement != null) {
            this.contextRoot = WebMetaData.getElementContent(contextRootElement);
        }
        if ((securityDomainElement = WebMetaData.getOptionalChild(jbossWeb, "security-domain")) != null) {
            this.securityDomain = WebMetaData.getElementContent(securityDomainElement);
            Boolean flag = Boolean.valueOf(securityDomainElement.getAttribute("flushOnSessionInvalidation"));
            this.flushOnSessionInvalidation = flag;
        }
        Iterator virtualHostElements = WebMetaData.getChildrenByTagName(jbossWeb, "virtual-host");
        while (virtualHostElements.hasNext()) {
            Element virtualHostElement = (Element)virtualHostElements.next();
            String virtualHostName = WebMetaData.getElementContent(virtualHostElement);
            this.virtualHosts.add(virtualHostName);
        }
        Iterator iterator = WebMetaData.getChildrenByTagName(jbossWeb, "resource-ref");
        while (iterator.hasNext()) {
            resourceRef = (Element)iterator.next();
            resRefName = WebMetaData.getElementContent(WebMetaData.getUniqueChild(resourceRef, "res-ref-name"));
            refMetaData = this.resourceReferences.get(resRefName);
            if (refMetaData == null) {
                throw new DeploymentException("resource-ref " + resRefName + " found in jboss-web.xml but not in web.xml");
            }
            ((ResourceRefMetaData)refMetaData).importJbossXml(resourceRef);
        }
        iterator = WebMetaData.getChildrenByTagName(jbossWeb, "resource-env-ref");
        while (iterator.hasNext()) {
            resourceRef = (Element)iterator.next();
            resRefName = WebMetaData.getElementContent(WebMetaData.getUniqueChild(resourceRef, "resource-env-ref-name"));
            refMetaData = this.resourceEnvReferences.get(resRefName);
            if (refMetaData == null) {
                throw new DeploymentException("resource-env-ref " + resRefName + " found in jboss-web.xml but not in web.xml");
            }
            ((ResourceEnvRefMetaData)refMetaData).importJbossXml(resourceRef);
        }
        iterator = WebMetaData.getChildrenByTagName(jbossWeb, "message-destination-ref");
        while (iterator.hasNext()) {
            Element messageDestinationRef = (Element)iterator.next();
            String messageDestinationRefName = WebMetaData.getElementContent(WebMetaData.getUniqueChild(messageDestinationRef, "message-destination-ref-name"));
            MessageDestinationRefMetaData messageDestinationRefMetaData = this.messageDestinationReferences.get(messageDestinationRefName);
            if (messageDestinationRefMetaData == null) {
                throw new DeploymentException("message-destination-ref " + messageDestinationRefName + " found in jboss-web.xml but not in web.xml");
            }
            messageDestinationRefMetaData.importJbossXml(messageDestinationRef);
        }
        iterator = WebMetaData.getChildrenByTagName(jbossWeb, "message-destination");
        while (iterator.hasNext()) {
            Element messageDestination = (Element)iterator.next();
            try {
                String messageDestinationName = WebMetaData.getUniqueChildContent(messageDestination, "message-destination-name");
                MessageDestinationMetaData messageDestinationMetaData = this.messageDestinations.get(messageDestinationName);
                if (messageDestinationMetaData == null) {
                    throw new DeploymentException("message-destination " + messageDestinationName + " found in jboss-web.xml but not in web.xml");
                }
                messageDestinationMetaData.importJbossXml(messageDestination);
            }
            catch (Throwable t) {
                throw new DeploymentException("Error in web.xml for message destination: " + t.getMessage());
            }
        }
        iterator = WebMetaData.getChildrenByTagName(jbossWeb, "security-role");
        while (iterator.hasNext()) {
            Element securityRole = (Element)iterator.next();
            String roleName = WebMetaData.getElementContent(WebMetaData.getUniqueChild(securityRole, "role-name"));
            SecurityRoleMetaData securityRoleMetaData = this.securityRoles.get(roleName);
            if (securityRoleMetaData == null) {
                throw new DeploymentException("Security role '" + roleName + "' defined in jboss-web.xml" + " is not defined in web.xml");
            }
            Iterator itPrincipalNames = WebMetaData.getChildrenByTagName(securityRole, "principal-name");
            while (itPrincipalNames.hasNext()) {
                String principalName = WebMetaData.getElementContent((Element)itPrincipalNames.next());
                securityRoleMetaData.addPrincipalName(principalName);
            }
        }
        iterator = WebMetaData.getChildrenByTagName(jbossWeb, "ejb-ref");
        while (iterator.hasNext()) {
            Element ejbRef = (Element)iterator.next();
            String ejbRefName = WebMetaData.getElementContent(WebMetaData.getUniqueChild(ejbRef, "ejb-ref-name"));
            EjbRefMetaData ejbRefMetaData = (EjbRefMetaData)this.ejbReferences.get(ejbRefName);
            if (ejbRefMetaData == null) {
                throw new DeploymentException("ejb-ref " + ejbRefName + " found in jboss-web.xml but not in web.xml");
            }
            ejbRefMetaData.importJbossXml(ejbRef);
        }
        iterator = WebMetaData.getChildrenByTagName(jbossWeb, "ejb-local-ref");
        while (iterator.hasNext()) {
            Element ejbLocalRef = (Element)iterator.next();
            String ejbLocalRefName = WebMetaData.getElementContent(WebMetaData.getUniqueChild(ejbLocalRef, "ejb-ref-name"));
            EjbLocalRefMetaData ejbLocalRefMetaData = this.ejbLocalReferences.get(ejbLocalRefName);
            if (ejbLocalRefMetaData == null) {
                throw new DeploymentException("ejb-local-ref " + ejbLocalRefName + " found in jboss-web.xml but not in web.xml");
            }
            ejbLocalRefMetaData.importJbossXml(ejbLocalRef);
        }
        iterator = MetaData.getChildrenByTagName(jbossWeb, "service-ref");
        while (iterator.hasNext()) {
            Element refElement = (Element)iterator.next();
            String serviceRefName = MetaData.getUniqueChildContent(refElement, "service-ref-name");
            ServiceRefMetaData sref = this.serviceRefs.get(serviceRefName);
            if (sref == null) {
                log.warn("service-ref " + serviceRefName + " found in jboss-web.xml but not in web.xml");
                sref = new ServiceRefDelegate().newServiceRefMetaData();
                sref.setServiceRefName(serviceRefName);
                this.serviceRefs.put(serviceRefName, sref);
            }
            sref.importJBossXml(refElement);
        }
        iterator = WebMetaData.getChildrenByTagName(jbossWeb, "webservice-description");
        while (iterator.hasNext()) {
            Element wsd = (Element)iterator.next();
            String wsdName = WebMetaData.getElementContent(WebMetaData.getUniqueChild(wsd, "webservice-description-name"));
            this.configName = MetaData.getOptionalChildContent(wsd, "config-name");
            this.configFile = MetaData.getOptionalChildContent(wsd, "config-file");
            String wsdlPublishLocation = WebMetaData.getOptionalChildContent(wsd, "wsdl-publish-location");
            this.wsdlPublishLocationMap.put(wsdName, wsdlPublishLocation);
        }
        Iterator dependsElements = WebMetaData.getChildrenByTagName(jbossWeb, "depends");
        while (dependsElements.hasNext()) {
            Element dependsElement = (Element)dependsElements.next();
            String dependsName = WebMetaData.getElementContent(dependsElement);
            this.depends.add(ObjectNameFactory.create(dependsName));
        }
        iterator = WebMetaData.getChildrenByTagName(jbossWeb, "use-session-cookies");
        if (iterator.hasNext()) {
            Element useCookiesElement = (Element)iterator.next();
            String useCookiesElementContent = WebMetaData.getElementContent(useCookiesElement);
            Boolean useCookies = Boolean.valueOf(useCookiesElementContent);
            this.sessionCookies = useCookies != false ? 1 : 2;
        }
        if ((maxActiveSessionsElement = WebMetaData.getOptionalChild(jbossWeb, "max-active-sessions")) != null) {
            this.maxActiveSessions = Integer.valueOf(WebMetaData.getElementContent(maxActiveSessionsElement));
        }
        log.info("WebMetaData:importJBossWebXml: maxActiveSessions = " + this.maxActiveSessions);
        Element sessionPassivationRootElement = WebMetaData.getOptionalChild(jbossWeb, "passivation-config");
        if (sessionPassivationRootElement != null) {
            Element usePassivationElement = MetaData.getOptionalChild(sessionPassivationRootElement, "use-session-passivation");
            if (usePassivationElement != null) {
                this.passivationConfig.setUseSessionPassivation(WebMetaData.getElementContent(usePassivationElement));
            } else {
                this.passivationConfig.setUseSessionPassivation(String.valueOf(false));
            }
            log.info("WebMetaData:importJBossWebXml: PassivationConfig.UseSessionPassivation = " + this.passivationConfig.getUseSessionPassivation());
            if (Boolean.valueOf(this.passivationConfig.getUseSessionPassivation()).booleanValue()) {
                Element minIdleTimeElement = MetaData.getOptionalChild(sessionPassivationRootElement, "passivation-min-idle-time");
                if (minIdleTimeElement != null) {
                    this.passivationConfig.setPassivationMinIdleTime(WebMetaData.getElementContent(minIdleTimeElement));
                    log.info("WebMetaData:importJBossWebXml: passivationConfig.passivationMinIdleTime = " + this.passivationConfig.getPassivationMinIdleTime());
                } else {
                    this.passivationConfig.setPassivationMinIdleTime(String.valueOf(0));
                }
                Element maxIdleTimeElement = MetaData.getOptionalChild(sessionPassivationRootElement, "passivation-max-idle-time");
                if (maxIdleTimeElement != null) {
                    this.passivationConfig.setPassivationMaxIdleTime(WebMetaData.getElementContent(maxIdleTimeElement));
                    log.info("WebMetaData:importJBossWebXml: passivationConfig.passivationMaxIdleTime = " + this.passivationConfig.getPassivationMaxIdleTime());
                } else {
                    this.passivationConfig.setPassivationMaxIdleTime(String.valueOf(0));
                }
            } else {
                this.passivationConfig.setPassivationMinIdleTime(String.valueOf(0));
                this.passivationConfig.setPassivationMaxIdleTime(String.valueOf(0));
            }
        }
        if ((sessionReplicationRootElement = WebMetaData.getOptionalChild(jbossWeb, "replication-config")) != null) {
            Element batchModeElement;
            Element replicationGranularityElement;
            Element replicationTypeElement;
            Element replicationTriggerElement = WebMetaData.getOptionalChild(sessionReplicationRootElement, "replication-trigger");
            if (replicationTriggerElement != null) {
                String repMethod = WebMetaData.getElementContent(replicationTriggerElement);
                if ("SET_AND_GET".equalsIgnoreCase(repMethod)) {
                    this.invalidateSessionPolicy = 1;
                } else if ("SET_AND_NON_PRIMITIVE_GET".equalsIgnoreCase(repMethod)) {
                    this.invalidateSessionPolicy = 2;
                } else if ("SET".equalsIgnoreCase(repMethod)) {
                    this.invalidateSessionPolicy = 3;
                } else {
                    throw new DeploymentException("replication-trigger value set to a non-valid value: '" + repMethod + "' (should be ['SET_AND_GET', 'SET_AND_NON_PRIMITIVE_GET', 'SET']) in jboss-web.xml");
                }
            }
            if ((replicationTypeElement = WebMetaData.getOptionalChild(sessionReplicationRootElement, "replication-type")) != null) {
                String repType = WebMetaData.getElementContent(replicationTypeElement);
                if ("SYNC".equalsIgnoreCase(repType)) {
                    this.replicationType = 0;
                } else if ("ASYNC".equalsIgnoreCase(repType)) {
                    this.replicationType = 1;
                } else {
                    throw new DeploymentException("replication-type value set to a non-valid value: '" + repType + "' (should be ['SYNC', 'ASYNC']) in jboss-web.xml");
                }
            }
            if ((replicationGranularityElement = MetaData.getOptionalChild(sessionReplicationRootElement, "replication-granularity")) != null) {
                String repType = MetaData.getElementContent(replicationGranularityElement);
                if ("SESSION".equalsIgnoreCase(repType)) {
                    this.replicationGranularity = 0;
                } else if ("ATTRIBUTE".equalsIgnoreCase(repType)) {
                    this.replicationGranularity = 1;
                } else if ("FIELD".equalsIgnoreCase(repType)) {
                    this.replicationGranularity = 2;
                } else {
                    throw new DeploymentException("replication-granularity value set to a non-valid value: '" + repType + "' (should be ['SESSION', 'ATTRIBUTE', or 'FIELD'']) in jboss-web.xml");
                }
            }
            if ((batchModeElement = MetaData.getOptionalChild(sessionReplicationRootElement, "replication-field-batch-mode")) != null) {
                Boolean flag = Boolean.valueOf(MetaData.getElementContent(batchModeElement));
                this.replicationFieldBatchMode = flag;
            }
        }
        if ((classLoading = MetaData.getOptionalChild(jbossWeb, "class-loading")) != null) {
            String flagString = classLoading.getAttribute("java2ClassLoadingCompliance");
            if (flagString.length() == 0) {
                flagString = "true";
            }
            boolean flag = Boolean.valueOf(flagString);
            this.setJava2ClassLoadingCompliance(flag);
            Element loader = MetaData.getOptionalChild(classLoading, "loader-repository");
            if (loader != null) {
                try {
                    this.loaderConfig = LoaderRepositoryFactory.parseRepositoryConfig(loader);
                }
                catch (MalformedObjectNameException e) {
                    throw new DeploymentException(e);
                }
            }
        }
        iterator = WebMetaData.getChildrenByTagName(jbossWeb, "servlet");
        while (iterator.hasNext()) {
            Element servlet = (Element)iterator.next();
            String servletName = WebMetaData.getElementContent(WebMetaData.getUniqueChild(servlet, "servlet-name"));
            String principalName = WebMetaData.getOptionalChildContent(servlet, "run-as-principal");
            String webXmlRunAs = this.runAsNames.get(servletName);
            if (principalName != null) {
                if (webXmlRunAs == null) {
                    throw new DeploymentException("run-as-principal: " + principalName + " found in jboss-web.xml but there was no run-as in web.xml");
                }
                Set extraRoles = this.getSecurityRoleNamesByPrincipal(principalName);
                RunAsIdentity runAs = new RunAsIdentity(webXmlRunAs, principalName, extraRoles);
                this.runAsIdentity.put(servletName, runAs);
                continue;
            }
            if (webXmlRunAs == null) continue;
            RunAsIdentity runAs = new RunAsIdentity(webXmlRunAs, null);
            this.runAsIdentity.put(servletName, runAs);
        }
    }
}

