/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.spi.retrieval;

import java.lang.annotation.Annotation;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.retrieval.AnnotationItem;
import org.jboss.metadata.spi.retrieval.AnnotationsItem;
import org.jboss.metadata.spi.retrieval.MetaDataItem;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.retrieval.MetaDatasItem;
import org.jboss.metadata.spi.retrieval.ValidTime;
import org.jboss.metadata.spi.signature.Signature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataRetrievalToMetaDataBridge
implements MetaData {
    private MetaDataRetrieval retrieval;

    public MetaDataRetrievalToMetaDataBridge(MetaDataRetrieval retrieval) {
        if (retrieval == null) {
            throw new IllegalArgumentException("Null retrieval");
        }
        this.retrieval = retrieval;
    }

    @Override
    public long getValidTime() {
        ValidTime validTime = this.retrieval.getValidTime();
        return validTime.getValidTime();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        if (annotationType == null) {
            throw new IllegalArgumentException("Null annotationType");
        }
        AnnotationItem<T> item = this.retrieval.retrieveAnnotation(annotationType);
        if (item == null) {
            return null;
        }
        return (T)((Annotation)item.getValue());
    }

    @Override
    public Annotation[] getAnnotations() {
        AnnotationsItem item = this.retrieval.retrieveAnnotations();
        if (item == null) {
            return NO_ANNOTATIONS;
        }
        return (Annotation[])item.getValue();
    }

    @Override
    public Annotation[] getLocalAnnotations() {
        AnnotationsItem item = this.retrieval.retrieveLocalAnnotations();
        if (item == null) {
            return NO_ANNOTATIONS;
        }
        return (Annotation[])item.getValue();
    }

    @Override
    public Object[] getMetaData() {
        MetaDatasItem item = this.retrieval.retrieveMetaData();
        if (item == null) {
            return NO_METADATA;
        }
        return (Object[])item.getValue();
    }

    @Override
    public Object[] getLocalMetaData() {
        MetaDatasItem item = this.retrieval.retrieveLocalMetaData();
        if (item == null) {
            return NO_METADATA;
        }
        return (Object[])item.getValue();
    }

    @Override
    public <T> T getMetaData(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        MetaDataItem<T> item = this.retrieval.retrieveMetaData(type);
        if (item == null) {
            return null;
        }
        return item.getValue();
    }

    @Override
    public <T> T getMetaData(String name, Class<T> type) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        MetaDataItem item = this.retrieval.retrieveMetaData(name);
        if (item == null) {
            return null;
        }
        return type.cast(item.getValue());
    }

    @Override
    public Object getMetaData(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        MetaDataItem item = this.retrieval.retrieveMetaData(name);
        if (item == null) {
            return null;
        }
        return item.getValue();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.getAnnotation(annotationType) != null;
    }

    @Override
    public boolean isMetaDataPresent(Class<?> type) {
        return this.getMetaData(type) != null;
    }

    @Override
    public boolean isMetaDataPresent(String name, Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        Object value = this.getMetaData(name);
        if (value == null) {
            return false;
        }
        return type.isInstance(value);
    }

    @Override
    public boolean isMetaDataPresent(String name) {
        return this.getMetaData(name) != null;
    }

    @Override
    public MetaData getComponentMetaData(Signature signature) {
        MetaDataRetrieval component = this.retrieval.getComponentMetaDataRetrieval(signature);
        if (component == null) {
            return null;
        }
        return new MetaDataRetrievalToMetaDataBridge(component);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof MetaDataRetrievalToMetaDataBridge)) {
            return false;
        }
        MetaDataRetrievalToMetaDataBridge other = (MetaDataRetrievalToMetaDataBridge)obj;
        return this.retrieval.equals(other.retrieval);
    }

    public int hashCode() {
        return this.retrieval.hashCode();
    }

    public String toString() {
        return super.toString() + "{" + this.retrieval.getScope() + "}";
    }

    protected MetaDataRetrieval getMetaDataRetrieval() {
        return this.retrieval;
    }
}

