/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.spi.retrieval.basic;

import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.loader.MetaDataLoader;
import org.jboss.metadata.spi.retrieval.MetaDataItem;
import org.jboss.metadata.spi.retrieval.MetaDatasItem;
import org.jboss.metadata.spi.retrieval.basic.BasicItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicMetaDatasItem
extends BasicItem<Object[]>
implements MetaDatasItem {
    private MetaDataItem[] metaDataItems;
    private Object[] metaDatas;

    public BasicMetaDatasItem(MetaDataLoader loader, MetaDataItem[] metaDataItems) {
        super(loader);
        if (metaDataItems == null) {
            throw new IllegalArgumentException("Null metaDataItems");
        }
        this.metaDataItems = metaDataItems;
        if (metaDataItems.length == 0) {
            this.metaDatas = MetaData.NO_METADATA;
        }
    }

    @Override
    public Object[] getValue() {
        if (this.metaDatas == null) {
            Object[] temp = new Object[this.metaDataItems.length];
            for (int i = 0; i < temp.length; ++i) {
                temp[i] = this.metaDataItems[i].getValue();
            }
            this.metaDatas = temp;
        }
        return this.metaDatas;
    }

    @Override
    public MetaDataItem[] getMetaDatas() {
        return this.metaDataItems;
    }

    @Override
    public boolean isCachable() {
        if (!super.isCachable()) {
            return false;
        }
        for (MetaDataItem item : this.metaDataItems) {
            if (item.isCachable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        for (MetaDataItem item : this.metaDataItems) {
            if (item.isValid()) continue;
            return false;
        }
        return true;
    }
}

