/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming;

import java.security.Principal;
import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.ObjectFactory;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aspects.remoting.InvokeRemoteInterceptor;
import org.jboss.aspects.remoting.IsLocalInterceptor;
import org.jboss.aspects.remoting.Remoting;
import org.jboss.aspects.security.SecurityClientInterceptor;
import org.jboss.naming.SecurityAssociationActions;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.callback.UsernamePasswordHandler;
import org.jnp.interfaces.Naming;
import org.jnp.interfaces.NamingContext;

public class JBossRemotingContextFactory
implements InitialContextFactory,
ObjectFactory {
    static void associateSecurityInformation(Object principal, Object credentials) {
        Principal securityPrincipal = null;
        if (principal instanceof Principal) {
            securityPrincipal = (Principal)principal;
        } else {
            String username = principal.toString();
            securityPrincipal = new SimplePrincipal(username);
        }
        SecurityAssociationActions.setPrincipalInfo(securityPrincipal, credentials);
    }

    static void login(Object principal, Object credentials, Object prop) throws AuthenticationException {
        String protocol = prop.toString();
        try {
            String username;
            if (principal instanceof Principal) {
                Principal p = (Principal)principal;
                username = p.getName();
            } else {
                username = principal.toString();
            }
            UsernamePasswordHandler handler = new UsernamePasswordHandler(username, credentials);
            LoginContext lc = new LoginContext(protocol, handler);
            lc.login();
        }
        catch (LoginException e) {
            AuthenticationException ex = new AuthenticationException("Failed to login using protocol=" + protocol);
            ex.setRootCause(e);
            throw ex;
        }
    }

    public Context getInitialContext(Hashtable env) throws NamingException {
        Interceptor[] tmp;
        Class[] interfaces = new Class[]{Naming.class};
        Interceptor[] interceptors = null;
        Naming naming = null;
        Object credentials = env.get("java.naming.security.credentials");
        Object principal = env.get("java.naming.security.principal");
        Object protocol = env.get("java.naming.security.protocol");
        if (principal != null && credentials != null) {
            if (protocol != null) {
                JBossRemotingContextFactory.login(principal, credentials, protocol);
            } else {
                JBossRemotingContextFactory.associateSecurityInformation(principal, credentials);
            }
            interceptors = tmp = new Interceptor[]{IsLocalInterceptor.singleton, SecurityClientInterceptor.singleton, InvokeRemoteInterceptor.singleton};
        } else {
            interceptors = tmp = new Interceptor[]{IsLocalInterceptor.singleton, InvokeRemoteInterceptor.singleton};
        }
        if (NamingContext.localServer != null) {
            return new NamingContext(env, null, NamingContext.localServer);
        }
        String providerUrl = (String)env.get("java.naming.provider.url");
        if (providerUrl == null) {
            throw new RuntimeException("PROVIDER_URL not provided in jndi.properties.  Automatic discovery not implemented yet.");
        }
        try {
            naming = (Naming)Remoting.createPojiProxy("JNDI", interfaces, providerUrl, interceptors);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create Naming proxy", e);
        }
        return new NamingContext(env, null, naming);
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        Context ctx = this.getInitialContext(environment);
        Reference ref = (Reference)obj;
        return ctx.lookup((String)ref.get("URL").getContent());
    }
}

