/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import org.jboss.security.RunAs;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunAsIdentity
extends SimplePrincipal
implements Cloneable,
RunAs {
    private static final long serialVersionUID = -3236178735180485083L;
    private HashSet runAsRoles = new HashSet();
    private HashSet principalsSet;
    private static final String ANOYMOUS_PRINCIPAL = "anonymous";

    public RunAsIdentity(String roleName, String principalName) {
        super(principalName != null ? principalName : ANOYMOUS_PRINCIPAL);
        if (roleName == null) {
            throw new IllegalArgumentException("The run-as identity must have at least one role");
        }
        this.runAsRoles.add(new SimplePrincipal(roleName));
    }

    public RunAsIdentity(String roleName, String principalName, Set extraRoleNames) {
        this(roleName, principalName);
        if (extraRoleNames != null) {
            for (String extraRoleName : extraRoleNames) {
                this.runAsRoles.add(new SimplePrincipal(extraRoleName));
            }
        }
    }

    public Set getRunAsRoles() {
        return new HashSet(this.runAsRoles);
    }

    public synchronized Set getPrincipalsSet() {
        if (this.principalsSet == null) {
            this.principalsSet = new HashSet();
            this.principalsSet.add(this);
            SimpleGroup roles = new SimpleGroup("Roles");
            this.principalsSet.add(roles);
            for (Principal role : this.runAsRoles) {
                roles.addMember(role);
            }
        }
        return this.principalsSet;
    }

    public boolean doesUserHaveRole(Principal role) {
        return this.runAsRoles.contains(role);
    }

    public boolean doesUserHaveRole(Set methodRoles) {
        for (Principal role : methodRoles) {
            if (!this.doesUserHaveRole(role)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "[roles=" + this.runAsRoles + ",principal=" + this.getName() + "]";
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        RunAsIdentity clone = (RunAsIdentity)super.clone();
        if (clone != null) {
            clone.principalsSet = (HashSet)this.principalsSet.clone();
            clone.runAsRoles = (HashSet)this.runAsRoles.clone();
        }
        return clone;
    }

    @Override
    public <T> T getIdentity() {
        return (T)this.getName();
    }

    @Override
    public <T> T getProof() {
        return (T)this.getRunAsRoles();
    }
}

