/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import com.sun.xacml.Policy;
import java.io.InputStream;
import java.net.URL;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import org.jboss.logging.Logger;
import org.jboss.security.AnybodyPrincipal;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.NobodyPrincipal;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityRolesAssociation;
import org.jboss.security.SimpleGroup;
import org.jboss.security.Util;
import org.jboss.security.authorization.AuthorizationContext;
import org.jboss.security.authorization.AuthorizationException;
import org.jboss.security.authorization.PolicyRegistration;
import org.jboss.security.authorization.Resource;
import org.jboss.security.mapping.MappingContext;
import org.jboss.security.plugins.JBossSecurityContext;
import org.jboss.security.plugins.SubjectActions;
import org.jboss.util.xml.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JBossAuthorizationManager
implements AuthorizationManager,
PolicyRegistration {
    private String securityDomain;
    private Map contextIdToPolicy = new HashMap();
    private static Logger log = Logger.getLogger(JBossAuthorizationManager.class);
    protected boolean trace = log.isTraceEnabled();
    private CallbackHandler callbackHandler = null;

    public JBossAuthorizationManager(String securityDomainName, CallbackHandler cbh) {
        this.securityDomain = securityDomainName;
        this.callbackHandler = cbh;
    }

    public int authorize(Resource resource) throws AuthorizationException {
        String SUBJECT_CONTEXT_KEY = "javax.security.auth.Subject.container";
        Subject subject = null;
        try {
            subject = (Subject)PolicyContext.getContext(SUBJECT_CONTEXT_KEY);
        }
        catch (PolicyContextException e) {
            log.error("Error obtaining AuthenticatedSubject:", e);
        }
        AuthorizationContext ac = new AuthorizationContext(this.securityDomain, subject, this.callbackHandler);
        return ac.authorize(resource);
    }

    public boolean doesUserHaveRole(Principal principal, Set rolePrincipals) {
        boolean hasRole = false;
        Group roles = this.getCurrentRoles(principal);
        if (this.trace) {
            log.trace("doesUserHaveRole(Set), roles: " + roles);
        }
        if (roles != null) {
            Iterator iter = rolePrincipals.iterator();
            while (!hasRole && iter.hasNext()) {
                Principal role = (Principal)iter.next();
                hasRole = this.doesRoleGroupHaveRole(role, roles);
                if (!this.trace) continue;
                log.trace("hasRole(" + role + ")=" + hasRole);
            }
            if (this.trace) {
                log.trace("hasRole=" + hasRole);
            }
        }
        return hasRole;
    }

    public boolean doesUserHaveRole(Principal principal, Principal role) {
        boolean hasRole = false;
        Group roles = this.getCurrentRoles(principal);
        hasRole = this.doesRoleGroupHaveRole(role, roles);
        return hasRole;
    }

    public Set getUserRoles(Principal principal) {
        Group userRoles = this.getCurrentRoles(principal);
        return this.getRolesAsSet(userRoles);
    }

    protected boolean doesRoleGroupHaveRole(Principal role, Group userRoles) {
        if (role instanceof NobodyPrincipal) {
            return false;
        }
        boolean isMember = userRoles.isMember(role);
        if (!isMember) {
            isMember = role instanceof AnybodyPrincipal;
        }
        return isMember;
    }

    public void registerPolicy(String contextID, URL location) {
        try {
            if (this.trace) {
                log.trace("Registering policy for contextId:" + contextID + " and location:" + location.getPath());
            }
            this.registerPolicy(contextID, location.openStream());
        }
        catch (Exception e) {
            log.debug("Error in registering xacml policy:", e);
        }
    }

    public void registerPolicy(String contextID, InputStream stream) {
        try {
            Element elm = DOMUtils.parse(stream);
            Policy policy = Policy.getInstance((Node)elm);
            this.contextIdToPolicy.put(contextID, policy);
        }
        catch (Exception e) {
            log.debug("Error in registering xacml policy:", e);
        }
    }

    public void deRegisterPolicy(String contextID) {
        this.contextIdToPolicy.remove(contextID);
        if (this.trace) {
            log.trace("DeRegistered policy for contextId:" + contextID);
        }
    }

    public Object getPolicy(String contextID, Map contextMap) {
        return this.contextIdToPolicy.get(contextID);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[AuthorizationManager:class=").append(this.getClass().getName());
        buf.append(":").append(this.securityDomain).append(":");
        buf.append("]");
        return buf.toString();
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    private HashSet getRolesAsSet(Group roles) {
        HashSet<Principal> userRoles = null;
        if (roles != null) {
            userRoles = new HashSet<Principal>();
            Enumeration members = roles.members();
            while (members.hasMoreElements()) {
                Principal role = (Principal)members.nextElement();
                userRoles.add(role);
            }
        }
        return userRoles;
    }

    private Group getCurrentRoles(Principal principal) {
        Group userRoles;
        boolean emptyContextRoles = false;
        Subject subject = SubjectActions.getActiveSubject();
        Group subjectRoles = Util.getSubjectRoles(subject);
        SecurityContext sc = SubjectActions.getSecurityContext(this.securityDomain);
        if (sc == null) {
            sc = new JBossSecurityContext(this.securityDomain);
            SubjectActions.setSecurityContext(sc, this.securityDomain);
        }
        if ((userRoles = (Group)sc.getData().get("Roles")) == null || "true".equalsIgnoreCase(SubjectActions.getRefreshSecurityContextRoles())) {
            emptyContextRoles = true;
        }
        if (subjectRoles != (userRoles = this.copyGroups(userRoles, subjectRoles)) || emptyContextRoles) {
            MappingContext mc = sc.getMappingManager().getMappingContext(Group.class);
            if (mc != null) {
                HashMap<String, Object> contextMap = new HashMap<String, Object>();
                contextMap.put("Roles", userRoles);
                contextMap.put("Principal", principal);
                contextMap.put("deploymentPrincipalRolesMap", SecurityRolesAssociation.getSecurityRoles());
                contextMap.put("PrincipalsSet", subject.getPrincipals());
                if (this.trace) {
                    log.trace("Roles before mapping:" + userRoles);
                }
                mc.performMapping(contextMap, userRoles);
                if (this.trace) {
                    log.trace("Roles after mapping:" + userRoles);
                }
            }
            sc.getData().put("Roles", userRoles);
        }
        return userRoles;
    }

    private Group copyGroups(Group source, Group toCopy) {
        if (toCopy == null) {
            return source;
        }
        if (source == null && toCopy != null) {
            source = new SimpleGroup("Roles");
        }
        Enumeration en = toCopy.members();
        while (en.hasMoreElements()) {
            source.addMember((Principal)en.nextElement());
        }
        return source;
    }

    public Group getTargetRoles(Principal targetPrincipal, Map contextMap) {
        throw new RuntimeException("Not implemented");
    }
}

