/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.metadata;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.jboss.system.ConfigurationException;
import org.jboss.util.Classes;
import org.jboss.util.StringPropertyReplacer;

public class ServiceConstructorMetaData
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Object[] EMPTY_PARAMETERS = new Object[0];
    public static final String[] EMPTY_PARAMS = new String[0];
    public static final String[] EMPTY_SIGNATURE = new String[0];
    private String[] signature = EMPTY_SIGNATURE;
    private String[] params = EMPTY_PARAMS;
    private Object[] parameters;

    public String[] getParams() {
        return this.params;
    }

    public void setParams(String[] params) {
        if (params == null) {
            throw new IllegalArgumentException("Null params");
        }
        this.params = params;
    }

    public String[] getSignature() throws ConfigurationException {
        for (String string : this.signature) {
            if (string != null && string.trim().length() != 0) continue;
            throw new ConfigurationException("Missing or empty 'type' attribute in constructor arg");
        }
        return this.signature;
    }

    public void setSignature(String[] signature) {
        if (signature == null) {
            throw new IllegalArgumentException("Null signature");
        }
        this.signature = signature;
    }

    public Object[] getParameters(ClassLoader cl) throws Exception {
        if (this.parameters != null) {
            return this.parameters;
        }
        if (this.params.length == 0) {
            return EMPTY_PARAMETERS;
        }
        String[] signature = this.getSignature();
        Object[] result = new Object[this.params.length];
        for (int i = 0; i < result.length; ++i) {
            if (this.params[i] == null) {
                throw new ConfigurationException("Missing 'value' attribute in constructor arg");
            }
            String value = StringPropertyReplacer.replaceProperties(this.params[i]);
            Object realValue = value;
            if (signature[i] != null) {
                PropertyEditor editor;
                Class<?> typeClass = Classes.getPrimitiveTypeForName(signature[i]);
                if (typeClass == null) {
                    typeClass = cl.loadClass(signature[i]);
                }
                if ((editor = PropertyEditorManager.findEditor(typeClass)) == null) {
                    try {
                        Class[] sig = new Class[]{String.class};
                        Constructor<?> ctor = typeClass.getConstructor(sig);
                        Object[] args = new Object[]{value};
                        realValue = ctor.newInstance(args);
                    }
                    catch (Exception e) {
                        throw new ConfigurationException("No property editor for type: " + typeClass);
                    }
                } else {
                    editor.setAsText(value);
                    realValue = editor.getValue();
                }
            }
            result[i] = realValue;
        }
        return result;
    }

    public void setParameters(Object[] parameters) {
        this.parameters = parameters;
    }
}

