/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.transaction.xa.Xid;
import org.jboss.tm.TransactionImpl;
import org.jboss.tm.XidImpl;

public class GlobalId
implements Externalizable {
    static final long serialVersionUID = -230282197045463046L;
    private static String thisClassName = GlobalId.class.getName();
    private int formatId;
    private byte[] globalId;
    private int hash;

    public GlobalId() {
    }

    GlobalId(int formatId, byte[] globalId, int hash) {
        this.formatId = formatId;
        this.globalId = globalId;
        this.hash = hash;
    }

    public GlobalId(int formatId, byte[] globalId) {
        this.formatId = formatId;
        this.globalId = globalId;
        this.hash = this.computeHash();
    }

    public GlobalId(Xid xid) {
        this.formatId = xid.getFormatId();
        this.globalId = xid.getGlobalTransactionId();
        this.hash = xid instanceof XidImpl && this.formatId == 257 ? xid.hashCode() : this.computeHash();
    }

    public GlobalId(int formatId, int bqual_length, byte[] tid) {
        this.formatId = formatId;
        if (bqual_length == 0) {
            this.globalId = tid;
        } else {
            int len = tid.length - bqual_length;
            this.globalId = new byte[len];
            System.arraycopy(tid, 0, this.globalId, 0, len);
        }
        this.hash = this.computeHash();
    }

    public byte[] getGlobalTransactionId() {
        return (byte[])this.globalId.clone();
    }

    public int getFormatId() {
        return this.formatId;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GlobalId) {
            GlobalId other = (GlobalId)obj;
            if (this.formatId != other.formatId) {
                return false;
            }
            if (this.globalId == other.globalId) {
                return true;
            }
            if (this.globalId.length != other.globalId.length) {
                return false;
            }
            int len = this.globalId.length;
            for (int i = 0; i < len; ++i) {
                if (this.globalId[i] == other.globalId[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return thisClassName + "[formatId=" + this.formatId + ", globalId=" + new String(this.globalId).trim() + ", hash=" + this.hash + "]";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.formatId);
        out.writeObject(this.globalId);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.formatId = in.readInt();
        this.globalId = (byte[])in.readObject();
        this.hash = this.computeHash();
    }

    private int computeHash() {
        if (this.formatId == 257) {
            return (int)TransactionImpl.xidFactory.extractLocalIdFrom(this.globalId);
        }
        int len = this.globalId.length;
        int hashval = 0;
        for (int i = 0; i < len; ++i) {
            hashval = 3 * this.globalId[i] + hashval;
        }
        return hashval += this.formatId;
    }

    static {
        thisClassName = thisClassName.substring(thisClassName.lastIndexOf(46) + 1);
    }
}

