/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm.recovery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.logging.Logger;
import org.jboss.tm.TxManager;
import org.jboss.tm.TxUtils;
import org.jboss.tm.XidFactoryBase;
import org.jboss.tm.recovery.CorruptedLogRecordException;
import org.jboss.tm.recovery.HeuristicStatusLogReader;
import org.jboss.tm.recovery.LogRecord;
import org.jboss.tm.recovery.Recoverable;
import org.jboss.tm.recovery.RecoveryLogReader;
import org.jboss.tm.recovery.RecoveryLogger;
import org.jboss.tm.recovery.TxCompletionHandler;
import org.jboss.tm.recovery.XAResourceAccess;
import org.jboss.tm.recovery.XAWork;

public class RecoveryManager {
    private static Logger log = Logger.getLogger(RecoveryManager.class.getName());
    private XidFactoryBase xidFactory;
    private TxManager txManager;
    private RecoveryLogger recoveryLogger;

    public RecoveryManager(XidFactoryBase xidFactory, TxManager txManager, RecoveryLogger recoveryLogger) {
        this.xidFactory = xidFactory;
        this.txManager = txManager;
        this.recoveryLogger = recoveryLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover(ArrayList recoverables) {
        RecoveryLogReader[] readers;
        HashMap heuristicallyCompletedTransactions = new HashMap();
        HeuristicStatusLogReader[] heurStatusLogReaders = this.recoveryLogger.getHeuristicStatusLogs();
        if (heurStatusLogReaders != null) {
            for (int i = 0; i < heurStatusLogReaders.length; ++i) {
                heurStatusLogReaders[i].recover(heuristicallyCompletedTransactions);
            }
            for (Long localId : heuristicallyCompletedTransactions.keySet()) {
                LogRecord.HeurData heurData = (LogRecord.HeurData)heuristicallyCompletedTransactions.get(localId);
                this.recoveryLogger.saveHeuristicStatus(heurData.localTransactionId, heurData.foreignTx, heurData.formatId, heurData.globalTransactionId, heurData.inboundBranchQualifier, heurData.transactionStatus, heurData.heuristicStatusCode, heurData.locallyDetectedHeuristicHazard, heurData.xaResourceHeuristics, heurData.remoteResourceHeuristics);
            }
            for (int i = 0; i < heurStatusLogReaders.length; ++i) {
                heurStatusLogReaders[i].finishRecovery();
            }
        }
        if ((readers = this.recoveryLogger.getRecoveryLogs()) == null || readers.length == 0) {
            return;
        }
        HashSet<String> readerBranchQualifiers = new HashSet<String>();
        for (int i = 0; i < readers.length; ++i) {
            String branchQualifier = null;
            try {
                branchQualifier = readers[i].getBranchQualifier();
            }
            catch (Exception e) {
                log.error("logfile corrupted: " + readers[i].getLogFileName(), e);
            }
            readerBranchQualifiers.add(branchQualifier);
            log.info("will recover transactions with branch qualifier " + branchQualifier + " (logFile: " + readers[i].getLogFileName() + ")");
        }
        HashMap<String, XAResourceXids> toRecoverMap = new HashMap<String, XAResourceXids>();
        try {
            for (int i = 0; i < recoverables.size(); ++i) {
                XAResourceXids xaResXids;
                Recoverable rec = (Recoverable)recoverables.get(i);
                try {
                    xaResXids = new XAResourceXids(rec);
                }
                catch (Throwable t) {
                    throw new RuntimeException("Unable to getResource: " + rec.getId() + " aborting recovery.", t);
                }
                toRecoverMap.put(rec.getId(), xaResXids);
                try {
                    xaResXids.xids.addAll(this.pruneXidList(rec.scan(), readerBranchQualifiers, rec.getId()));
                    continue;
                }
                catch (XAException e) {
                    throw new RuntimeException("Unable to scan: " + rec.getId(), e);
                }
            }
            this.recover(readers, heuristicallyCompletedTransactions, toRecoverMap);
        }
        finally {
            this.cleanupRecoverables(toRecoverMap.values().iterator());
        }
    }

    private void recover(RecoveryLogReader[] readers, Map heuristicallyCompletedTransactions, Map toRecoverMap) {
        boolean presumeRollback = true;
        CorruptedLogRecordException corruptedLogRecordException = null;
        for (int i = 0; i < readers.length; ++i) {
            ArrayList inDoubtJcaTransactions;
            ArrayList inDoubtTransactions;
            ArrayList committedMultiTmTransactions;
            ArrayList committedSingleTmTransactions;
            block12: {
                log.info("recovering log file " + readers[i].getLogFileName());
                committedSingleTmTransactions = new ArrayList();
                committedMultiTmTransactions = new ArrayList();
                inDoubtTransactions = new ArrayList();
                inDoubtJcaTransactions = new ArrayList();
                try {
                    readers[i].recover(committedSingleTmTransactions, committedMultiTmTransactions, inDoubtTransactions, inDoubtJcaTransactions);
                }
                catch (CorruptedLogRecordException e) {
                    log.trace("reader threw CorruptedLogRecordException with disablePresumedRollback=" + e.disablePresumedRollback);
                    corruptedLogRecordException = e;
                    if (!corruptedLogRecordException.disablePresumedRollback) break block12;
                    presumeRollback = false;
                }
            }
            int pendingTransactions = committedSingleTmTransactions.size() + committedMultiTmTransactions.size() + inDoubtTransactions.size() + inDoubtJcaTransactions.size();
            if (pendingTransactions == 0) {
                readers[i].finishRecovery();
                continue;
            }
            CompletionHandler completionHandler = new CompletionHandler(readers[i], pendingTransactions);
            this.resumePendingTransactions(heuristicallyCompletedTransactions, committedSingleTmTransactions, committedMultiTmTransactions, inDoubtTransactions, inDoubtJcaTransactions, toRecoverMap, completionHandler);
        }
        Iterator heurIt = heuristicallyCompletedTransactions.keySet().iterator();
        while (heurIt.hasNext()) {
            Long localId = (Long)heurIt.next();
            LogRecord.HeurData heurData = (LogRecord.HeurData)heuristicallyCompletedTransactions.get(localId);
            heurIt.remove();
            byte[] globalId = heurData.globalTransactionId;
            List xaResourcesWithHeuristics = this.getXAWork(globalId, toRecoverMap);
            this.txManager.recreateTransaction(heurData, xaResourcesWithHeuristics, null);
        }
        if (!presumeRollback) {
            log.info("PRESUMED ROLLBACK IS DISABLED DUE TO LOG FILE CORRUPTION.");
        }
        for (XAResourceXids xaResXids : toRecoverMap.values()) {
            for (Xid xid : xaResXids.xids) {
                if (!presumeRollback) {
                    log.info("WOULD ROLLBACK " + this.xidFactory.toString(xid) + " ON RECOVERABLE XAResource " + xaResXids.recoverable.getId() + ", BUT PRESUMED ROLLBACK IS DISABLED");
                    continue;
                }
                try {
                    xaResXids.resource.rollback(xid);
                    log.info("rolledback " + this.xidFactory.toString(xid) + " on recoverable XAResource " + xaResXids.recoverable.getId());
                }
                catch (XAException e) {
                    log.warn("XAException in recover (when rolling back res " + xaResXids.recoverable.getId() + ", xid=" + this.xidFactory.toString(xid) + "): errorCode=" + TxUtils.getXAErrorCodeAsString(e.errorCode), e);
                }
            }
        }
        if (corruptedLogRecordException != null) {
            throw corruptedLogRecordException;
        }
    }

    private void resumePendingTransactions(Map heuristicallyCompletedTransactions, List committedSingleTmTransactions, List committedMultiTmTransactions, List inDoubtTransactions, List inDoubtJcaTransactions, Map toRecoverMap, TxCompletionHandler completionHandler) {
        List preparedXAWorkList;
        List pendingXAWorkList;
        List xaResourcesWithHeuristics;
        LogRecord.HeurData heurData;
        Long localId;
        byte[] globalId;
        for (LogRecord.Data data : committedSingleTmTransactions) {
            globalId = data.globalTransactionId;
            localId = new Long(data.localTransactionId);
            heurData = (LogRecord.HeurData)heuristicallyCompletedTransactions.get(localId);
            if (heurData != null) {
                heuristicallyCompletedTransactions.remove(localId);
            }
            if (heurData != null && !heurData.locallyDetectedHeuristicHazard) {
                xaResourcesWithHeuristics = this.getXAWork(globalId, toRecoverMap);
                this.txManager.recreateTransaction(heurData, xaResourcesWithHeuristics, completionHandler);
                continue;
            }
            pendingXAWorkList = this.commitXAWork(globalId, toRecoverMap);
            if (pendingXAWorkList.isEmpty()) {
                if (heurData == null) {
                    completionHandler.handleTxCompletion(data.localTransactionId);
                    continue;
                }
                this.txManager.recreateTransaction(heurData, pendingXAWorkList, completionHandler);
                continue;
            }
            this.txManager.recreateTransaction(data.localTransactionId, pendingXAWorkList, completionHandler, heurData);
        }
        for (LogRecord.Data data : committedMultiTmTransactions) {
            globalId = data.globalTransactionId;
            localId = new Long(data.localTransactionId);
            heurData = (LogRecord.HeurData)heuristicallyCompletedTransactions.get(localId);
            if (heurData != null) {
                heuristicallyCompletedTransactions.remove(localId);
            }
            if (heurData != null && !heurData.locallyDetectedHeuristicHazard) {
                xaResourcesWithHeuristics = this.getXAWork(globalId, toRecoverMap);
                this.txManager.recreateTransaction(heurData, xaResourcesWithHeuristics, completionHandler);
                continue;
            }
            pendingXAWorkList = this.commitXAWork(globalId, toRecoverMap);
            this.txManager.recreateTransaction(data.localTransactionId, pendingXAWorkList, data.resources, completionHandler, heurData);
        }
        for (LogRecord.Data data : inDoubtTransactions) {
            globalId = data.globalTransactionId;
            localId = new Long(data.localTransactionId);
            heurData = (LogRecord.HeurData)heuristicallyCompletedTransactions.get(localId);
            if (heurData != null) {
                heuristicallyCompletedTransactions.remove(localId);
            }
            if (heurData != null && !heurData.locallyDetectedHeuristicHazard) {
                heuristicallyCompletedTransactions.remove(localId);
                xaResourcesWithHeuristics = this.getXAWork(globalId, toRecoverMap);
                this.txManager.recreateTransaction(heurData, xaResourcesWithHeuristics, completionHandler);
                continue;
            }
            if (heurData == null) {
                preparedXAWorkList = this.getXAWork(globalId, toRecoverMap);
                this.txManager.recreateTransaction(data.localTransactionId, data.inboundFormatId, data.globalTransactionId, data.recoveryCoordinator, preparedXAWorkList, data.resources, completionHandler, null);
                continue;
            }
            if (heurData.transactionStatus == 8) {
                pendingXAWorkList = this.commitXAWork(globalId, toRecoverMap);
                this.txManager.recreateTransaction(data.localTransactionId, data.inboundFormatId, data.globalTransactionId, data.recoveryCoordinator, pendingXAWorkList, data.resources, completionHandler, heurData);
                continue;
            }
            if (heurData.transactionStatus == 9) {
                pendingXAWorkList = this.rollbackXAWork(globalId, toRecoverMap);
                this.txManager.recreateTransaction(data.localTransactionId, data.inboundFormatId, data.globalTransactionId, data.recoveryCoordinator, pendingXAWorkList, data.resources, completionHandler, heurData);
                continue;
            }
            log.warn("Cannot recover tx=" + this.toString() + "\nInconsistent state", new Throwable("[Stack trace]"));
        }
        for (LogRecord.Data data : inDoubtJcaTransactions) {
            List pendingXAWorkList2;
            globalId = data.globalTransactionId;
            localId = new Long(data.localTransactionId);
            heurData = (LogRecord.HeurData)heuristicallyCompletedTransactions.get(localId);
            if (heurData != null) {
                heuristicallyCompletedTransactions.remove(localId);
            }
            if (heurData != null && !heurData.locallyDetectedHeuristicHazard) {
                xaResourcesWithHeuristics = this.getXAWork(globalId, toRecoverMap);
                this.txManager.recreateTransaction(heurData, xaResourcesWithHeuristics, completionHandler);
                continue;
            }
            preparedXAWorkList = this.getXAWork(globalId, toRecoverMap);
            if (heurData == null) {
                this.txManager.recreateTransaction(data.localTransactionId, data.inboundFormatId, data.globalTransactionId, data.inboundBranchQualifier, preparedXAWorkList, data.resources, completionHandler, null);
                continue;
            }
            if (heurData.transactionStatus == 8) {
                pendingXAWorkList2 = this.commitXAWork(globalId, toRecoverMap);
                this.txManager.recreateTransaction(data.localTransactionId, data.inboundFormatId, data.globalTransactionId, data.inboundBranchQualifier, pendingXAWorkList2, data.resources, completionHandler, heurData);
                continue;
            }
            if (heurData.transactionStatus == 9) {
                pendingXAWorkList2 = this.rollbackXAWork(globalId, toRecoverMap);
                this.txManager.recreateTransaction(data.localTransactionId, data.inboundFormatId, data.globalTransactionId, data.inboundBranchQualifier, pendingXAWorkList2, data.resources, completionHandler, heurData);
                continue;
            }
            log.warn("Cannot recover tx=" + this.toString() + "\nInconsistent state", new Throwable("[Stack trace]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private List commitXAWork(byte[] globalId, Map toRecoverMap) {
        RecoveryManager.log.info("*** trying to complete XA work with globalId " + new String(globalId).trim());
        globalId = this.pad(globalId);
        pendingXAWorkList = new ArrayList<XAWork>();
        rit = toRecoverMap.values().iterator();
        while (rit.hasNext()) {
            toRecover = (XAResourceXids)rit.next();
            RecoveryManager.log.info("    looking at resource " + toRecover.recoverable.getId());
            resXidIt = toRecover.xids.iterator();
lbl9:
            // 10 sources

            block14: while (resXidIt.hasNext()) {
                resXid = (Xid)resXidIt.next();
                resGlobalId = this.pad(resXid.getGlobalTransactionId());
                if (!Arrays.equals(globalId, resGlobalId)) continue;
                try {
                    toRecover.resource.commit(resXid, false);
                    RecoveryManager.log.info("        committed: " + resXid);
                }
                catch (XAException e) {
                    switch (e.errorCode) {
                        case 7: {
                            RecoveryManager.log.trace("commitXAWork ignored XAException.XA_HEURCOM", e);
                            try {
                                toRecover.resource.forget(resXid);
                            }
                            catch (XAException xae) {
                                RecoveryManager.log.warn("XAException in commitXAWork (when forgetting XA_HEURCOM): errorCode=" + TxUtils.getXAErrorCodeAsString(xae.errorCode), xae);
                            }
                            continue block14;
                        }
                        case 5: 
                        case 6: 
                        case 8: {
                            RecoveryManager.log.warn("Heuristic XAException in commitXAWork: errorCode=" + TxUtils.getXAErrorCodeAsString(e.errorCode) + "\nWill deal with the heuristic later", e);
                            postponedWork = new XAWork(toRecover.resource, resXid, toRecover.resourceAccess);
                            pendingXAWorkList.add(postponedWork);
                            ** break;
                        }
                        case -3: {
                            RecoveryManager.log.warn("Unexpected XAException in commitXAWork: errorCode=" + TxUtils.getXAErrorCodeAsString(e.errorCode), e);
                            ** break;
                        }
                        case -7: 
                        case 4: {
                            RecoveryManager.log.warn("XAException in commitXAWork: errorCode=" + TxUtils.getXAErrorCodeAsString(e.errorCode) + "\nWill attempt to commit the XAResource later", e);
                            pendingXAWork = new XAWork(toRecover.resource, resXid, toRecover.resourceAccess);
                            pendingXAWorkList.add(pendingXAWork);
                            ** break;
                        }
                        default: {
                            RecoveryManager.log.warn("Could not recover from unexpected XAException:  errorCode=" + TxUtils.getXAErrorCodeAsString(e.errorCode), e);
                            continue block14;
                        }
                    }
                }
                finally {
                    resXidIt.remove();
                }
            }
            if (!toRecover.xids.isEmpty()) continue;
            rit.remove();
        }
        return pendingXAWorkList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private List rollbackXAWork(byte[] globalId, Map toRecoverMap) {
        RecoveryManager.log.info("*** trying to rollback XA work with globalId " + new String(globalId).trim());
        globalId = this.pad(globalId);
        pendingXAWorkList = new ArrayList<XAWork>();
        rit = toRecoverMap.values().iterator();
        while (rit.hasNext()) {
            toRecover = (XAResourceXids)rit.next();
            RecoveryManager.log.info("    looking at resource " + toRecover.recoverable.getId());
            resXidIt = toRecover.xids.iterator();
lbl9:
            // 10 sources

            block14: while (resXidIt.hasNext()) {
                resXid = (Xid)resXidIt.next();
                resGlobalId = this.pad(resXid.getGlobalTransactionId());
                if (!Arrays.equals(globalId, resGlobalId)) continue;
                try {
                    toRecover.resource.rollback(resXid);
                    RecoveryManager.log.info("        rolledback: " + resXid);
                }
                catch (XAException e) {
                    switch (e.errorCode) {
                        case 6: {
                            RecoveryManager.log.trace("rollbackXAWork ignored XAException.XA_HEURRB", e);
                            try {
                                toRecover.resource.forget(resXid);
                            }
                            catch (XAException xae) {
                                RecoveryManager.log.warn("XAException in rollbackXAWork (when forgetting XA_HEURRB): errorCode=" + TxUtils.getXAErrorCodeAsString(xae.errorCode), xae);
                            }
                            continue block14;
                        }
                        case 5: 
                        case 7: 
                        case 8: {
                            RecoveryManager.log.warn("Heuristic XAException in rollbackXAWork: errorCode=" + TxUtils.getXAErrorCodeAsString(e.errorCode) + "\nWill deal with the heuristic later", e);
                            postponedWork = new XAWork(toRecover.resource, resXid, toRecover.resourceAccess);
                            pendingXAWorkList.add(postponedWork);
                            ** break;
                        }
                        case -3: {
                            RecoveryManager.log.warn("Unexpected XAException in rollbackXAWork: errorCode=" + TxUtils.getXAErrorCodeAsString(e.errorCode), e);
                            ** break;
                        }
                        case -7: 
                        case 4: {
                            RecoveryManager.log.warn("XAException in rollbackXAWork: errorCode=" + TxUtils.getXAErrorCodeAsString(e.errorCode) + "\nWill attempt to rollback the XAResource later", e);
                            pendingXAWork = new XAWork(toRecover.resource, resXid, toRecover.resourceAccess);
                            pendingXAWorkList.add(pendingXAWork);
                            ** break;
                        }
                        default: {
                            RecoveryManager.log.warn("Could not recover from unexpected XAException:  errorCode=" + TxUtils.getXAErrorCodeAsString(e.errorCode), e);
                            continue block14;
                        }
                    }
                }
                finally {
                    resXidIt.remove();
                }
            }
            if (!toRecover.xids.isEmpty()) continue;
            rit.remove();
        }
        return pendingXAWorkList;
    }

    private List getXAWork(byte[] globalId, Map toRecoverMap) {
        log.info("*** getting XA work with globalId " + new String(globalId).trim());
        globalId = this.pad(globalId);
        ArrayList<XAWork> xaWorkList = new ArrayList<XAWork>();
        for (XAResourceXids toRecover : toRecoverMap.values()) {
            log.info("    looking at resource " + toRecover.recoverable.getId());
            Iterator resXidIt = toRecover.xids.iterator();
            while (resXidIt.hasNext()) {
                Xid resXid = (Xid)resXidIt.next();
                byte[] resGlobalId = this.pad(resXid.getGlobalTransactionId());
                if (!Arrays.equals(globalId, resGlobalId)) continue;
                XAWork preparedXAWork = new XAWork(toRecover.resource, resXid, toRecover.resourceAccess);
                xaWorkList.add(preparedXAWork);
                resXidIt.remove();
            }
        }
        return xaWorkList;
    }

    private void cleanupRecoverables(Iterator it) {
        while (it.hasNext()) {
            XAResourceXids xaResXids = (XAResourceXids)it.next();
            try {
                xaResXids.resourceAccess.release();
            }
            catch (Exception exception) {}
        }
    }

    private List pruneXidList(Xid[] xids, Set branchQualifiers, String resourceName) {
        ArrayList<Xid> list2 = new ArrayList<Xid>();
        for (int i = 0; i < xids.length; ++i) {
            byte[] branchQual = xids[i].getBranchQualifier();
            String baseBranchQual = this.xidFactory.getBaseBranchQualifier(branchQual);
            if (!branchQualifiers.contains(baseBranchQual)) continue;
            list2.add(xids[i]);
            log.info("Adding xid " + this.xidFactory.toString(xids[i]) + " to pruned Xid list for " + resourceName);
        }
        return list2;
    }

    private byte[] pad(byte[] globalId) {
        if (globalId.length < 64) {
            byte[] bytes = new byte[64];
            System.arraycopy(globalId, 0, bytes, 0, globalId.length);
            globalId = bytes;
        }
        return globalId;
    }

    private static class CompletionHandler
    implements TxCompletionHandler {
        private RecoveryLogReader reader;
        private int pendingTransactions;

        CompletionHandler(RecoveryLogReader reader, int pendingTransactions) {
            this.reader = reader;
            this.pendingTransactions = pendingTransactions;
        }

        public void handleTxCompletion(long localTransactionId) {
            if (--this.pendingTransactions == 0) {
                this.reader.finishRecovery();
            }
        }
    }

    private static class XAResourceXids {
        public Recoverable recoverable;
        public XAResource resource;
        public XAResourceAccessImpl resourceAccess;
        public Set xids;

        XAResourceXids(Recoverable recoverable) {
            this.recoverable = recoverable;
            this.resource = recoverable.getResource();
            this.resourceAccess = new XAResourceAccessImpl(recoverable);
            this.xids = new HashSet();
        }
    }

    public static class XAResourceAccessImpl
    implements XAResourceAccess {
        private Recoverable recoverable;
        private int refCount;

        XAResourceAccessImpl(Recoverable recoverable) {
            this.recoverable = recoverable;
            this.refCount = 1;
        }

        synchronized XAResourceAccess duplicate() {
            ++this.refCount;
            return this;
        }

        public synchronized void release() {
            if (this.refCount <= 0) {
                log.warn("release called, but refCount=" + this.refCount + ", this=" + this, new Throwable("[Stack trace]"));
            }
            if (--this.refCount == 0) {
                this.recoverable.cleanupResource();
            }
        }
    }
}

