/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.spi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import org.jboss.util.file.ArchiveBrowser;
import org.jboss.virtual.plugins.context.VfsArchiveBrowserFactory;
import org.jboss.virtual.plugins.context.file.FileSystemContextFactory;
import org.jboss.virtual.plugins.context.jar.JarContextFactory;
import org.jboss.virtual.spi.VFSContextFactory;

public class VFSContextFactoryLocator {
    private static final Logger log = Logger.getLogger(VFSContextFactoryLocator.class);
    private static final Map<String, VFSContextFactory> factoryByProtocol = new ConcurrentHashMap<String, VFSContextFactory>();
    public static final String DEFAULT_FACTORY_PROPERTY = VFSContextFactory.class.getName();
    public static final String SERVICES_PATH = "META-INF/services/" + VFSContextFactory.class.getName();
    private static boolean initialized;

    public static synchronized void registerFactory(VFSContextFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Null VFSContextFactory");
        }
        String[] protocols = factory.getProtocols();
        if (protocols == null || protocols.length == 0) {
            throw new IllegalArgumentException("VFSContextFactory trying to register null or no protocols: " + factory);
        }
        for (String protocol : protocols) {
            if (protocol == null) {
                throw new IllegalArgumentException("VFSContextFactory try to register a null protocol: " + factory + " protocols=" + Arrays.asList(protocols));
            }
            VFSContextFactory other = factoryByProtocol.get(protocol);
            if (other == null) continue;
            throw new IllegalStateException("VFSContextFactory: " + other + " already registered for protocol: " + protocol);
        }
        boolean trace = log.isTraceEnabled();
        for (String protocol : protocols) {
            factoryByProtocol.put(protocol, factory);
            if (!trace) continue;
            log.trace("Registered " + factory + " for protocol: " + protocol);
        }
    }

    public static synchronized boolean unregisterFactory(VFSContextFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Null VFSContextFactory");
        }
        ArrayList<String> protocols = new ArrayList<String>();
        for (Map.Entry<String, VFSContextFactory> entry : factoryByProtocol.entrySet()) {
            if (factory != entry.getValue()) continue;
            protocols.add(entry.getKey());
        }
        boolean trace = log.isTraceEnabled();
        for (String protocol : protocols) {
            factoryByProtocol.remove(protocol);
            if (!trace) continue;
            log.trace("Unregistered " + factory + " for protocol: " + protocol);
        }
        return !protocols.isEmpty();
    }

    public static VFSContextFactory getFactory(URL rootURL) {
        if (rootURL == null) {
            throw new IllegalArgumentException("Null rootURL");
        }
        VFSContextFactoryLocator.init();
        String protocol = rootURL.getProtocol();
        return factoryByProtocol.get(protocol);
    }

    public static VFSContextFactory getFactory(URI rootURI) {
        if (rootURI == null) {
            throw new IllegalArgumentException("Null rootURI");
        }
        VFSContextFactoryLocator.init();
        String scheme = rootURI.getScheme();
        return factoryByProtocol.get(scheme);
    }

    private static synchronized void init() {
        String defaultFactoryNames;
        if (initialized) {
            return;
        }
        ClassLoader loader = AccessController.doPrivileged(new GetContextClassLoader());
        Enumeration<URL> urls = AccessController.doPrivileged(new EnumerateServices());
        if (urls != null) {
            while (urls.hasMoreElements()) {
                VFSContextFactory[] factories;
                URL url = urls.nextElement();
                for (VFSContextFactory factory : factories = VFSContextFactoryLocator.loadFactories(url, loader)) {
                    try {
                        VFSContextFactoryLocator.registerFactory(factory);
                    }
                    catch (Exception e) {
                        log.warn("Error registering factory from " + url, e);
                    }
                }
            }
        }
        if ((defaultFactoryNames = AccessController.doPrivileged(new GetDefaultFactories())) != null) {
            StringTokenizer tokenizer = new StringTokenizer(defaultFactoryNames, ",");
            while (tokenizer.hasMoreTokens()) {
                String factoryName = tokenizer.nextToken();
                VFSContextFactory factory = VFSContextFactoryLocator.createVFSContextFactory(loader, factoryName, " from system property.");
                if (factory == null) continue;
                VFSContextFactoryLocator.registerFactory(factory);
            }
        }
        if (!factoryByProtocol.containsKey("file")) {
            VFSContextFactoryLocator.registerFactory(new FileSystemContextFactory());
        }
        if (!factoryByProtocol.containsKey("jar")) {
            VFSContextFactoryLocator.registerFactory(new JarContextFactory());
        }
        initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VFSContextFactory[] loadFactories(URL serviceURL, ClassLoader loader) {
        ArrayList<VFSContextFactory> temp = new ArrayList<VFSContextFactory>();
        try {
            InputStream is = serviceURL.openStream();
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("#")) continue;
                    String[] classes = line.split("\\s+|#.*");
                    for (int n = 0; n < classes.length; ++n) {
                        VFSContextFactory factory;
                        String name = classes[n];
                        if (name.length() == 0 || (factory = VFSContextFactoryLocator.createVFSContextFactory(loader, name, " defined in " + serviceURL)) == null) continue;
                        temp.add(factory);
                    }
                }
            }
            finally {
                is.close();
            }
        }
        catch (Exception e) {
            log.warn("Error parsing " + serviceURL, e);
        }
        VFSContextFactory[] factories = new VFSContextFactory[temp.size()];
        return temp.toArray(factories);
    }

    private static VFSContextFactory createVFSContextFactory(ClassLoader cl, String className, String context) {
        try {
            Class<?> factoryClass = cl.loadClass(className);
            return (VFSContextFactory)factoryClass.newInstance();
        }
        catch (Exception e) {
            log.warn("Error creating VFSContextFactory " + className + " " + context, e);
            return null;
        }
    }

    static {
        String pkgs = System.getProperty("java.protocol.handler.pkgs");
        if (pkgs == null || pkgs.trim().length() == 0) {
            pkgs = "org.jboss.virtual.protocol";
            System.setProperty("java.protocol.handler.pkgs", pkgs);
        } else if (!pkgs.contains("org.jboss.virtual.protocol")) {
            pkgs = pkgs + "|org.jboss.virtual.protocol";
            System.setProperty("java.protocol.handler.pkgs", pkgs);
        }
        ArchiveBrowser.factoryFinder.put("vfsfile", new VfsArchiveBrowserFactory());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnumerateServices
    implements PrivilegedAction<Enumeration<URL>> {
        private EnumerateServices() {
        }

        @Override
        public Enumeration<URL> run() {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                return cl.getResources(SERVICES_PATH);
            }
            catch (IOException e) {
                log.warn("Error retrieving " + SERVICES_PATH, e);
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetDefaultFactories
    implements PrivilegedAction<String> {
        private GetDefaultFactories() {
        }

        @Override
        public String run() {
            return System.getProperty(DEFAULT_FACTORY_PROPERTY);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetContextClassLoader
    implements PrivilegedAction<ClassLoader> {
        private GetContextClassLoader() {
        }

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

