/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.binding;

import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import org.jboss.logging.Logger;
import org.jboss.ws.core.jaxrpc.binding.BindingException;
import org.jboss.ws.core.jaxrpc.binding.BufferedStreamResult;
import org.jboss.ws.core.jaxrpc.binding.SerializationContext;
import org.jboss.ws.core.jaxrpc.binding.SerializerSupport;
import org.jboss.ws.core.utils.JavaUtils;
import org.jboss.ws.extensions.xop.XOPContext;
import org.jboss.ws.extensions.xop.jaxrpc.XOPMarshallerImpl;
import org.jboss.xb.binding.NamespaceRegistry;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.jboss.xb.binding.sunday.xop.XOPObject;
import org.w3c.dom.NamedNodeMap;

public class Base64Serializer
extends SerializerSupport {
    private static final Logger log = Logger.getLogger(Base64Serializer.class);

    public Result serialize(QName xmlName, QName xmlType, Object value, SerializationContext serContext, NamedNodeMap attributes) throws BindingException {
        if (log.isDebugEnabled()) {
            log.debug("serialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]");
        }
        String xmlFragment = null;
        NamespaceRegistry nsRegistry = serContext.getNamespaceRegistry();
        if (XOPContext.isXOPMessage()) {
            XOPMarshallerImpl xopMarshaller = new XOPMarshallerImpl();
            XOPObject xopObject = new XOPObject(value);
            xopObject.setContentType("application/octet-stream");
            String cid = xopMarshaller.addMtomAttachment(xopObject, xmlName.getNamespaceURI(), xmlType.getLocalPart());
            String xopInclude = "<xop:Include xmlns:xop='http://www.w3.org/2004/08/xop/include' href='" + cid + "'/>";
            xmlFragment = this.wrapValueStr(xmlName, xopInclude, nsRegistry, null, attributes, false);
        } else {
            value = JavaUtils.getPrimitiveValueArray(value);
            String valueStr = SimpleTypeBindings.marshalBase64((byte[])value);
            xmlFragment = this.wrapValueStr(xmlName, valueStr, nsRegistry, null, attributes, true);
        }
        return new BufferedStreamResult(xmlFragment);
    }
}

