/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.addressing.jaxrpc;

import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.addressing.AddressingBuilder;
import javax.xml.ws.addressing.soap.SOAPAddressingBuilder;
import javax.xml.ws.addressing.soap.SOAPAddressingProperties;
import org.jboss.logging.Logger;
import org.jboss.ws.core.jaxrpc.handler.SOAPMessageContextJAXRPC;
import org.jboss.ws.extensions.addressing.AddressingConstantsImpl;
import org.jboss.ws.extensions.addressing.metadata.AddressingOpMetaExt;
import org.jboss.ws.metadata.umdm.OperationMetaData;

public class WSAddressingServerHandler
extends GenericHandler {
    private static Logger log = Logger.getLogger(WSAddressingServerHandler.class);
    private boolean validate = true;
    private static AddressingBuilder ADDR_BUILDER;
    private static AddressingConstantsImpl ADDR_CONSTANTS;

    public QName[] getHeaders() {
        return new QName[0];
    }

    public void init(HandlerInfo handlerInfo) {
        super.init(handlerInfo);
        String strValidate = (String)handlerInfo.getHandlerConfig().get("validate");
        this.validate = "true".equals(strValidate);
    }

    public boolean handleRequest(MessageContext msgContext) {
        if (log.isDebugEnabled()) {
            log.debug("handleRequest");
        }
        SOAPAddressingProperties addrProps = (SOAPAddressingProperties)ADDR_BUILDER.newAddressingProperties();
        SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
        addrProps.readHeaders(soapMessage);
        msgContext.setProperty("javax.xml.ws.addressing.context.inbound", addrProps);
        if (this.validate) {
            this.validateRequest(addrProps);
        }
        return true;
    }

    public boolean handleResponse(MessageContext msgContext) {
        if (log.isDebugEnabled()) {
            log.debug("handleResponse");
        }
        this.handleResponseOrFault(msgContext, false);
        return true;
    }

    public boolean handleFault(MessageContext msgContext) {
        if (log.isDebugEnabled()) {
            log.debug("handleFault");
        }
        this.handleResponseOrFault(msgContext, true);
        return true;
    }

    private void handleResponseOrFault(MessageContext msgContext, boolean isFault) {
        SOAPAddressingBuilder builder = (SOAPAddressingBuilder)SOAPAddressingBuilder.getAddressingBuilder();
        SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
        SOAPAddressingProperties inProps = (SOAPAddressingProperties)msgContext.getProperty("javax.xml.ws.addressing.context.inbound");
        SOAPAddressingProperties outProps = (SOAPAddressingProperties)msgContext.getProperty("javax.xml.ws.addressing.context.outbound");
        if (outProps == null) {
            outProps = (SOAPAddressingProperties)builder.newAddressingProperties();
            msgContext.setProperty("javax.xml.ws.addressing.context.outbound", outProps);
        }
        outProps.initializeAsReply(inProps, isFault);
        try {
            OperationMetaData opMetaData = ((SOAPMessageContextJAXRPC)msgContext).getOperationMetaData();
            if (!isFault && !opMetaData.isOneWay()) {
                AddressingOpMetaExt addrExt = (AddressingOpMetaExt)opMetaData.getExtension(ADDR_CONSTANTS.getNamespaceURI());
                if (addrExt != null) {
                    outProps.setAction(ADDR_BUILDER.newURI(addrExt.getOutboundAction()));
                } else {
                    log.warn("Unable to resolve replyAction for " + opMetaData.getQName());
                }
            } else if (isFault) {
                outProps.setAction(ADDR_BUILDER.newURI(ADDR_CONSTANTS.getDefaultFaultAction()));
            }
        }
        catch (URISyntaxException e) {
            log.error("Error setting response action", e);
        }
        outProps.writeHeaders(soapMessage);
    }

    private void validateRequest(SOAPAddressingProperties addrProps) {
        if (addrProps.getReplyTo() != null && addrProps.getMessageID() == null) {
            throw new IllegalArgumentException("wsa:MessageId is required when wsa:ReplyTo is supplied");
        }
    }

    static {
        ADDR_CONSTANTS = new AddressingConstantsImpl();
        ADDR_BUILDER = AddressingBuilder.getAddressingBuilder();
    }
}

