/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security.element;

import org.jboss.ws.extensions.security.WSSecurityException;
import org.jboss.ws.extensions.security.element.BinarySecurityToken;
import org.jboss.ws.extensions.security.element.Reference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DirectReference
extends Reference {
    private Document doc;
    private String uri;
    private String valueType;
    private Element cachedElement;

    public DirectReference(Document doc) {
        this.doc = doc;
    }

    public DirectReference(Document doc, BinarySecurityToken token) {
        this.doc = doc;
        this.referenceToken(token);
    }

    public DirectReference(Element element) throws WSSecurityException {
        this.doc = element.getOwnerDocument();
        if (!"Reference".equals(element.getLocalName())) {
            throw new WSSecurityException("Invalid message, invalid local name on a DirectReference");
        }
        String uri = element.getAttribute("URI");
        if (uri == null || uri.length() == 0) {
            throw new WSSecurityException("Inavliad message, Reference element is missing a URI");
        }
        this.setUri(uri);
        String valueType = element.getAttribute("ValueType");
        if (valueType == null || valueType.length() == 0) {
            throw new WSSecurityException("Inavliad message, Reference element is missing a ValueType");
        }
        this.setValueType(valueType);
    }

    public String getUri() {
        return this.uri;
    }

    public void referenceToken(BinarySecurityToken token) {
        this.setUri("#" + token.getId());
        this.setValueType(token.getValueType());
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public Element getElement() {
        if (this.cachedElement != null) {
            return this.cachedElement;
        }
        Element element = this.doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Reference");
        element.setAttribute("ValueType", this.getValueType());
        element.setAttribute("URI", this.getUri());
        this.cachedElement = element;
        return this.cachedElement;
    }
}

