/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.introspection;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.introspection.FieldInfo;

public class ClassInfo {
    private static final Object FIELD_INFO_NA = new Object();
    private final Class type;
    private Map fields = new ConcurrentHashMap();
    private boolean introspected;

    public ClassInfo(Class cls) {
        this.type = cls;
    }

    public Class getType() {
        return this.type;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FieldInfo getFieldInfo(String name, boolean required) {
        Object o = this.fields.get(name);
        if (o == null) {
            FieldInfo fieldInfo = FieldInfo.getFieldInfo(this, name);
            if (fieldInfo != null) return fieldInfo;
            this.fields.put(name, FIELD_INFO_NA);
        } else if (o != FIELD_INFO_NA) {
            return (FieldInfo)o;
        }
        if (!required) return null;
        throw new JBossXBRuntimeException("Failed to find read method or field for property '" + name + "' in " + this.type);
    }

    void addFieldInfo(FieldInfo fieldInfo) {
        this.fields.put(fieldInfo.getName(), fieldInfo);
    }

    FieldInfo introspect(String name) {
        if (this.introspected) {
            return null;
        }
        try {
            BeanInfo info = Introspector.getBeanInfo(this.type);
            PropertyDescriptor[] props = info.getPropertyDescriptors();
            if (props != null) {
                int i = 0;
                while (i < props.length) {
                    PropertyDescriptor prop = props[i];
                    Method readMethod = prop.getReadMethod();
                    if (readMethod != null) {
                        Method writeMethod = prop.getWriteMethod();
                        FieldInfo fieldInfo = new FieldInfo(this.type, prop.getName(), readMethod, writeMethod);
                        this.addFieldInfo(fieldInfo);
                    }
                    ++i;
                }
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        this.introspected = true;
        return this.getFieldInfo(name, false);
    }
}

