package ch6Tests;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;

import junit.framework.TestCase;

import org.hibernate.ejb.Ejb3Configuration;

import ch6.BankAccount;
import ch6.Coach;
import ch6.Player;
import ch6.School;
import ch6.Team;


/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision: 61136 $
 */
public class Ch6TestCase extends TestCase
{
	public Ch6TestCase()
	{
		super("Ch6TestCase");
	}

	public void testConcurrency() throws Exception
	{
		EntityManagerFactory emf = Persistence.createEntityManagerFactory("eyrollesEntityManager");
		EntityManager em1 = emf.createEntityManager();
		EntityManager em2 = emf.createEntityManager();
		
		EntityTransaction tx1 = em1.getTransaction();
		EntityTransaction tx2 = em2.getTransaction();
		
		tx1.begin();
		Team team = new Team("cascade test team");
		Player player = new Player ("cascade player test");
		School school = new School ("cascade school test");
		Coach coach= new Coach ("cascade test coach");
		player.setSchool(school);
		team.getPlayers().add(player);
		team.setCoach(coach);
		em1.persist(team);
		tx1.commit();
	
		tx1.begin();
		tx2.begin();		
		Team t1 = em1.find(Team.class, new Integer(1));
		t1.setName("new name1");
		Team t2 = em2.find(Team.class, new Integer(1));
		t2.setName("new name2");
		tx2.commit();
		tx1.commit();
		em1.close();
		em2.close();
	
	}

	public void testConcurrency2() throws Exception
	{
		EntityManagerFactory emf = Persistence.createEntityManagerFactory("eyrollesEntityManager");
		EntityManager em1 = emf.createEntityManager();
		EntityManager em2 = emf.createEntityManager();
		
		EntityTransaction tx1 = em1.getTransaction();
		EntityTransaction tx2 = em2.getTransaction();
		
		tx1.begin();
		Team team = new Team("cascade test team");
		Player player = new Player ("cascade player test");
		School school = new School ("cascade school test");
		Coach coach= new Coach ("cascade test coach");
		player.setSchool(school);
		team.getPlayers().add(player);
		team.setCoach(coach);
		em1.persist(team);
		tx1.commit();
		
	
		tx1.begin();
		tx2.begin();		
		Team t1 = em1.find(Team.class, new Integer(1));
		Team t2 = em2.find(Team.class, new Integer(1));
		em1.remove(t1);
		t2.setName("new name2");
		tx1.commit();
		tx2.commit();
		
		em1.close();
		em2.close();
	
	}

	public void testConcurrency3() throws Exception
	{
		EntityManagerFactory emf = Persistence.createEntityManagerFactory("eyrollesEntityManager");
		EntityManager em = emf.createEntityManager();
		
		EntityTransaction tx = em.getTransaction();
		
		tx.begin();
		BankAccount ba = new BankAccount();
		ba.setData1("data1A");
		ba.setData2("data2A");
		ba.setData3("data3A");
		em.persist(ba);
		tx.commit();
	
		tx.begin();
		BankAccount bankAccount = em.find(BankAccount.class, new Long(1));
		bankAccount.setData2("data2B");
		tx.commit();
		
		em.close();
		
	}
}
