package ch7Tests;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;

import util.JavaPersistenceUtil;

import junit.framework.TestCase;
import ch6.Coach;
import ch6.Player;
import ch6.School;
import ch6.Team;


/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision: 61136 $
 */
public class Ch7TestCase extends TestCase
{
	public Ch7TestCase()
	{
		super("Ch7TestCase");
	}

	public void test() throws Exception
	{
		EntityManager em = null;

		EntityTransaction tx = null;
		try{
			em =  JavaPersistenceUtil.getEmf().createEntityManager();
			tx =  em.getTransaction();
			tx.begin();
			Team team = new Team("cascade test team");
			Player player = new Player ("cascade player test");
			School school = new School ("cascade school test");
			Coach coach= new Coach ("cascade test coach");
			player.setSchool(school);
			team.getPlayers().add(player);
			team.setCoach(coach);
			em.persist(team);
			tx.commit();
		} catch (RuntimeException ex) {
			try {
				tx.rollback();
			} catch (RuntimeException rbEx) {
			}
			throw ex;
		} finally {
			em.close();
		}
	}
}
