

/* hints */

SELECT  FROM nom_table [[AS] alias]
[  USE {INDEX|KEY}
      [{FOR {JOIN|ORDER BY|GROUP BY}] ([index1 [, index2]])
 | IGNORE {INDEX|KEY}
      [{FOR {JOIN|ORDER BY|GROUP BY}] ([index1 [, index2]])
 | FORCE {INDEX|KEY}
      [{FOR {JOIN|ORDER BY|GROUP BY}] ([index1 [, index2]])
,]

EXPLAIN
SELECT  nom, tel
  FROM  Adherent IGNORE INDEX (PRIMARY)
  WHERE adhid = 20045;

EXPLAIN
SELECT  nom, tel
  FROM  Adherent USE INDEX()
  WHERE adhid = 20045;

EXPLAIN
SELECT  nom, tel
  FROM  Adherent FORCE INDEX (PRIMARY)
  WHERE adhid = 20045;

CREATE INDEX idx_tel_btree
  USING BTREE
  ON Adherent (tel);

CREATE INDEX idx_tel3_btree
  USING BTREE
  ON Adherent (tel(3));

EXPLAIN
SELECT  adhid, nom, tel
  FROM  Adherent
  WHERE tel LIKE '05-%';

EXPLAIN
SELECT  adhid, nom, tel
  FROM  Adherent USE INDEX (idx_tel3_btree)
  WHERE tel LIKE '05-%';

EXPLAIN
SELECT  adhid, nom, tel
  FROM  Adherent USE INDEX ()
  WHERE tel LIKE '05-%';


ALTER TABLE Adherent DROP INDEX idx_tel_btree;

ALTER TABLE Adherent DROP INDEX idx_tel3_btree;


-- hint sauce Oracle


SELECT /*+ NO_BNL() BKA(a) */ a.nom, s.splibelle 
FROM adherent a 
INNER JOIN pratique p ON p.adhid = a.adhid
INNER JOIN sport s ON s.spid = p.spid
WHERE s.splibelle IN ('Golf','Volley', 'Equitation');

SELECT a.nom, s.splibelle 
FROM adherent a 
INNER JOIN pratique p ON p.adhid = a.adhid
INNER JOIN sport s ON s.spid = p.spid
WHERE s.splibelle IN ('Golf','Volley', 'Equitation');

-- matrialisation

-- 3,4 sec

SELECT DISTINCT a.nom, a.tel
FROM adherent a
WHERE
adhid IN
 (SELECT p.adhid FROM pratique p WHERE p.spid > 4 AND p.spid < 120
        AND p.spid IN (SELECT s.spid FROM sport s 
                       WHERE s.splibelle IN ('Golf','Volley', 'Equitation')));


-- pareil ... ?

SELECT DISTINCT a.nom, a.tel
FROM adherent a
WHERE
adhid IN
 (SELECT /*+ SUBQUERY(MATERIALIZATION) */
        p.adhid FROM pratique p 
        WHERE p.spid > 4 
        AND p.spid < 120
        AND p.spid IN (SELECT s.spid FROM sport s 
                       WHERE s.splibelle IN ('Golf','Volley', 'Equitation')));

/*
SELECT id, a IN (SELECT /*+ SUBQUERY(MATERIALIZATION) */ a FROM t1) FROM t2;
SELECT * FROM t2 WHERE t2.a IN (SELECT /*+ SUBQUERY(INTOEXISTS) */ a FROM t1);

INTOEXISTS ?

*/

EXPLAIN
SELECT a.civilite, a.prenom, a.nom, a.tel 
FROM Adherent a
   WHERE NOT EXISTS
    (SELECT spid FROM Pratique 
      WHERE adhid IN 
           (SELECT adhid FROM Adherent
                  WHERE nom = 'LARRAZET'
                  AND   prenom = 'CELINE')
      AND spid NOT IN
      (SELECT spid FROM Pratique WHERE adhid = a.adhid)
     )
    AND NOT EXISTS
       (SELECT spid FROM Pratique WHERE adhid = a.adhid
           AND spid NOT IN
           (SELECT spid FROM Pratique WHERE adhid IN 
             (SELECT adhid FROM Adherent
                     WHERE nom = 'LARRAZET'
                     AND   prenom = 'CELINE')))
    AND a.nom <> 'LARRAZET' AND a.prenom <> 'CELINE';


EXPLAIN
SELECT a.civilite, a.prenom, a.nom, a.tel 
FROM Adherent a
   WHERE NOT EXISTS
    (SELECT spid FROM Pratique 
      WHERE adhid IN 
           (SELECT /*+ SUBQUERY(MATERIALIZATION) */adhid FROM Adherent
                  WHERE nom = 'LARRAZET'
                  AND   prenom = 'CELINE')
      AND spid NOT IN
      (SELECT spid FROM Pratique WHERE adhid = a.adhid)
     )
    AND NOT EXISTS
       (SELECT spid FROM Pratique WHERE adhid = a.adhid
           AND spid NOT IN
           (SELECT spid FROM Pratique WHERE adhid IN 
             (SELECT /*+ SUBQUERY(MATERIALIZATION) */ adhid FROM Adherent
                     WHERE nom = 'LARRAZET'
                     AND   prenom = 'CELINE')))
    AND a.nom <> 'LARRAZET' AND a.prenom <> 'CELINE';

