
/* voir les noms des contraintes cote fils */

CREATE TABLE Compagnie
(comp CHAR(4), nrue INTEGER(3),
 rue CHAR(20), ville CHAR(15), nomComp CHAR(15),
 CONSTRAINT pk_Compagnie PRIMARY KEY(comp));

CREATE TABLE Pilote
(brevet CHAR(6), nom CHAR(15),
 nbHVol DECIMAL(7,2), compa CHAR(4),
 CONSTRAINT pk_Pilote PRIMARY KEY(brevet),
 CONSTRAINT fk_Pil_compa_Comp FOREIGN KEY (compa) 
   REFERENCES Compagnie(comp));

SHOW CREATE TABLE Pilote;
SHOW CREATE TABLE Compagnie;

DROP TABLE Pilote;
DROP TABLE Compagnie;

/* Ajout de contraintes */

CREATE TABLE Compagnie
(comp CHAR(4), nrue INTEGER(3),
 rue CHAR(20), ville CHAR(15), nomComp CHAR(15),
 CONSTRAINT pk_Compagnie PRIMARY KEY(comp));

CREATE TABLE Avion
 (immat CHAR(6), typeAvion CHAR(15), nbhVol DECIMAL(10,2), proprio CHAR(4),
 CONSTRAINT pk_Avion PRIMARY KEY(immat));

CREATE TABLE Affreter
 (compAff CHAR(4), immat CHAR(6), dateAff DATE, nbPax INTEGER(3));


INSERT INTO Compagnie
   VALUES ('AF', 10, 'Gambetta', 'Paris', 'Air France');
INSERT INTO Compagnie
   VALUES ('SING', 7, 'Camparols', 'Singapour', 'Singapore AL');

INSERT INTO Avion VALUES ('F-WTSS', 'Concorde', 6570, 'SING');
INSERT INTO Avion VALUES ('F-WTSS', 'Concorde', 6570, 'SING');
INSERT INTO Avion VALUES ('F-GAFU', 'A320', 3500, 'AF');
INSERT INTO Avion VALUES ('F-GLFS', 'TB-20', 2000, 'SING');

INSERT INTO Affreter VALUES('AF',  'F-WTSS','2003-05-13',82);
INSERT INTO Affreter VALUES('SING','F-GAFU','2003-02-05',155);
INSERT INTO Affreter VALUES('AF',  'F-WTSS','2003-05-15',85);

/* not null */

ALTER TABLE Avion MODIFY proprio CHAR(4) NOT NULL;

/* unique */

ALTER TABLE Compagnie ADD CONSTRAINT un_nomC UNIQUE (nomComp);

/* fk */

ALTER TABLE Avion ADD INDEX (proprio);
ALTER TABLE Avion ADD
 CONSTRAINT fk_Avion_comp_Compag FOREIGN KEY(proprio) 
            REFERENCES Compagnie(comp);


/* pk */
	
ALTER TABLE Affreter
	ADD (
	CONSTRAINT pk_Affreter PRIMARY KEY (compAff, immat, dateAff),
	CONSTRAINT fk_Aff_na_Avion FOREIGN KEY(immat) REFERENCES Avion(immat),
	CONSTRAINT fk_Aff_comp_Compag FOREIGN KEY(compAff) REFERENCES Compagnie(comp));

SELECT * FROM Compagnie;
SELECT * FROM Avion;
SELECT * FROM Affreter;

/* msg erreurs */


/* unique */

ALTER TABLE Compagnie DROP INDEX un_nomC;
INSERT INTO Compagnie
   VALUES ('AF2', 10, 'Gambetta', 'Paris', 'Air France');
SELECT * FROM Compagnie;

ALTER TABLE Compagnie ADD CONSTRAINT un_nomC UNIQUE (nomComp);
DELETE FROM Compagnie WHERE comp='AF2';
ALTER TABLE Compagnie ADD CONSTRAINT un_nomC UNIQUE (nomComp);

/* not null */

ALTER TABLE Avion MODIFY proprio CHAR(4) NULL;
INSERT INTO Avion VALUES ('F-GZPL', 'Aquila', 500, NULL);
SELECT * FROM Avion;

ALTER TABLE Avion MODIFY proprio CHAR(4) NOT NULL;
DELETE FROM Avion WHERE proprio IS NULL;
ALTER TABLE Avion MODIFY proprio CHAR(4) NOT NULL;

/* fk/pk */

ALTER TABLE Avion DROP FOREIGN KEY fk_Avion_comp_Compag;

INSERT INTO Avion VALUES ('F-GZPL', 'Aquila', 500, 'Bug');
SELECT * FROM Avion;

ALTER TABLE Avion ADD
 CONSTRAINT fk_Avion_comp_Compag FOREIGN KEY(proprio) 
            REFERENCES Compagnie(comp);
DELETE FROM Avion WHERE proprio NOT IN (SELECT comp FROM Compagnie);
ALTER TABLE Avion ADD
 CONSTRAINT fk_Avion_comp_Compag FOREIGN KEY(proprio) 
            REFERENCES Compagnie(comp);

/* pk */

ALTER TABLE Affreter DROP FOREIGN KEY fk_Aff_na_Avion;
ALTER TABLE Affreter DROP FOREIGN KEY fk_Aff_comp_Compag;
ALTER TABLE Affreter DROP PRIMARY KEY;

INSERT INTO Affreter VALUES('AF','F-WTSS','2003-05-15',85);
SELECT * FROM Affreter;

ALTER TABLE Affreter
  ADD CONSTRAINT pk_Affreter PRIMARY KEY (compAff, immat, dateAff);

DROP TABLE Affreter;
DROP TABLE Avion;
DROP TABLE Compagnie;

/* Dsactivation de contraintes */

CREATE TABLE Compagnie
(comp CHAR(4), nrue INTEGER(3),
 rue CHAR(20), ville CHAR(15), nomComp CHAR(15),
 CONSTRAINT pk_Compagnie PRIMARY KEY(comp));
CREATE TABLE Avion
 (immat CHAR(6), typeAvion CHAR(15), nbhVol DECIMAL(10,2), proprio CHAR(4),
 CONSTRAINT pk_Avion PRIMARY KEY(immat));
CREATE TABLE Affreter
 (compAff CHAR(4), immat CHAR(6), dateAff DATE, nbPax INTEGER(3));

ALTER TABLE Compagnie ADD CONSTRAINT un_nomC UNIQUE (nomComp);
ALTER TABLE Avion ADD INDEX (proprio);
ALTER TABLE Avion ADD
 CONSTRAINT fk_Avion_comp_Compag FOREIGN KEY(proprio) REFERENCES Compagnie(comp);
ALTER TABLE Avion MODIFY proprio CHAR(4) NOT NULL;

ALTER TABLE Affreter
	ADD (
	CONSTRAINT pk_Affreter PRIMARY KEY (compAff, immat, dateAff),
	CONSTRAINT fk_Aff_na_Avion FOREIGN KEY(immat) REFERENCES Avion(immat),
	CONSTRAINT fk_Aff_comp_Compag FOREIGN KEY(compAff) REFERENCES Compagnie(comp));

INSERT INTO Compagnie
	VALUES ('AF', 10, 'Gambetta', 'Paris', 'Air France');
INSERT INTO Compagnie
   VALUES ('SING', 7, 'Camparols', 'Singapour', 'Singapore AL');
INSERT INTO Avion VALUES ('F-WTSS', 'Concorde', 6570, 'SING');
INSERT INTO Affreter VALUES('AF','F-WTSS','2003-05-13',85);

SELECT * FROM Compagnie;
SELECT * FROM Avion;
SELECT * FROM Affreter;

/* ALTER TABLE Avion DISABLE KEYS; */
/* ne dsactive rien  */

INSERT INTO Avion VALUES ('Bidon3', 'TB-20', 2000, NULL);
INSERT INTO Avion VALUES ('Bidon2', 'DR400', 400, 'GTR');
INSERT INTO Avion VALUES ('F-WTSS', 'Concorde', 6570, 'SING');


SET FOREIGN_KEY_CHECKS =0;

INSERT INTO Compagnie VALUES ('GTR', 1, 'Brassens', 'Blagnac', 'Air France');

INSERT INTO Avion VALUES ('Bidon1', 'TB-20', 2000, NULL);
INSERT INTO Avion VALUES ('F-GLFS', 'TB-22', 500, 'Toto');
INSERT INTO Avion VALUES ('F-GLFS', 'TB-21', 1000, 'AF');

INSERT INTO Affreter VALUES ('AF', 'Toto', '2005-05-13', 0);
INSERT INTO Affreter VALUES ('GTI', 'F-WTSS', '2005-11-07', 10);
INSERT INTO Affreter VALUES ('GTI', 'Toto', '2005-11-07', 40);

SELECT * FROM Compagnie;
SELECT * FROM Avion;
SELECT * FROM Affreter;

/* Ractivation de contraintes */

SET FOREIGN_KEY_CHECKS=1;

/* la base ne vrifie que les nouvelles mises  jour */

INSERT INTO Compagnie VALUES ('GTR', 1, 'Brassens', 'Blagnac', 'Air France');

INSERT INTO Avion VALUES ('Bidon4', 'TB-20', 2000, NULL);
INSERT INTO Avion VALUES ('F-GLAO', 'TB-22', 500, 'Toto');
INSERT INTO Avion VALUES ('F-GLFS', 'TB-21', 1000, 'AF');

INSERT INTO Affreter VALUES ('AF', 'Toto', '2005-05-13', 0);

/* Remise en tat de la base */

SELECT immat, proprio FROM Avion
 WHERE proprio NOT IN (SELECT comp FROM Compagnie);

SELECT compAff,immat,dateAff FROM Affreter
 WHERE compAff NOT IN (SELECT comp FROM Compagnie)
 OR    immat   NOT IN (SELECT immat FROM Avion);

DROP TABLE Affreter;
DROP TABLE Avion;
DROP TABLE Compagnie;