
prompt (\u@\h) [\d] mysql>\_

DROP DATABASE bd_uuid;
CREATE DATABASE bd_uuid;

CREATE TABLE bd_uuid.vols
 (id_vol SMALLINT AUTO_INCREMENT, 
  uuid_varchar VARCHAR(36), uuid_bin BINARY(16), 
  num_vol VARCHAR(6), date_vol DATE,
  CONSTRAINT pk_vols PRIMARY KEY(id_vol))
  DEFAULT CHARACTER SET utf8;

 -- V8  UUID_TO_BIN(string_uuid), UUID_TO_BIN(string_uuid, swap_flag)

INSERT INTO bd_uuid.vols(uuid_varchar, uuid_bin, num_vol, date_vol)
		VALUES (UUID(), UUID_TO_BIN(UUID()), 'AF6143', SYSDATE());
INSERT INTO bd_uuid.vols(uuid_varchar, uuid_bin, num_vol, date_vol)
		VALUES (UUID(), UUID_TO_BIN(UUID()), 'AF6147', SYSDATE());
		
SELECT id_vol,uuid_varchar,num_vol,date_vol
	FROM bd_uuid.vols;

-- V8 BIN_TO_UUID(binary_uuid), BIN_TO_UUID(binary_uuid, swap_flag)

SELECT id_vol, BIN_TO_UUID(uuid_bin), num_vol, date_vol 
FROM   bd_uuid.vols;

-- 2eme forme

--SELECT id_vol, BIN_TO_UUID(uuid_bin,1), num_vol, date_vol 
--FROM   bd_uuid.vols;

INSERT INTO bd_uuid.vols(uuid_bin, num_vol, date_vol)
		VALUES (UUID_TO_BIN(UUID(),1), 'AF6143', DATE_ADD(SYSDATE(),INTERVAL 1 DAY));
INSERT INTO bd_uuid.vols(uuid_bin, num_vol, date_vol)
		VALUES (UUID_TO_BIN(UUID(),1), 'AF6147', DATE_ADD(SYSDATE(),INTERVAL 1 DAY));

SELECT id_vol, BIN_TO_UUID(uuid_bin), num_vol, date_vol 
FROM   bd_uuid.vols;

CREATE UNIQUE INDEX idx_vols_uuid ON bd_uuid.vols(uuid_bin);

-- IS_UUID(string_uuid)

SELECT id_vol, IS_UUID(uuid_varchar),  
               IS_UUID(BIN_TO_UUID(uuid_bin)), 
			   IS_UUID(num_vol)
FROM   bd_uuid.vols;


DROP DATABASE bd_uuid;