/* Collations */
  
SHOW CHARACTER SET ;

DROP TABLE bdutil.Compagnie;

CREATE TABLE bdutil.Compagnie
 (comp    CHAR(4), nrue INTEGER(3), rue VARCHAR(20),
  ville   VARCHAR(15) CHARACTER SET latin1 COLLATE latin1_general_ci,
  nomComp VARCHAR(15) CHARACTER SET latin1 COLLATE latin1_general_cs
 ) DEFAULT CHARACTER SET utf8 COLLATE utf8_bin;


-- latin1_bin  (ABOYZaboyzoe)
-- latin1_general_cs (AaBbOoYyZzoe)
-- latin1_general_ci (AaBbOoYyZzoe)

SHOW VARIABLES LIKE 'character_set%';
SHOW VARIABLES LIKE 'collation%';


--For Schemas:

SELECT default_character_set_name 
FROM information_schema.SCHEMATA 
WHERE schema_name = "bdutil";

--For Tables:

SELECT CCSA.character_set_name 
FROM information_schema.`TABLES` T,
       information_schema.`COLLATION_CHARACTER_SET_APPLICABILITY` CCSA
WHERE CCSA.collation_name = T.table_collation
  AND T.table_schema = "bdutil"
  AND T.table_name = "Compagnie";

--For Columns:

SELECT character_set_name , column_name
FROM information_schema.`COLUMNS` 
WHERE table_schema = "bdutil"
  AND table_name = "Compagnie";
  
/*
SET NAMES 'charset_name' [COLLATE 'collation_name']

CREATE DATABASE mydb
  DEFAULT CHARACTER SET utf8
  DEFAULT COLLATE utf8_general_ci;
  
*/
 