/* Collations */
  
DROP TABLE bdutil.Compagnie;

CREATE TABLE bdutil.Compagnie
 (comp    VARCHAR(4), nrue INTEGER(3), rue VARCHAR(20),
  ville   VARCHAR(15) CHARACTER SET latin1 COLLATE latin1_general_ci,
  nomComp VARCHAR(15) CHARACTER SET latin1 COLLATE latin1_general_cs
 ) DEFAULT CHARACTER SET latin1 COLLATE latin1_bin;

-- latin1_bin  (ABOYZaboyzoe)
-- latin1_general_cs (AaBbOoYyZzoe)
-- latin1_general_ci (AaBbOoYyZzoe)

SHOW FULL COLUMNS FROM bdutil.Compagnie;
SHOW VARIABLES LIKE 'character_set%';
SHOW VARIABLES LIKE 'collation%';

--For Schemas:

desc INFORMATION_SCHEMA.SCHEMATA 

SELECT DEFAULT_CHARACTER_SET_NAME,
       DEFAULT_COLLATION_NAME
FROM   INFORMATION_SCHEMA.SCHEMATA 
WHERE  SCHEMA_NAME = "bdutil";

--For Tables:

SELECT c.CHARACTER_SET_NAME , c.COLLATION_NAME
FROM   INFORMATION_SCHEMA.TABLES t,
       INFORMATION_SCHEMA.COLLATION_CHARACTER_SET_APPLICABILITY c
WHERE c.COLLATION_NAME = t.TABLE_COLLATION
  AND t.TABLE_SCHEMA = "bdutil"
  AND t.TABLE_NAME = "compagnie";

--For Columns:

SELECT COLUMN_NAME, CHARACTER_SET_NAME, COLLATION_NAME
FROM   INFORMATION_SCHEMA.COLUMNS
WHERE  TABLE_SCHEMA = "bdutil"
  AND  TABLE_NAME = "compagnie";
  
 