
-- sous root

prompt (\u@\h) [\d] mysql>\_


CREATE DATABASE bd_vols;

CREATE TABLE bd_vols.vols
 (id_vol NUMERIC(5), siege VARCHAR(3), prix DECIMAL(4,2));

CREATE ROLE 'planification', 'operation', 'admin_vols';

GRANT INSERT ON bd_vols.vols TO 'planification';
GRANT SELECT ON bd_vols.vols TO 'planification';

GRANT SELECT         ON bd_vols.vols TO 'operation';
GRANT UPDATE, DELETE ON bd_vols.vols TO 'operation';

GRANT CREATE, DROP   ON bd_vols.* TO 'admin_vols';

GRANT 'admin_vols' TO 'operation' ;

CREATE USER 'jean_brice'@'localhost' IDENTIFIED BY 'jean_brice';
CREATE USER 'sylvain'@'localhost'    IDENTIFIED BY 'sylvain';
CREATE USER 'antoine'@'localhost'    IDENTIFIED BY 'antoine';

GRANT 'planification' TO 'jean_brice'@'localhost', 'sylvain'@'localhost' ;
GRANT 'operation'     TO 'antoine'@'localhost';
GRANT 'admin_vols'    TO 'sylvain'@'localhost' ;

SHOW GRANTS FOR 'sylvain'@'localhost' ;

SHOW GRANTS FOR 'sylvain'@'localhost' USING 'planification', 'admin_vols';

-- sous sylvain

mysql -u sylvain -h localhost -p 

prompt (\u@\h) [\d] mysql>\_

SELECT CURRENT_ROLE();
-- sous root

SET DEFAULT ROLE ALL TO
  'jean_brice'@'localhost' ,
  'sylvain'@'localhost',
  'antoine'@'localhost';
  
-- ajout / supp d'un priv à un rôle a posteriori

GRANT INDEX   ON bd_vols.* TO 'admin_vols';
REVOKE DELETE ON bd_vols.vols FROM 'operation';

-- sous sylvain, on voit ses rôles

mysql -u sylvain -h localhost -p 

prompt (\u@\h) [\d] mysql>\_

SELECT CURRENT_ROLE();

SHOW GRANTS FOR 'sylvain'@'localhost' USING 'planification', 'admin_vols';

-- sous root

DROP ROLE 'admin_vols', 'operation', 'planification' ;

DROP USER 'jean_brice'@'localhost' ;
DROP USER 'sylvain'@'localhost'    ;
DROP USER 'antoine'@'localhost';

DROP DATABASE bd_vols;