/*


SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;
SELECT @@tx_isolation;

SET SESSION tx_isolation='READ-UNCOMMITTED';
SELECT @@tx_isolation;

SET TRANSACTION ISOLATION LEVEL READ COMMITTED;
SELECT @@tx_isolation;

SET SESSION tx_isolation='READ-COMMITTED';
SELECT @@tx_isolation;


SET TRANSACTION ISOLATION LEVEL REPEATABLE READ;
SELECT @@tx_isolation;

SET SESSION tx_isolation='REPEATABLE-READ';
SELECT @@tx_isolation;

SET TRANSACTION ISOLATION LEVEL SERIALIZABLE;
SELECT @@tx_isolation;

SET SESSION tx_isolation='SERIALIZABLE';
SELECT @@tx_isolation;

*/

/* dbut */


delimiter ;

DROP TABLE T_passagers_pax;

CREATE TABLE T_passagers_pax
(vol_num           VARCHAR(8),
 vol_datevol       DATE NOT NULL,
 cli_code          VARCHAR(10) NOT NULL,
 pax_prix          DECIMAL(6,2)) ENGINE = InnoDB;

/* fenetre 1 par dfaut */

INSERT INTO T_passagers_pax
VALUES('AF6140','20121228','Brouard',220.00);


/* fenetre 2 par dfaut */

SELECT * FROM T_passagers_pax;

/* fenetre 1 */

DELETE FROM T_passagers_pax;
SET autocommit=0;
INSERT INTO T_passagers_pax
VALUES('AF6140','20121228','Brouard',220.00);


/* fenetre 2 par dfaut */

SELECT * FROM T_passagers_pax;

/* fenetre 1 */

COMMIT;

/* START TRANSACTION; */


/* fenetre 1 */

DELETE FROM T_passagers_pax;
SET autocommit=0;

START TRANSACTION;
 INSERT INTO T_passagers_pax
        VALUES('AF6140','20121228','Brouard',220.00);
COMMIT;

INSERT INTO T_passagers_pax
        VALUES('AF6140','20121228','Roux',189.00);


/* fenetre 2 par dfaut */

SELECT * FROM T_passagers_pax;


delimiter ;

DROP TABLE T_vols;
DROP TABLE T_passagers_pax;

CREATE TABLE T_vols
(vol_num           VARCHAR(8),
 vol_datevol       DATE NOT NULL,
 vol_h_dep         TIME,
 vol_h_arr         TIME,
 vol_places_libres TINYINT,
 aer_dep           VARCHAR(3) NOT NULL,
 aer_arr           VARCHAR(3) NOT NULL,
 CONSTRAINT  PK_vlh  PRIMARY KEY(vol_num,vol_datevol))
 ENGINE = InnoDB;

CREATE TABLE T_passagers_pax
(vol_num           VARCHAR(8),
 vol_datevol       DATE NOT NULL,
 cli_code          VARCHAR(10) NOT NULL,
 pax_prix          DECIMAL(6,2)) ENGINE = InnoDB;

/*  refaire entre chaque config */

delimiter ;
DELETE FROM T_vols ;
DELETE FROM T_passagers_pax;

INSERT INTO T_vols VALUES('AF6140','20121228','18:15:00','19:45:00',50,'TLS','ORY');
INSERT INTO T_passagers_pax
VALUES('AF6140','20121228','Brouard',220.00);

select * from T_passagers_pax;
select * from T_vols ;


/* READ UNCOMMITTED */

delimiter $

DROP PROCEDURE transaction1$
CREATE PROCEDURE transaction1()
BEGIN
 DECLARE v_reste TINYINT;
 DECLARE v_resa  TINYINT;
 START TRANSACTION;
 SET v_resa  := 7;
 SELECT vol_places_libres INTO v_reste FROM T_vols 
        WHERE vol_num     = 'AF6140'
        AND   vol_datevol ='2012-12-28';
 SELECT CONCAT('disponible : ',v_reste);
 SELECT CONCAT('maj  : ',v_reste - v_resa);
 UPDATE T_vols 
        SET vol_places_libres = v_reste - v_resa
        WHERE vol_num     = 'AF6140'
        AND   vol_datevol ='2012-12-28';
 SELECT SLEEP(10);
ROLLBACK;
END;
$

DROP PROCEDURE transaction2$
CREATE PROCEDURE transaction2()
BEGIN
 DECLARE v_reste TINYINT;
 DECLARE v_resa  TINYINT;
 START TRANSACTION;
 SET v_resa  := 15;
 SELECT vol_places_libres INTO v_reste FROM T_vols 
        WHERE vol_num     = 'AF6140'
        AND   vol_datevol ='2012-12-28';
 SELECT CONCAT('disponible : ',v_reste);
 UPDATE T_vols 
        SET vol_places_libres = v_reste - v_resa
        WHERE vol_num     = 'AF6140'
        AND   vol_datevol ='2012-12-28';
COMMIT;
END;
$

/* fenetre 1 */

delimiter ;
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;
CALL transaction1();

/*  fenetre 2 */

delimiter ;
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;
CALL transaction2();

/* READ COMMITTED */

delimiter $

DROP PROCEDURE transaction1$
CREATE PROCEDURE transaction1()
BEGIN
 DECLARE v_reste TINYINT;
 DECLARE v_resa  TINYINT;
 START TRANSACTION;
  SET     v_resa  := 7;
 UPDATE T_vols 
    SET vol_places_libres = vol_places_libres - v_resa
    WHERE vol_num         = 'AF6140'
    AND   vol_datevol     = '2012-12-28';
COMMIT;
END;
$

DROP PROCEDURE transaction2$
CREATE PROCEDURE transaction2()
BEGIN
 DECLARE v_reste TINYINT;
 START TRANSACTION;
 SELECT vol_places_libres INTO v_reste FROM T_vols 
    WHERE vol_num     = 'AF6140'
    AND   vol_datevol = '2012-12-28';
 SELECT CONCAT('disponible : ',v_reste);
 SELECT SLEEP(10);
 SELECT vol_places_libres INTO v_reste FROM T_vols 
    WHERE vol_num     = 'AF6140'
    AND   vol_datevol = '2012-12-28';
 SELECT CONCAT('disponible : ',v_reste);
ROLLBACK;
END;
$

/* fenetre 1  dmarrer avant*/

delimiter ;
SET TRANSACTION ISOLATION LEVEL READ COMMITTED;
CALL transaction2();

/*  fenetre 2 */

delimiter ;
SET TRANSACTION ISOLATION LEVEL READ COMMITTED;
CALL transaction1();

/* REPEATABLE READ */

/* fenetre 1  dmarrer avant*/

delimiter ;
SET TRANSACTION ISOLATION LEVEL REPEATABLE READ;
CALL transaction2();

/*  fenetre 2 */

delimiter ;
SET TRANSACTION ISOLATION LEVEL REPEATABLE READ;
CALL transaction1();

/* Lectures fantomes * /

delimiter ;

DELETE FROM T_vols ;
DELETE FROM T_passagers_pax;
INSERT INTO T_vols 
  VALUES('AF6140','20121228','18:15:00','19:45:00',50,'TLS','ORY');
INSERT INTO T_vols VALUES
  ('AF6144','20121228','19:55:00','20:45:00',50,'TLS','LYS');
INSERT INTO T_passagers_pax
  VALUES('AF6140','20121228','Brouard',220.00);
INSERT INTO T_passagers_pax
  VALUES('AF6140','20121228','Souquet',192.00);
COMMIT;

delimiter $

DROP PROCEDURE transaction1$
CREATE PROCEDURE transaction1()
BEGIN
 START TRANSACTION;
 INSERT INTO T_passagers_pax
    VALUES('AF6144','20121228','Brouard',220.00);
 COMMIT;
END;
$

DROP PROCEDURE transaction2$
CREATE PROCEDURE transaction2()
BEGIN
 DECLARE v_nb_vol TINYINT;
 START TRANSACTION;
 SELECT COUNT(vol_num) INTO v_nb_vol FROM T_passagers_pax 
   WHERE cli_code='Brouard';
 SELECT CONCAT('nb  : ', v_nb_vol);
 SELECT SLEEP(15);
 SELECT COUNT(pax_prix) INTO v_nb_vol FROM T_passagers_pax
   WHERE cli_code='Brouard';
 SELECT CONCAT('nb  : ', v_nb_vol);
COMMIT;
END;
$

/* fenetre 1  dmarrer avant */

delimiter ;

/* SET TRANSACTION ISOLATION LEVEL READ COMMITTED; */

SET TRANSACTION ISOLATION LEVEL REPEATABLE READ;

/* SET TRANSACTION ISOLATION LEVEL SERIALIZABLE;    */

CALL transaction2();

/*  fenetre 2 */

delimiter ;

CALL transaction1();

select * from T_passagers_pax;


/*  deadlock */

/*

delimiter ;
DELETE FROM T_vols ;
INSERT INTO T_vols 
  VALUES('AF6140','20121228','18:15:00','19:45:00',50,'TLS','ORY');
INSERT INTO T_vols VALUES
  ('AF6144','20121228','19:55:00','20:45:00',50,'TLS','LYS');

*/


delimiter $

DROP PROCEDURE transaction1$
CREATE PROCEDURE transaction1()
BEGIN
 START TRANSACTION;
 UPDATE T_vols 
        SET vol_places_libres = vol_places_libres - 7
        WHERE vol_num     = 'AF6140'
        AND   vol_datevol ='2012-12-28';
 SELECT SLEEP(5);
 UPDATE T_vols 
        SET vol_places_libres = vol_places_libres - 4
        WHERE vol_num     = 'AF6144'
        AND   vol_datevol ='2012-12-28';
COMMIT;
END;
$

DROP PROCEDURE transaction2$
CREATE PROCEDURE transaction2()
BEGIN
 START TRANSACTION;
 UPDATE T_vols 
        SET vol_places_libres = vol_places_libres - 5
        WHERE vol_num     = 'AF6144'
        AND   vol_datevol ='2012-12-28';
 SELECT SLEEP(5);
 UPDATE T_vols 
        SET vol_places_libres = vol_places_libres - 3
        WHERE vol_num     = 'AF6140'
        AND   vol_datevol ='2012-12-28';
COMMIT;
END;
$


/* fenetre 1  */

delimiter ;
CALL transaction1();

/*  fenetre 2 */

delimiter;
CALL transaction2();

select * from T_vols;

/* manual locks */

/*
SET autocommit=0;
LOCK TABLES T_vols WRITE;
... do something with tables t1 and t2 here ...
COMMIT;
UNLOCK TABLES;
*/

/* fenetre 1 */

delimiter ;

SET autocommit=0;
LOCK TABLES T_vols WRITE;
  UPDATE T_vols 
        SET vol_places_libres = vol_places_libres - 7
        WHERE vol_num     = 'AF6140'
        AND   vol_datevol ='2012-12-28';
 SELECT SLEEP(5);
 UPDATE T_vols 
        SET vol_places_libres = vol_places_libres - 4
        WHERE vol_num     = 'AF6144'
        AND   vol_datevol ='2012-12-28';
 COMMIT;
UNLOCK TABLES;


/* fenetre 2 */

delimiter ;

SET autocommit=0;
UPDATE T_vols 
        SET vol_places_libres = vol_places_libres - 5
        WHERE vol_num     = 'AF6144'
        AND   vol_datevol ='2012-12-28';
SELECT SLEEP(5);
UPDATE T_vols 
        SET vol_places_libres = vol_places_libres - 3
        WHERE vol_num     = 'AF6140'
        AND   vol_datevol ='2012-12-28';
COMMIT;


select * from T_vols;

DROP TABLE T_vols;
DROP TABLE T_passagers_pax;
