
CREATE TABLE bdutil.Compagnie
 (comp    CHAR(4),
  nrue    INTEGER(3),
  rue     VARCHAR(20),
  ville   VARCHAR(15) DEFAULT 'Paris' 
           COMMENT 'Par defaut : Paris',
  nomComp VARCHAR(15) NOT NULL);

desc bdutil.Compagnie;

DROP TABLE bdutil.Compagnie;

CREATE TABLE bdutil.Compagnie
(comp    CHAR(4),  nrue    INTEGER(3),
  rue   VARCHAR(20),  ville   VARCHAR(15) 
     DEFAULT 'Paris' COMMENT 'Par defaut : Paris',
  nomComp VARCHAR(15) NOT NULL,
 CONSTRAINT pk_Compagnie PRIMARY KEY(comp));

 
CREATE TABLE bdutil.Pilote
(brevet VARCHAR(6), nom VARCHAR(30) NOT NULL,
 pseudo VARCHAR(8),
 nbHVol DECIMAL(7,2), compa CHAR(4),
 CONSTRAINT pk_Pilote PRIMARY KEY(brevet),
 CONSTRAINT ck_nbHVol CHECK (nbHVol BETWEEN 1000 AND 20000),
 CONSTRAINT un_nom UNIQUE (nom),
 CONSTRAINT fk_Pil_compa_Comp FOREIGN KEY (compa) 
    REFERENCES bdutil.Compagnie(comp));


CREATE UNIQUE INDEX idx_Pilote_pseudo
	USING BTREE
	ON bdutil.Pilote (pseudo);

-- essai du check permissif

INSERT INTO bdutil.Pilote (brevet,nom,pseudo,nbHVol,compa)
 VALUES ('PL34', 'Ferrage', 'jpf', 700, NULL);


SHOW CREATE TABLE bdutil.Compagnie;
SHOW FULL COLUMNS FROM bdutil.Compagnie;
SHOW CREATE TABLE bdutil.Pilote;
SHOW FULL COLUMNS FROM bdutil.Pilote;

DESCRIBE bdutil.Pilote;
DESCRIBE bdutil.Compagnie;

USE bdutil;

CREATE UNIQUE INDEX idx_Pilote_nom3
	USING BTREE
	ON bdutil.Pilote (nom(3) DESC);

CREATE INDEX idx_Pilote_compa
	USING BTREE
	ON bdutil.Pilote(compa);


/*  passe pas de 5.1  5.7 */

DROP TABLE bdutil.Compagnie CASCADE;

/* */

DROP INDEX idx_Pilote_nom3 ON bdutil.Pilote;
ALTER TABLE bdutil.Pilote 
       DROP FOREIGN KEY fk_Pil_compa_Comp;
DROP INDEX idx_Pilote_compa ON bdutil.Pilote;
DROP TABLE bdutil.Compagnie;
DROP TABLE bdutil.Pilote;

/*  ou */

DROP TABLE bdutil.Pilote;
DROP TABLE bdutil.Compagnie;
