
/* DATE + n (jours) */

SELECT ADDDATE('2011-01-02', 54);

/* DATETIME + n (jours) */

SELECT ADDDATE('2011-11-01 18:50:00', 54);

/* TIME + TIME */

SELECT ADDTIME('01:00:00.999999', '02:00:00.999998');

/* TIME + n (secondes) */

SELECT ADDTIME('01:00:00.999999', 54);

/* DATE ou DATETIME + - INTERVAL */
	
SELECT DATE_ADD('2011-11-01 18:50:00',
                INTERVAL '1 1:1:1' DAY_SECOND);

SELECT DATE_SUB('2011-11-01',INTERVAL '1' DAY);

SELECT DATE_ADD('2011-11-01',INTERVAL '1' DAY);

SELECT DATEDIFF(SYSDATE(),'1965-02-05');

SELECT DATEDIFF(SYSDATE(),'1995-05-13');

CREATE TABLE Pilote
 (brevet VARCHAR(6), nom VARCHAR(20), dateNaiss DATETIME, dernierVol DATE,
  dateEmbauche DATETIME, prochainVolControle DATETIME, 
  nombreJoursNaisBoulot INTEGER(5),
  intervalleNaisBoulot DECIMAL(20,6), 
  intervalleVolExterieur DECIMAL(10,6),
  intervalleEntreVols DECIMAL(10,6),
  intervalleEmbaucheControle TIME,
  compa VARCHAR(4), CONSTRAINT pk_Pilote PRIMARY KEY(brevet));

INSERT INTO Pilote 
 (brevet,nom,dateNaiss,dernierVol,dateEmbauche,prochainVolControle,
  nombreJoursNaisBoulot,intervalleNaisBoulot,intervalleVolExterieur,
  intervalleEntreVols,intervalleEmbaucheControle,compa)
 VALUES 
 ('PL-1', 'Thierry Albaric','1967-03-25','2010-07-30', SYSDATE(),
  '2010-10-03 15:30:00', NULL, NULL, NULL, NULL, NULL, 'AF');

SELECT * FROM Pilote;

UPDATE Pilote 
 SET dateNaiss = '1967-03-25 12:35:00' 
 WHERE brevet = 'PL-1';

SELECT nom, dateNaiss FROM Pilote;

SELECT nom, dateEmbauche FROM Pilote;

SELECT nom, dernierVol FROM Pilote;

SELECT nom, prochainVolControle FROM Pilote;

UPDATE Pilote
 SET dateEmbauche = DATE_ADD(dateEmbauche,
                INTERVAL  '7 0:10' DAY_MINUTE)
 WHERE brevet = 'PL-1';

SELECT nom, dateEmbauche FROM Pilote;

UPDATE Pilote
	SET nombreJoursNaisBoulot = DATEDIFF(dateEmbauche,dateNaiss)
	 WHERE brevet = 'PL-1';

SELECT TIMESTAMPDIFF(SECOND,dateNaiss,dateEmbauche)/(24*3600) "j" FROM Pilote;
SELECT TIMESTAMPDIFF(SECOND,dernierVol,prochainVolControle)/(24*3600) "j" FROM Pilote;
SELECT TIMESTAMPDIFF(SECOND,dernierVol,dateEmbauche)/(24*3600) "j" FROM Pilote;

UPDATE Pilote
 SET intervalleNaisBoulot   = TIMESTAMPDIFF(SECOND,dateNaiss,dateEmbauche)/(24*3600) ,
     intervalleEntreVols    = TIMESTAMPDIFF(SECOND,dernierVol,prochainVolControle)/(24*3600) ,
     intervalleVolExterieur = TIMESTAMPDIFF(SECOND,dernierVol,dateEmbauche)/(24*3600) 
 WHERE brevet = 'PL-1';


SELECT dateNaiss,dateEmbauche,intervalleNaisBoulot FROM Pilote;
SELECT dernierVol,prochainVolControle,intervalleEntreVols FROM Pilote;
SELECT dateEmbauche,dernierVol,intervalleVolExterieur  FROM Pilote;

SELECT nombreJoursNaisBoulot  FROM Pilote;

SELECT(intervalleEntreVols - intervalleVolExterieur) FROM Pilote;
SELECT SEC_TO_TIME((intervalleEntreVols - intervalleVolExterieur)*24*3600) FROM Pilote;

UPDATE Pilote 
 SET intervalleEmbaucheControle =
      SEC_TO_TIME((intervalleEntreVols - intervalleVolExterieur)*24*3600) 
 WHERE brevet = 'PL-1';

SELECT * FROM Pilote;


/* Fonctions DATE */
    
SELECT DATE_FORMAT(SYSDATE(),'%j');    
SELECT DATE_FORMAT(dateNaiss,'%W en %M %X') FROM Pilote;
SELECT STR_TO_DATE('16/08/2011 15:37:42','%d/%m/%Y %H:%i:%s');

SELECT EXTRACT(DAY FROM dateEmbauche) FROM Pilote;
SELECT EXTRACT(MONTH FROM dateNaiss) FROM Pilote;	
SELECT UNIX_TIMESTAMP(SYSDATE())/(24*3600);

SELECT FROM_DAYS(366);    
    
DROP TABLE Pilote;