
CREATE TABLE Compagnie
(comp VARCHAR(4), nrue INTEGER(3),
 rue VARCHAR(20), ville VARCHAR(15), nomComp VARCHAR(15),
 CONSTRAINT pk_Compagnie PRIMARY KEY(comp));

CREATE TABLE Pilote
(brevet VARCHAR(6), nom VARCHAR(15),
 nbHVol DECIMAL(7,2), compa VARCHAR(4),
 CONSTRAINT pk_Pilote PRIMARY KEY(brevet),
 INDEX (compa),
 CONSTRAINT fk_Pil_compa_Comp FOREIGN KEY (compa) REFERENCES Compagnie(comp));

CREATE TABLE Avion
 (immat VARCHAR(6), typeAvion VARCHAR(15), nbhVol DECIMAL(10,2), proprio VARCHAR(4) NOT NULL,
 CONSTRAINT pk_Avion PRIMARY KEY(immat),
 INDEX (proprio),
 CONSTRAINT fk_Avion_comp_Compag FOREIGN KEY(proprio) REFERENCES Compagnie(comp));

CREATE TABLE Affreter
 (compAff VARCHAR(4), immat VARCHAR(6), dateAff DATE, nbPax INTEGER(3),
 CONSTRAINT pk_Affreter PRIMARY KEY (compAff, immat, dateAff),
 INDEX (immat),
 CONSTRAINT fk_Aff_na_Avion FOREIGN KEY(immat) REFERENCES Avion(immat),
 INDEX (compAff),
 CONSTRAINT fk_Aff_comp_Compag FOREIGN KEY(compAff) REFERENCES Compagnie(comp));


INSERT INTO Compagnie
	VALUES ('AF', 10, 'Gambetta', 'Paris', 'Air France');
INSERT INTO Compagnie
   VALUES ('SING', 7, 'Camparols', 'Singapour', 'Singapore AL');

INSERT INTO Pilote
 VALUES ('PL-1', 'Ferrage', 450, 'AF');
INSERT INTO Pilote
 VALUES ('PL-2', 'Roux', 900, 'AF');
INSERT INTO Pilote VALUES 
 ('PL-3', 'Guibert', 1000, 'SING');
INSERT INTO Pilote VALUES 
 ('PL-4', 'UnConnu', 0, NULL);

INSERT INTO Pilote VALUES 
 ('PL-5', 'PbdeCompagnie', 0, '?');

INSERT INTO Avion VALUES 
('F-WTSS', 'Concorde', 6570, 'SING');
INSERT INTO Affreter VALUES
('AF', 'F-WTSS', '2003-05-13', 82);

DROP TABLE Affreter;
DROP TABLE Avion;
DROP TABLE Pilote;
DROP TABLE Compagnie;
