/* Collations */
  
SHOW CHARACTER SET ;

SELECT @@character_set_server, @@collation_server;

DROP TABLE bdutil.Compagnie;

CREATE TABLE bdutil.Compagnie
 (comp     VARCHAR(6), 
  ville    VARCHAR(30) CHARACTER SET latin1 COLLATE latin1_general_cs,
  nom_comp VARCHAR(20) CHARACTER SET latin1 COLLATE latin1_general_ci
 ) DEFAULT CHARACTER SET utf8 COLLATE utf8_bin;

-- latin1_bin  (ABOYZaboyzoe)
-- latin1_general_cs (AaBbOoYyZzoe)
-- latin1_general_ci (AaBbOoYyZzoe)
-- utf8_general_ci pas sensible aux accents

INSERT INTO bdutil.Compagnie(comp,ville,nom_comp) VALUES ('AF', 'Paris', 'Air France');
INSERT INTO bdutil.Compagnie(comp,ville,nom_comp) VALUES ('af', 'paris', 'air france');

INSERT INTO bdutil.Compagnie(comp,ville,nom_comp) VALUES ('ae', 'agen', 'air Agen');
INSERT INTO bdutil.Compagnie(comp,ville,nom_comp) VALUES ('', 'AGEN', 'AIR AGEN');

INSERT INTO bdutil.Compagnie(comp,ville,nom_comp) VALUES ('ab', 'bziers', 'air 34');
INSERT INTO bdutil.Compagnie(comp,ville,nom_comp) VALUES ('AB', 'beziers', 'AIR 34');

SELECT * FROM bdutil.Compagnie;

--    With DISTINCT:

SELECT DISTINCT comp
FROM   bdutil.Compagnie;

SELECT DISTINCT comp COLLATE utf8_general_ci 
FROM   bdutil.Compagnie;
 
--    With GROUP BY:

SELECT ville, COUNT(*) AS nb_compagnies 
FROM   bdutil.Compagnie
GROUP BY ville;

SELECT UPPER(ville) AS ville, COUNT(*) AS nb_compagnies 
FROM   bdutil.Compagnie
GROUP BY ville COLLATE latin1_general_ci;

-- order by / + AS

SELECT comp, ville, nom_comp 
FROM   bdutil.Compagnie
ORDER BY ville COLLATE latin1_bin;
	
SELECT comp COLLATE utf8_bin AS code, ville, nom_comp 
FROM   bdutil.Compagnie
ORDER BY code;
	
--    With WHERE:

SELECT comp, ville, nom_comp 
FROM   bdutil.Compagnie
WHERE  ville COLLATE latin1_general_ci = 'PARIS'
AND    nom_comp = 'AIR FRANCE'
ORDER BY comp;

-- With HAVING, LIKE    With aggregate functions: MAX, MIN...
