
/* vnements */

delimiter ;

SHOW VARIABLES LIKE 'event_scheduler';

/* sous root */

GRANT EVENT ON bdsoutou.* TO 'soutou'@'localhost';

GRANT SUPER ON *.* TO 'soutou'@'localhost'
     IDENTIFIED BY 'soutou';
FLUSH PRIVILEGES;
exit;

/* sous utilisateur */

SET GLOBAL event_scheduler = 1;

SHOW VARIABLES LIKE 'event_scheduler';

/* compter les passagers d'un vol */


DROP TABLE IF EXISTS Vols;
DROP TABLE IF EXISTS Trace;

CREATE TABLE Trace
(num_vol CHAR(6), heure_comptage TIMESTAMP, nombre_pax INT);

CREATE TABLE Vols
(num_vol CHAR(6), date_vol DATE, num_client INT, date_resa TIMESTAMP);

INSERT INTO Vols
 (num_vol,date_vol,num_client) VALUES ('AF6143', SYSDATE(), 170);

delimiter $

DROP EVENT evolution_reservations_AF6143$

CREATE EVENT evolution_reservations_AF6143
    ON SCHEDULE 
    EVERY 1 MINUTE 
    ENDS CURRENT_TIMESTAMP + INTERVAL 2 HOUR
 ON COMPLETION PRESERVE
 COMMENT 'Comptage des rservations du vol AF6143 pour ce jour'
 DO 
   BEGIN
        DECLARE v_numvol CHAR(6) DEFAULT 'AF6143';
        DECLARE v_nbre_pax INT   DEFAULT 0;
        SELECT COUNT(num_client) INTO v_nbre_pax FROM Vols
	   WHERE EXTRACT(DAY FROM date_vol) = 
                 EXTRACT(DAY FROM CURRENT_TIMESTAMP)
           AND   EXTRACT(MONTH FROM date_vol) = 
                 EXTRACT(MONTH FROM CURRENT_TIMESTAMP)
           AND   EXTRACT(YEAR FROM date_vol) = 
                 EXTRACT(YEAR FROM CURRENT_TIMESTAMP) 
           AND num_vol  = v_numvol ;
        INSERT INTO Trace (num_vol,nombre_pax) VALUES
             (v_numvol,v_nbre_pax);
    END;
$

delimiter ;

INSERT INTO Vols
 (num_vol,date_vol,num_client) VALUES ('AF6143', SYSDATE(), 10);
INSERT INTO Vols
 (num_vol,date_vol,num_client) VALUES ('BA450', SYSDATE(), 105);
INSERT INTO Vols
 (num_vol,date_vol,num_client) VALUES ('AF6143', SYSDATE(), 210);
INSERT INTO Vols
 (num_vol,date_vol,num_client) VALUES ('AF6143', SYSDATE(), 40);
INSERT INTO Vols
 (num_vol,date_vol,num_client) VALUES ('AF6143', SYSDATE(), 678);
INSERT INTO Vols
 (num_vol,date_vol,num_client) VALUES ('AF6143', SYSDATE(), 198);
INSERT INTO Vols
 (num_vol,date_vol,num_client) VALUES ('AF6144', SYSDATE(), 670);
INSERT INTO Vols
 (num_vol,date_vol,num_client) VALUES ('AF6143', SYSDATE(), 193);

SELECT * FROM Vols;
SELECT * FROM Trace;

/* DD */

DESC INFORMATION_SCHEMA.EVENTS;

SELECT 
EVENT_SCHEMA,EVENT_NAME,STATUS,LAST_EXECUTED,EVENT_COMMENT
FROM INFORMATION_SCHEMA.EVENTS
WHERE STATUS='ENABLED' AND EVENT_TYPE='RECURRING';

SELECT 
STARTS,EXECUTE_AT,ENDS,INTERVAL_VALUE,INTERVAL_FIELD,
SQL_MODE,EVENT_TYPE,EVENT_BODY
FROM INFORMATION_SCHEMA.EVENTS
WHERE EVENT_NAME='evolution_reservations_AF6143';

/* Modification */

/* a s'arrte...*/

ALTER EVENT evolution_reservations_AF6143 DISABLE ;

SELECT 
EVENT_SCHEMA,EVENT_NAME,STATUS,EVENT_DEFINITION,
EVENT_TYPE
FROM INFORMATION_SCHEMA.EVENTS;

SELECT * FROM Trace;

/* a repart jusqu'au ENDS ...*/

ALTER EVENT evolution_reservations_AF6143 ENABLE ;

SELECT 
STARTS,EXECUTE_AT,ENDS,INTERVAL_VALUE,INTERVAL_FIELD,
SQL_MODE,EVENT_TYPE,EVENT_BODY
FROM INFORMATION_SCHEMA.EVENTS
WHERE EVENT_NAME='evolution_reservations_AF6143';

SELECT * FROM Trace;

/* modif du code rsa de la veille*/

delimiter $

ALTER EVENT evolution_reservations_AF6143
 DO 
   BEGIN
        DECLARE v_numvol CHAR(6) DEFAULT 'AF6143';
        DECLARE v_nbre_pax INT   DEFAULT 0;
        SELECT COUNT(num_client) INTO v_nbre_pax FROM Vols
	   WHERE EXTRACT(DAY FROM date_vol) = 
                 EXTRACT(DAY FROM CURRENT_TIMESTAMP) -1
           AND   EXTRACT(MONTH FROM date_vol) = 
                 EXTRACT(MONTH FROM CURRENT_TIMESTAMP)
           AND   EXTRACT(YEAR FROM date_vol) = 
                 EXTRACT(YEAR FROM CURRENT_TIMESTAMP) 
           AND num_vol  = v_numvol ;
        INSERT INTO Trace (num_vol,nombre_pax) VALUES
             (v_numvol,v_nbre_pax);
    END;
$

delimiter ;
SELECT * FROM Trace;