<?xml version="1.0" encoding="ISO-8859-1" ?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns="http://www.w3.org/TR/REC-html40" 
                version='1.0'>
<xsl:output encoding='ISO-8859-1' indent='yes' />

<xsl:variable name='observations'  
              select="//obs[not(./loc=preceding::*/loc)]" />

<xsl:variable name='effectif' select="count($observations)" />

<xsl:variable name="tempMoyenne">
  <xsl:value-of select="sum($observations/temp) div $effectif" />
</xsl:variable>

<xsl:template match="meteo">
<html>
   <head><title>Relevs mtorologiques</title></head>
   <body><h1>Situation mtorologique observe <br/>
   le <xsl:value-of select="substring(@period,9,2)"/> &#x002f; 
 <xsl:value-of select="substring(@period,6,2)"/> 
    <xsl:value-of select="substring-after(@period,'T')"/> heures</h1>
     <table>
       <tr align='center'><th>Ville</th><th>Temprature</th>
         <th>Hygromtrie</th><th>Nbulosit</th><th>Vent</th>
         <th>Prcipitations</th></tr>

<xsl:for-each select='$observations'>
   <xsl:sort select="loc" order="ascending" lang="FR" data-type="text"/>
   <tr align='center'><xsl:apply-templates /></tr>
</xsl:for-each>
</table>
<p>Nombre d'observations : <xsl:value-of select='$effectif' /></p>
<p>Temprature moyenne: <xsl:value-of select='$tempMoyenne' /> </p>
</body></html>
</xsl:template>

<xsl:template match="loc"><td><xsl:apply-templates /></td></xsl:template>
<xsl:template match="temp"><td><xsl:apply-templates /></td></xsl:template>
<xsl:template match="hygro">
    <td><xsl:apply-templates /></td></xsl:template>
<xsl:template match="nebulo">
    <td><xsl:apply-templates /></td></xsl:template>
<xsl:template match="anemo">
    <td><xsl:apply-templates /></td></xsl:template>
<xsl:template match="pluvio">
    <td><xsl:apply-templates /></td></xsl:template>
<xsl:template match="date"></xsl:template>
<xsl:template match="commentaire"></xsl:template>

</xsl:stylesheet>
