<?xml version='1.0' encoding='ISO-8859-1' ?>
<xsl:stylesheet	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
					xmlns="http://www.w3.org/TR/REC-html40" 
                version='1.0'>

<!-- traitement du titre pour le header html -->
<xsl:template mode="entete" match="doc/titre" >
	<xsl:apply-templates select="text()" />
</xsl:template>

<!--  traitement du titre pour la table tdm  -->
<xsl:template mode="tdm" match="doc/titre" >
	<div class="tdm0"><xsl:apply-templates select="text()" /></div>
</xsl:template>

<!-- traitement du titre pour le corps -->
<xsl:template match="doc/titre">
	<h1><xsl:apply-templates select="text()" /></h1>
</xsl:template>

<!-- traitement des titres de section pour la tdm -->
<xsl:template mode="tdm" match="section[@niv='1']/titre" >
	<div class="tdm1"><xsl:apply-templates select="text()" /></div>
</xsl:template>

<!-- traitement des titres de sections pour le corps -->
<xsl:template match="section[@niv='1']/titre" >
	<h2><xsl:apply-templates select="text()" /></h2>
</xsl:template>

<!-- traitement des paragraphes pour le corps -->
<xsl:template match="para">
	<p><xsl:apply-templates select="text()"/></p>
</xsl:template>

<!-- traitement de la racine  -->
<xsl:template match="/">
<html>
	<head>  <!-- creation en tete  -->
		<title><xsl:apply-templates mode="entete" select="doc/titre"/> 
		</title>
	</head>
	<body>  <!-- creation tdm -->
		<div class="tdm">
			<xsl:apply-templates mode="tdm" select=".//titre" /></div>
		<hr/><p></p>
		  <!-- traitement du corps  -->
		<xsl:apply-templates />
	</body>
</html>
</xsl:template>
</xsl:stylesheet>
