<?xml version='1.0' encoding='ISO-8859-1' ?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" >
<!-- rgle de formatage des items d'une liste -->
<!-- par dfaut, numrotation en chiffres de 1  N  -->
<xsl:template name="numliste">
<xsl:param name="lfmt">--1-- </xsl:param>
<xsl:for-each select="./item">
<p><xsl:number value="position()" format="{$lfmt}" />
	<xsl:value-of select="." /></p>
</xsl:for-each>
</xsl:template>
<!-- traitement d'une liste dans attribut connu -->
<xsl:template match="liste">
	<xsl:call-template name="numliste" />
</xsl:template>
<!-- traitements pour les cinq valeurs connues de l'attribut puce -->
<xsl:template match="liste[@puce='RMIN']" >
	<xsl:call-template name="numliste" >
			<xsl:with-param name="lfmt">-i- </xsl:with-param>
	</xsl:call-template>
</xsl:template>
<xsl:template match="liste[@puce='LMIN']" >
	<xsl:call-template name="numliste" >
			<xsl:with-param name="lfmt">-a- </xsl:with-param>
	</xsl:call-template>
</xsl:template>
<xsl:template match="liste[@puce='LMAJ']" >
	<xsl:call-template name="numliste" >
			<xsl:with-param name="lfmt">-A- </xsl:with-param>
	</xsl:call-template>
</xsl:template>
<xsl:template match="liste[@puce='RMAJ']" >
	<xsl:call-template name="numliste" >
			<xsl:with-param name="lfmt">-I- </xsl:with-param>
	</xsl:call-template>
</xsl:template>
</xsl:stylesheet>
