Imports System.ComponentModel
Imports System.Drawing
Imports System.WinForms
Imports System.Math


Public Class Form1
    Inherits System.WinForms.Form

    Public Sub New()
        MyBase.New

        Form1 = Me

        'This call is required by the Win Form Designer.
        InitializeComponent

        'TODO: Add any initialization after the InitializeComponent() call
    End Sub

    'Form overrides dispose to clean up the component list.
    Overrides Public Sub Dispose()
        MyBase.Dispose
        components.Dispose
    End Sub 

#Region " Windows Form Designer generated code "

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.Container
    Private WithEvents lstRes As System.WinForms.ListBox
    Private WithEvents cmdGo As System.WinForms.Button
    Private WithEvents txtNombre As System.WinForms.TextBox
    Private WithEvents Label1 As System.WinForms.Label
    
    Dim WithEvents Form1 As System.WinForms.Form

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Private Sub InitializeComponent()
        Me.components = New System.ComponentModel.Container()
        Me.cmdGo = New System.WinForms.Button()
        Me.lstRes = New System.WinForms.ListBox()
        Me.txtNombre = New System.WinForms.TextBox()
        Me.Label1 = New System.WinForms.Label()
        
        '@design Me.TrayHeight = 0
        '@design Me.TrayLargeIcon = False
        '@design Me.TrayAutoArrange = True
        cmdGo.Location = New System.Drawing.Point(184, 16)
        cmdGo.Size = New System.Drawing.Size(88, 23)
        cmdGo.TabIndex = 2
        cmdGo.Text = "Dcomposer"
        
        lstRes.Location = New System.Drawing.Point(24, 56)
        lstRes.Size = New System.Drawing.Size(152, 134)
        lstRes.TabIndex = 3
        
        txtNombre.Location = New System.Drawing.Point(72, 16)
        txtNombre.TabIndex = 1
        txtNombre.Size = New System.Drawing.Size(100, 20)
        
        Label1.Location = New System.Drawing.Point(16, 16)
        Label1.Text = "Nombre :"
        Label1.Size = New System.Drawing.Size(48, 16)
        Label1.TabIndex = 0
        
        Me.Text = "Dcomposition en nombres premiers"
        Me.MaximizeBox = False
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.BorderStyle = System.WinForms.FormBorderStyle.Fixed3D
        Me.MinimizeBox = False
        Me.ClientSize = New System.Drawing.Size(286, 211)
        
        Me.Controls.Add(lstRes)
        Me.Controls.Add(cmdGo)
        Me.Controls.Add(txtNombre)
        Me.Controls.Add(Label1)
    End Sub
    
#End Region
    
    Protected Sub cmdGo_Click(ByVal sender As Object, ByVal e As System.EventArgs)
        ' Fait la dcomposition
        Dim Facteurs() As Long
        Facteurs = Decompose(CLng(txtNombre.Text))
        
        ' Remplit la liste
        Dim n As Long
        lstRes.items.Clear()
        For Each n In Facteurs
            lstRes.Items.Add(n)
        Next
    End Sub
    
    '---- Dcompose un nombre en facteurs premiers
    Private Function Decompose(ByVal Nombre As Long) As Long()
        ' Tableau pour le rsultat
        Dim Res(1) As Long
        ' Nombre d'lments trouvs
        Dim nb As Integer : nb = 1
        ' Place le 1
        Res(0) = 1
        
        ' Diviseur courant
        Dim Div As Long : Div = 2
        ' Tant que le diviseur est infrieur ou gal au nombre
        Do While Div <= Nombre
            ' Tant que Div divise Nombre
            Do While Nombre Mod Div = 0
                ' Ajoute dans le tableau rsultat
                nb = nb + 1
                ReDim Preserve Res(nb)
                Res(nb - 1) = Div
                ' Nombre suivant
                Nombre = Nombre \ Div
            Loop
            ' Cherche le prochain premier
            Div = ProchainPremier(Div)
        Loop
        
        ' Rsultat
        Decompose = Res
    End Function
    
    '---- ProchainPremier : retourne le prochain nombre premier
    Private Function ProchainPremier(ByVal Nombre As Long) As Long
        Do
            Nombre = Nombre + 1
        Loop Until EstPremier(Nombre)
        ProchainPremier = Nombre
    End Function
    
    '---- EstPremier : indique si un nombre est premier
    Private Function EstPremier(ByVal Nombre As Long) As Boolean
        ' Positif seulement
        Nombre = Abs(Nombre)
        
        EstPremier = True
        If Nombre > 3 Then
            Dim i As Long
            For i = 2 To Nombre \ 2
                If Nombre Mod i = 0 Then
                    EstPremier = False
                    Exit For
                End If
            Next
        End If
    End Function
    
End Class
