Module Module1
    ' La classe Compte
    Class Compte
        ' Variable prive pour la proprit
        Private mSolde As Decimal
        
        ' Dclaration d'un vnement
        Event Debiteur(ByVal Solde As Decimal, ByRef Annulation As Boolean)
        
        ' Constructeur par dfaut
        Public Overloads Sub New()
            ' Solde initial
            mSolde = 0
        End Sub
        ' Constructeur avec un solde donn
        Public Overloads Sub New(ByVal SoldeInitial As Decimal)
            mSolde = SoldeInitial
        End Sub
        
        ' Proprit Solde
        ReadOnly Property Solde() As Decimal
            ' Lecture de la proprit
            Get
                Return mSolde
            End Get
        End Property
        
        ' Mthode Crediter
        Public Sub Crediter(ByVal Montant As Decimal)
            ' Nouveau solde
            Dim NouveauSolde As Decimal = mSolde + Montant
            ' Indicateur d'annulation
            Dim Annulation As Boolean = False
            ' Vrifie le nouveau solde
            If NouveauSolde < 0 Then
                ' Dbiteur, avertit le client
                RaiseEvent Debiteur(NouveauSolde, Annulation)
            End If
            
            ' Si annulation, le mouvement n'est pas valid
            If Not Annulation Then
                mSolde = NouveauSolde
            End If
        End Sub
    End Class
    
    ' Dfinit une variable pour le compte
    Dim WithEvents cpt As Compte
    
    ' Point d'entre de l'application
    Sub Main()
        ' Cre le compte
        cpt = New Compte()
        
        ' Crdite 1000
        cpt.Crediter(1000)
        
        ' Affiche le nouveau solde
        Console.WriteLine("Le solde aprs crdit de 1000 est : " & cpt.Solde)
        
        ' Dbite 1400
        cpt.Crediter(-1400)
        
        ' Affiche le nouveau solde
        Console.WriteLine("Le solde aprs dbit de 1400 est : " & cpt.Solde)
        
        ' Dbite 1000
        cpt.Crediter(-1000)
        
        ' Affiche le nouveau solde
        Console.WriteLine("Le solde aprs dbit de 1000 est : " & cpt.Solde)
        
        ' Attend une touche
        Console.Read()
    End Sub
    
    ' Traitement de l'vnement Debiteur pour un compte
    Public Sub CompteDebiteur(ByVal Solde As Decimal, ByRef Annulation As Boolean) Handles cpt.Debiteur
        ' Affiche le nouveau solde
        Console.WriteLine("Le compte est dbiteur. Nouveau solde : " & solde)
        ' Annule l'opration si le solde est infrieur  -1000
        Annulation = CBool(Solde < -1000)
    End Sub
End Module
