Module Module1
    ' La classe de base abstraite Compte
    MustInherit Class Compte
        ' Variable prive pour la proprit
        Protected mSolde As Decimal
        
        ' Dclaration d'un vnement
        Event Debiteur(ByVal Solde As Decimal, ByRef Annulation As Boolean)
        
        ' Constructeur par dfaut
        Public Overloads Sub New()
            ' Solde initial
            mSolde = 0
        End Sub
        ' Constructeur avec un solde donn
        Public Overloads Sub New(ByVal SoldeInitial As Decimal)
            mSolde = SoldeInitial
        End Sub
        
        ' Proprit Solde
        Public NotOverridable ReadOnly Property Solde() As Decimal
            ' Lecture de la proprit
            Get
                Return mSolde
            End Get
        End Property
        
        ' Prototype de la mthode Crediter
        Public MustOverride Sub Crediter(ByVal Montant As Decimal)
    End Class
    
    ' La classe CompteNormal
    Class CompteNormal : Inherits Compte
        ' Constructeur par dfaut
        Public Overloads Sub New()
            MyBase.New()
        End Sub
        Public Overloads Sub New(ByVal SoldeInitial As Decimal)
            MyBase.New(SoldeInitial)
        End Sub
        
        ' Mthode Crediter
        Public Overridable Overrides Sub Crediter(ByVal Montant As Decimal)
            ' Nouveau solde
            Dim NouveauSolde As Decimal = mSolde + Montant
            ' Indicateur d'annulation
            Dim Annulation As Boolean = False
            ' Vrifie le nouveau solde
            If NouveauSolde < 0 Then
                ' Dbiteur, avertit le client
                RaiseEvent Debiteur(NouveauSolde, Annulation)
            End If
            
            ' Si annulation, le mouvement n'est pas valid
            If Not Annulation Then
                mSolde = NouveauSolde
            End If
        End Sub
    End Class
    
    ' Une classe drive, CompteEpargne
    Class CompteEpargne : Inherits CompteNormal
        ' Evnement spcifique
        Event Debit(ByVal Montant As Decimal)
        
        ' Constructeurs
        Public Overloads Sub New()
            MyBase.New()
        End Sub
        Public Overloads Sub New(ByVal SoldeInitial As Decimal)
            MyBase.New(SoldeInitial)
        End Sub
        
        ' Mthode redfinie Crediter
        Overrides Sub Crediter(ByVal Montant As Decimal)
            ' Ce compte interdit les dbits (!)
            If Montant > 0 Then
                ' Appelle la mthode de la classe de base
                MyBase.Crediter(Montant)
            Else
                ' Gnre un vnement spcifique
                RaiseEvent Debit(montant)
            End If
        End Sub
        
        ' Proprit spcifique
        Public ReadOnly Property Interets() As Decimal
            Get
                ' Calcul totalement fantaisiste !
                Interets = Solde * 5 / 100
            End Get
        End Property
    End Class
    
    ' Point d'entre de l'application
    Sub Main()
        ' Compte normal
        Dim cptNormal As New CompteNormal()
        ' Compte pargne
        Dim cptEpargne As New CompteEpargne()
        
        ' Gestionnaires d'vnement pour les comptes
        AddHandler cptNormal.Debiteur, AddressOf CompteDebiteur
        AddHandler cptEpargne.Debiteur, AddressOf CompteDebiteur
        AddHandler cptEpargne.Debit, AddressOf Debit
        
        ' Compte normal
        With cptNormal
            Console.WriteLine("*** Compte normal ***")
            console.WriteLine(.Solde)
            ' Ajoute 500
            .Crediter(500)
            ' Retire 1000
            .Crediter(-1000)
            ' Affiche le nouveau solde
            Console.WriteLine("Solde compte normal : " & .solde)
        End With
        
        ' Compte pargne
        With cptEpargne
            Console.WriteLine("*** Compte pargne ***")
            ' Ajoute 500
            .Crediter(500)
            ' Retire 1000
            .Crediter(-1000)
            ' Affiche le nouveau solde
            Console.WriteLine("Solde compte pargne : " & .solde)
        End With
        
        ' Attend une touche
        Console.Read()
        
        ' Dconnecte les gestionnaires d'vnements
        RemoveHandler cptNormal.Debiteur, AddressOf CompteDebiteur
        RemoveHandler cptEpargne.Debiteur, AddressOf CompteDebiteur
        RemoveHandler cptEpargne.Debit, AddressOf Debit
    End Sub
    
    ' Procdures de traitement des vnements
    Public Sub CompteDebiteur(ByVal Solde As Decimal, ByRef Annulation As Boolean)
        ' Affiche le nouveau solde
        Console.WriteLine("Le compte est dbiteur. Nouveau solde : " & solde)
        ' Annule l'opration si le solde est infrieur  -1000
        Annulation = CBool(Solde < -1000)
    End Sub
    
    Public Sub Debit(ByVal Montant As Decimal)
        ' Affiche un message
        Console.WriteLine("Tentative de dbit. Montant : " & Montant)
    End Sub
End Module
