Imports System.ComponentModel
Imports System.Drawing
Imports System.WinForms

Imports System.Reflection

Public Class Form1
    Inherits System.WinForms.Form

    Public Sub New()
        MyBase.New

        Form1 = Me

        'This call is required by the Win Form Designer.
        InitializeComponent

        'TODO: Add any initialization after the InitializeComponent() call
    End Sub

    'Form overrides dispose to clean up the component list.
    Overrides Public Sub Dispose()
        MyBase.Dispose
        components.Dispose
    End Sub 

#Region " Windows Form Designer generated code "

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.Container
    
    
    
    Private WithEvents btnSearch As System.WinForms.Button
    Private WithEvents txtSearch As System.WinForms.TextBox
    
    Private WithEvents Label7 As System.WinForms.Label
    Private WithEvents lblModule As System.WinForms.Label
    Private WithEvents Label5 As System.WinForms.Label
    Private WithEvents lblAssembly As System.WinForms.Label
    Private WithEvents Label3 As System.WinForms.Label
    Private WithEvents Label2 As System.WinForms.Label
    Private WithEvents Label1 As System.WinForms.Label
    Private WithEvents lblPath As System.WinForms.Label
    Private WithEvents lstInterfaces As System.WinForms.ListBox
    Private WithEvents lblNameSpace As System.WinForms.Label
    Private WithEvents Panel1 As System.WinForms.Panel
    Private WithEvents tv As System.WinForms.TreeView
    Private WithEvents btnRemplit As System.WinForms.Button
    
    
    Dim WithEvents Form1 As System.WinForms.Form

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Private Sub InitializeComponent()
        Me.components = New System.ComponentModel.Container()
        Me.lstInterfaces = New System.WinForms.ListBox()
        Me.lblAssembly = New System.WinForms.Label()
        Me.btnSearch = New System.WinForms.Button()
        Me.btnRemplit = New System.WinForms.Button()
        Me.lblModule = New System.WinForms.Label()
        Me.lblNameSpace = New System.WinForms.Label()
        Me.lblPath = New System.WinForms.Label()
        Me.Label7 = New System.WinForms.Label()
        Me.Panel1 = New System.WinForms.Panel()
        Me.txtSearch = New System.WinForms.TextBox()
        Me.Label5 = New System.WinForms.Label()
        Me.Label3 = New System.WinForms.Label()
        Me.tv = New System.WinForms.TreeView()
        Me.Label1 = New System.WinForms.Label()
        Me.Label2 = New System.WinForms.Label()
        
        '@design Me.TrayHeight = 0
        '@design Me.TrayLargeIcon = False
        '@design Me.TrayAutoArrange = True
        lstInterfaces.Location = New System.Drawing.Point(368, 16)
        lstInterfaces.Size = New System.Drawing.Size(144, 56)
        lstInterfaces.TabIndex = 1
        lstInterfaces.Anchor = System.WinForms.AnchorStyles.TopBottomRight
        lstInterfaces.Sorted = True
        
        lblAssembly.Location = New System.Drawing.Point(88, 56)
        lblAssembly.Size = New System.Drawing.Size(272, 16)
        lblAssembly.ForeColor = System.Drawing.Color.Navy
        lblAssembly.TabIndex = 6
        lblAssembly.Anchor = System.WinForms.AnchorStyles.TopLeftRight
        
        btnSearch.Location = New System.Drawing.Point(464, 488)
        btnSearch.Size = New System.Drawing.Size(64, 24)
        btnSearch.TabIndex = 6
        btnSearch.Anchor = System.WinForms.AnchorStyles.BottomLeftRight
        btnSearch.Text = "Cherche"
        
        btnRemplit.Location = New System.Drawing.Point(236, 488)
        btnRemplit.DialogResult = System.WinForms.DialogResult.OK
        btnRemplit.FlatStyle = System.WinForms.FlatStyle.Popup
        btnRemplit.Size = New System.Drawing.Size(75, 23)
        btnRemplit.TabIndex = 1
        btnRemplit.Anchor = System.WinForms.AnchorStyles.Bottom
        btnRemplit.Text = "Remplit liste"
        
        lblModule.Location = New System.Drawing.Point(88, 72)
        lblModule.Size = New System.Drawing.Size(272, 16)
        lblModule.ForeColor = System.Drawing.Color.Navy
        lblModule.TabIndex = 8
        lblModule.Anchor = System.WinForms.AnchorStyles.TopLeftRight
        
        lblNameSpace.Location = New System.Drawing.Point(88, 8)
        lblNameSpace.Size = New System.Drawing.Size(272, 16)
        lblNameSpace.ForeColor = System.Drawing.Color.Navy
        lblNameSpace.TabIndex = 0
        lblNameSpace.Anchor = System.WinForms.AnchorStyles.TopLeftRight
        
        lblPath.Location = New System.Drawing.Point(88, 24)
        lblPath.Size = New System.Drawing.Size(272, 32)
        lblPath.ForeColor = System.Drawing.Color.Navy
        lblPath.TabIndex = 2
        lblPath.Anchor = System.WinForms.AnchorStyles.TopLeftRight
        
        Label7.Location = New System.Drawing.Point(0, 72)
        Label7.Text = "Module"
        Label7.Size = New System.Drawing.Size(40, 13)
        Label7.AutoSize = True
        Label7.TabIndex = 9
        
        Panel1.BorderStyle = System.WinForms.BorderStyle.Fixed3D
        Panel1.Location = New System.Drawing.Point(8, 384)
        Panel1.Size = New System.Drawing.Size(520, 96)
        Panel1.TabIndex = 3
        Panel1.Anchor = System.WinForms.AnchorStyles.BottomLeftRight
        
        txtSearch.Location = New System.Drawing.Point(336, 488)
        txtSearch.TabIndex = 5
        txtSearch.Anchor = System.WinForms.AnchorStyles.BottomLeftRight
        txtSearch.Size = New System.Drawing.Size(120, 20)
        
        Label5.Location = New System.Drawing.Point(0, 56)
        Label5.Text = "Assembly"
        Label5.Size = New System.Drawing.Size(52, 13)
        Label5.AutoSize = True
        Label5.TabIndex = 7
        
        Label3.Location = New System.Drawing.Point(368, 0)
        Label3.Text = "Interfaces"
        Label3.Size = New System.Drawing.Size(52, 13)
        Label3.AutoSize = True
        Label3.TabIndex = 5
        Label3.Anchor = System.WinForms.AnchorStyles.TopRight
        
        tv.Location = New System.Drawing.Point(8, 8)
        tv.Size = New System.Drawing.Size(520, 368)
        tv.PathSeparator = "."
        tv.TabIndex = 2
        tv.Anchor = System.WinForms.AnchorStyles.All
        tv.Sorted = True
        
        Label1.Location = New System.Drawing.Point(0, 8)
        Label1.Text = "NameSpace"
        Label1.Size = New System.Drawing.Size(65, 13)
        Label1.AutoSize = True
        Label1.TabIndex = 3
        
        Label2.Location = New System.Drawing.Point(0, 24)
        Label2.Text = "Hirarchie"
        Label2.Size = New System.Drawing.Size(54, 13)
        Label2.AutoSize = True
        Label2.TabIndex = 4
        Me.Text = "Form1"
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(536, 517)
        
        Panel1.Controls.Add(Label7)
        Panel1.Controls.Add(lblModule)
        Panel1.Controls.Add(Label5)
        Panel1.Controls.Add(lblAssembly)
        Panel1.Controls.Add(Label3)
        Panel1.Controls.Add(Label2)
        Panel1.Controls.Add(Label1)
        Panel1.Controls.Add(lblPath)
        Panel1.Controls.Add(lstInterfaces)
        Panel1.Controls.Add(lblNameSpace)
        Me.Controls.Add(btnSearch)
        Me.Controls.Add(txtSearch)
        Me.Controls.Add(Panel1)
        Me.Controls.Add(tv)
        Me.Controls.Add(btnRemplit)
    End Sub
    
#End Region
    
    Protected Sub btnExtract_Click(ByVal sender As Object, ByVal e As System.EventArgs)
        ' Recherche le noeud de base
        Dim n As TreeNode
        n = SelectNode(tv.Nodes, "MarshalByRefComponent")
        ' Dump le sous-arbre
        If Not n Is Nothing Then
            ' Cre le fichier
            DumpNodes(n, 0)
        End If
    End Sub
    
    Private Sub DumpNodes(ByVal Node As TreeNode, ByVal Level As Integer)
        ' Dump Node
        txtExtract.Text &= New String(chr(9), Level) & Node.Text & chr(13) & chr(10)
        Level += 1
        Dim n As TreeNode
        For Each n In node.Nodes
            DumpNodes(n, Level)
        Next
    End Sub
    
    Protected Sub btnSearch_Click(ByVal sender As Object, ByVal e As System.EventArgs)
        If SelectNode(tv.Nodes, txtSearch.Text) Is Nothing Then MsgBox("Pas trouv !")
        tv.Focus()
    End Sub
    
    Protected Sub tv_AfterSelect(ByVal sender As Object, ByVal e As System.WinForms.TreeViewEventArgs)
        Try
            ' Rcupre le noeud slectionn
            Dim sn As TreeNode
            sn = CType(sender, TreeView).SelectedNode
            If sn Is Nothing Then Exit Sub
            Dim n As MyNode
            n = CType(sn, MyNode)
            ' et le type
            Dim t As Type
            t = n.theType
            ' Montre le chemin
            lblPath.Text = t.Name
            Dim bt As Type
            bt = t.BaseType
            Do While Not bt Is Nothing
                lblPath.Text = bt.Name & ":" & lblPath.Text
                bt = bt.BaseType
            Loop
            ' Assembly et module
            lblAssembly.Text = n.theAssembly.GetName.Name
            lblModule.Text = n.theModule.Name
            ' Remplit la liste d'interfaces
            lstInterfaces.Items.Clear()
            If Not t Is Nothing Then
                lblNameSpace.Text = t.Namespace
                Dim i As type
                For Each i In t.GetInterfaces
                    lstInterfaces.Items.Add(i.name)
                Next
            End If
        Catch
            lblNameSpace.Text = ""
            lblPath.Text = ""
            lblAssembly.Text = ""
            lblModule.Text = ""
            lstInterfaces.Items.Clear()
        End Try
    End Sub
    
    Protected Sub btnRemplit_Click(ByVal sender As Object, ByVal e As System.EventArgs)
        ' Liste des assemblies  traiter
        Dim asmTable() As String = {"mscorlib", "System.Data", "System.Net", "System.IO", "System.Messaging", _
            "System.Timers", "System.Web", "System.Web.Services", "System.WinForms", "System.Web.Services", _
            "System.Configuration", "System.Text.RegularExpressions", "System.Diagnostics", "System", "System.Drawing", _
            "System.Xml.Serialization", "System.Xml", "System.ServiceProcess", "System.Messaging", _
            "System.Runtime.Serialization.Formatters.Soap", "Microsoft.Win32.Interop"}
        
        tv.Nodes.Clear()
        Dim RootNode As TreeNode = tv.Nodes.Add("Classes")
        Dim OrphanNodes(1) As TreeNode
        
        ' Explore la liste des assemblies
        Dim asm As String
        For Each asm In asmTable
            Dim a As [Assembly]
            a = [Assembly].Load(asm)
            
            ' Explore les modules
            Dim m As [Module]
            For Each m In a.GetModules
                ' Explore les types
                Dim ts As Type() = m.GetTypes()
                Dim t As Type
                For Each t In ts
                    If t.IsPublic And (t.IsClass Or t.IsValueType) Then
                        ' Type de base
                        Dim bt As Type = t.BaseType
                        
                        ' Nouveau noeud
                        Dim n As New MyNode(t.Name)
                        n.theType = t
                        n.theAssembly = a
                        n.theModule = m
                        
                        ' Ajoute au noeud parent
                        Dim pn As TreeNode
                        If bt Is Nothing Then
                            ' Pas de parent, rattache  la racine
                            RootNode.Nodes.Add(n)
                        Else
                            pn = FindParentNode(RootNode, bt)
                            If pn Is Nothing Then
                                ' Parent pas encore dans l'arbre
                                Dim i As Integer
                                i = ubound(OrphanNodes)
                                ReDim Preserve OrphanNodes(i + 2)
                                OrphanNodes(i) = n
                            Else
                                ' Parent trouv
                                pn.Nodes.Add(n)
                            End If
                        End If
                    End If
                Next
            Next
        Next
        
        ' Recherche les parents des orphelins
        Dim n1 As MyNode
        For Each n1 In OrphanNodes
            If Not n1 Is Nothing Then
                Dim pn As TreeNode
                pn = FindParentNode(RootNode, n1.theType.BaseType)
                If Not pn Is Nothing Then
                    pn.Nodes.Add(n1)
                End If
            End If
        Next
    End Sub
    
    ' Cherche le noeud parent
    Private Function FindParentNode(ByVal StartNode As TreeNode, ByVal BaseType As Type) As MyNode
        ' Explore le noeud courant
        Dim n As TreeNode
        For Each n In StartNode.Nodes
            Dim mn As MyNode
            mn = CType(n, MyNode)
            ' Trouv ?
            If mn.theType = basetype Then
                ' Oui, le retourne
                Return mn
            Else
                ' Non, explore les sous-noeuds
                Dim pn As MyNode
                pn = FindParentNode(mn, BaseType)
                ' Trouv, le retourne
                If Not pn Is Nothing Then Return pn
            End If
        Next
        
        ' Pas trouv
        Return Nothing
    End Function
    
    ' Cherche le noeud correspondant  un texte
    Private Function SelectNode(ByVal NodeCollection As TreeNodeCollection, ByVal NodeText As String) As TreeNode
        Dim n As TreeNode
        For Each n In NodeCollection
            If n.Text = NodeText Then
                n.TreeView.SelectedNode = n
                Return n
            Else
                Dim n1 As TreeNode
                n1 = SelectNode(n.Nodes, NodeText)
                If Not n1 Is Nothing Then Return n1
            End If
        Next
        Return Nothing
    End Function
    
    'Protected Sub btnRemplit_Click(ByVal sender As Object, ByVal e As System.EventArgs)
    '    ' Liste des assemblies  traiter
    '    Dim asmTable() As String = {"mscorlib", "System.Data", "System.Net", "System.IO", "System.Messaging", _
    '        "System.Timers", "System.Web", "System.Web.Services", "System.WinForms", "System.Web.Services", _
    '        "System.Configuration", "System.Text.RegularExpressions", "System.Diagnostics", "System", "System.Drawing", _
    '        "System.Xml.Serialization", "System.Xml", "System.ServiceProcess", "System.Messaging", _
    '        "System.Runtime.Serialization.Formatters.Soap", "Microsoft.Win32.Interop"}
    
    '    tv.Nodes.Clear()
    
    '    ' Explore la liste des assemblies
    '    Dim asm As String
    '    For Each asm In asmTable
    '        Dim a As [Assembly]
    '        a = [Assembly].Load(asm)
    '        ' Ajoute le noeud
    '        Dim AssemblyNode As TreeNode
    '        AssemblyNode = tv.Nodes.Add(a.GetName.Name)
    
    '        ' Explore les modules
    '        Dim m As [Module]
    '        For Each m In a.GetModules
    '            ' Ajoute le module
    '            Dim ModuleNode As TreeNode
    '            ModuleNode = AssemblyNode.Nodes.Add(m.name)
    
    '            ' Explore les types
    '            Dim ts As Type() = m.GetTypes()
    '            Dim t As Type
    '            For Each t In ts
    '                If t.IsPublic And (t.IsClass Or t.IsValueType) Then
    '                    ' Type de base
    '                    Dim bt As Type = t.BaseType
    '                    ' Cherche le noeud parent
    '                    Dim pn As TreeNode
    '                    If bt Is Nothing Then
    '                        pn = ModuleNode
    '                    Else
    '                        pn = FindParentNode(ModuleNode, bt)
    '                        If pn Is Nothing Then pn = ModuleNode
    '                    End If
    
    '                    ' Nouveau noeud
    '                    Dim n As New MyNode(t.Name)
    '                    n.theType = t
    '                    n.theAssembly = a
    '                    n.theModule = m
    '                    ' L'ajoute
    '                    pn.Nodes.Add(n)
    '                End If
    '            Next
    '        Next
    '    Next
    'End Sub
    
    ' Cherche le noeud parent
    'Private Function FindParentNode(ByVal RootNode As TreeNode, ByVal BaseType As Type) As MyNode
    '    ' Explore le noeud courant
    '    Dim n As TreeNode
    '    For Each n In RootNode.Nodes
    '        Dim mn As MyNode
    '        mn = CType(n, MyNode)
    '        ' Trouv ?
    '        If mn.theType = basetype Then
    '            ' Oui, le retourne
    '            Return mn
    '        Else
    '            ' Non, explore les sous-noeuds
    '            Dim pn As MyNode
    '            pn = FindParentNode(mn, basetype)
    '            ' Trouv, le retourne
    '            If Not pn Is Nothing Then Return pn
    '        End If
    '    Next
    
    '    ' Pas trouv
    '    Return Nothing
    'End Function
End Class

Private Class MyNode : Inherits TreeNode
    Public Overloads Sub New()
        MyBase.New()
    End Sub
    
    Public Overloads Sub New(ByVal NodeText As String)
        MyBase.New(NodeText)
    End Sub
    
    Public theType As Type
    Public theAssembly As [Assembly]
    Public theModule As [Module]
End Class
